/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.15_09_2024__02_32_46.t\u043d\u0435;
import extracells.15_09_2024__02_32_46.\u0435hv;
import extracells.gridblock.ECBaseGridBlock;
import extracells.integration.Integration;
import extracells.network.GuiHandler;
import extracells.registries.ItemEnum;
import extracells.registries.PartEnum;
import extracells.render.TextureManager;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import mekanism.api.gas.IGasHandler;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class PartECBase
implements IPart,
IGridHost,
IActionHost,
IPowerChannelState {
    private IGridNode node;
    private ForgeDirection side;
    private IPartHost host;
    protected TileEntity tile;
    private ECBaseGridBlock gridBlock;
    private double powerUsage;
    private TileEntity hostTile;
    private IFluidHandler facingTank;
    private Object facingGasTank;
    private boolean redstonePowered;
    private boolean isActive;
    private boolean isPowerd = false;
    private EntityPlayer owner;

    public PartECBase() {
        PartECBase partECBase;
    }

    public void addToWorld() {
        PartECBase $;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        $.gridBlock = new ECBaseGridBlock($);
        $.node = AEApi.instance().createGridNode((IGridBlock)$.gridBlock);
        if ($.node != null) {
            if ($.owner != null) {
                $.node.setPlayerID(AEApi.instance().registries().players().getID($.owner));
            }
            $.node.updateState();
        }
        $.setPower(null);
        $.onNeighborChanged();
    }

    public abstract int cableConnectionRenderTo();

    public boolean canBePlacedOn(BusSupport busSupport) {
        return busSupport != BusSupport.DENSE_CABLE;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    protected final IAEFluidStack extractFluid(IAEFluidStack iAEFluidStack, Actionable actionable) {
        if ( .gridBlock == null ||  .facingTank == null) {
            return null;
        }
        IMEMonitor<IAEFluidStack> iMEMonitor =  .gridBlock.getFluidMonitor();
        if (iMEMonitor == null) {
            return null;
        }
        return (IAEFluidStack)iMEMonitor.extractItems((IAEStack)iAEFluidStack, actionable, (BaseActionSource)new MachineSource((IActionHost) ));
    }

    protected final IAEFluidStack extractGasFluid(IAEFluidStack iAEFluidStack, Actionable actionable) {
        if ( .gridBlock == null ||  .facingGasTank == null) {
            return null;
        }
        IMEMonitor<IAEFluidStack> iMEMonitor =  .gridBlock.getFluidMonitor();
        if (iMEMonitor == null) {
            return null;
        }
        return (IAEFluidStack)iMEMonitor.extractItems((IAEStack)iAEFluidStack, actionable, (BaseActionSource)new MachineSource((IActionHost) ));
    }

    protected final IAEFluidStack extractGas(IAEFluidStack iAEFluidStack, Actionable actionable) {
        if ( .gridBlock == null ||  .facingGasTank == null) {
            return null;
        }
        IMEMonitor<IAEFluidStack> iMEMonitor =  .gridBlock.getFluidMonitor();
        if (iMEMonitor == null) {
            return null;
        }
        return (IAEFluidStack)iMEMonitor.extractItems((IAEStack)iAEFluidStack, actionable, (BaseActionSource)new MachineSource((IActionHost) ));
    }

    public final IGridNode getActionableNode() {
        PartECBase partECBase;
        return partECBase.node;
    }

    public abstract void getBoxes(IPartCollisionHelper var1);

    public IIcon getBreakingTexture() {
        return TextureManager.BUS_SIDE.getTexture();
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return AECableType.GLASS;
    }

    public Object getClientGuiElement(EntityPlayer $) {
        return null;
    }

    public void getDrops(List<ItemStack> list, boolean bl) {
    }

    public final IGridNode getExternalFacingNode() {
        return null;
    }

    public IFluidHandler getFacingTank() {
        PartECBase partECBase;
        return partECBase.facingTank;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public IGasHandler getFacingGasTank() {
        PartECBase partECBase;
        return (IGasHandler)partECBase.facingGasTank;
    }

    public ECBaseGridBlock getGridBlock() {
        PartECBase partECBase;
        return partECBase.gridBlock;
    }

    public IGridNode getGridNode() {
        PartECBase partECBase;
        return partECBase.node;
    }

    public final IGridNode getGridNode(ForgeDirection forgeDirection) {
        return  .node;
    }

    public IPartHost getHost() {
        PartECBase partECBase;
        return partECBase.host;
    }

    public TileEntity getHostTile() {
        PartECBase partECBase;
        return partECBase.hostTile;
    }

    public ItemStack getItemStack(PartItemStack partItemStack) {
        ItemStack itemStack = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID( ));
        if (partItemStack != PartItemStack.Break) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
             .writeToNBT(nBTTagCompound);
            if (nBTTagCompound.func_74764_b(t\u043d\u0435."e ip")) {
                nBTTagCompound.func_82580_o(t\u043d\u0435."e ip");
            }
            itemStack.func_77982_d(nBTTagCompound);
        }
        return itemStack;
    }

    public int getLightLevel() {
        PartECBase partECBase;
        return partECBase.isActive() ? 15 : 0;
    }

    public final DimensionalCoord getLocation() {
        PartECBase partECBase;
        return new DimensionalCoord(partECBase.tile.func_145831_w(), partECBase.tile.field_145851_c, partECBase.tile.field_145848_d, partECBase.tile.field_145849_e);
    }

    public double getPowerUsage() {
        PartECBase partECBase;
        return partECBase.powerUsage;
    }

    public Object getServerGuiElement(EntityPlayer $) {
        return null;
    }

    public ForgeDirection getSide() {
        PartECBase partECBase;
        return partECBase.side;
    }

    public List<String> getWailaBodey(NBTTagCompound nBTTagCompound, List<String> list) {
        return list;
    }

    public NBTTagCompound getWailaTag(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound;
    }

    public void initializePart(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
             .readFromNBT(itemStack.func_77978_p());
        }
    }

    protected final IAEFluidStack injectFluid(IAEFluidStack iAEFluidStack, Actionable actionable) {
        if ( .gridBlock == null ||  .facingTank == null) {
            return iAEFluidStack;
        }
        IMEMonitor<IAEFluidStack> iMEMonitor =  .gridBlock.getFluidMonitor();
        if (iMEMonitor == null) {
            return iAEFluidStack;
        }
        return (IAEFluidStack)iMEMonitor.injectItems((IAEStack)iAEFluidStack, actionable, (BaseActionSource)new MachineSource((IActionHost) ));
    }

    protected final IAEFluidStack injectGas(IAEFluidStack iAEFluidStack, Actionable actionable) {
        if (\u000a
        .gridBlock == null || \u000a
        .facingGasTank == null) {
            return iAEFluidStack;
        }
        IMEMonitor<IAEFluidStack> iMEMonitor = \u000a
        .gridBlock.getFluidMonitor();
        if (iMEMonitor == null) {
            return iAEFluidStack;
        }
        return (IAEFluidStack)iMEMonitor.injectItems((IAEStack)iAEFluidStack, actionable, (BaseActionSource)new MachineSource((IActionHost)\u000a
        ));
    }

    public boolean isActive() {
        PartECBase partECBase;
        return partECBase.node != null ? partECBase.node.isActive() : partECBase.isActive;
    }

    public boolean isLadder(EntityLivingBase entityLivingBase) {
        return false;
    }

    public boolean isPowered() {
        PartECBase partECBase;
        return partECBase.isPowerd;
    }

    public int isProvidingStrongPower() {
        return 0;
    }

    public int isProvidingWeakPower() {
        return 0;
    }

    protected boolean isRedstonePowered() {
        PartECBase $;
        return $.redstonePowered;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean onActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        if (entityPlayer != null && entityPlayer instanceof EntityPlayerMP) {
            GuiHandler.launchGui(GuiHandler.getGuiId( ), entityPlayer,  .hostTile.func_145831_w(),  .hostTile.field_145851_c,  .hostTile.field_145848_d,  .hostTile.field_145849_e);
        }
        return true;
    }

    public void onEntityCollision(Entity entity) {
    }

    public boolean isValid() {
        PartECBase partECBase;
        if (partECBase.hostTile != null && partECBase.hostTile.func_145830_o()) {
            DimensionalCoord dimensionalCoord = partECBase.getLocation();
            TileEntity  2 = partECBase.hostTile.func_145831_w().func_147438_o(dimensionalCoord.x, dimensionalCoord.y, dimensionalCoord.z);
            if ( 2 instanceof IPartHost) {
                return ((IPartHost) 2).getPart(partECBase.side) == partECBase;
            }
            return false;
        }
        return false;
    }

    public void onNeighborChanged() {
        PartECBase $;
        if ($.hostTile == null) {
            return;
        }
        World $2 = $.hostTile.func_145831_w();
        int $3 = $.hostTile.field_145851_c;
        int $4 = $.hostTile.field_145848_d;
        int $5 = $.hostTile.field_145849_e;
        TileEntity $6 = $2.func_147438_o($3 + $.side.offsetX, $4 + $.side.offsetY, $5 + $.side.offsetZ);
        $.facingTank = null;
        if ($6 instanceof IFluidHandler) {
            $.facingTank = (IFluidHandler)$6;
        }
        if (Integration.Mods.MEKANISMGAS.isEnabled()) {
            $.updateCheckGasTank($6);
        }
        $.redstonePowered = $2.func_72864_z($3, $4, $5) || $2.func_72864_z($3, $4 + 1, $5);
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private void updateCheckGasTank(TileEntity tileEntity) {
         
        .facingGasTank = null;
        if (tileEntity != null && tileEntity instanceof IGasHandler) {
             
            .facingGasTank = tileEntity;
        }
    }

    public void onPlacement(EntityPlayer entityPlayer, ItemStack itemStack, ForgeDirection forgeDirection) {
         .owner = entityPlayer;
    }

    public boolean onShiftActivate(EntityPlayer entityPlayer, Vec3 vec3) {
        return false;
    }

    public void randomDisplayTick(World world, int n, int n2, int n3, Random random) {
    }

    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_74764_b(t\u043d\u0435."e ip") &&  .node != null) {
             .node.loadFromNBT(\u0435hv."\u0430a z", nBTTagCompound.func_74775_l(t\u043d\u0435."e ip"));
             .node.updateState();
        }
    }

    public boolean readFromStream(ByteBuf $) throws IOException {
        $.isActive = $.readBoolean();
        $.isPowerd = $.readBoolean();
        return true;
    }

    public void removeFromWorld() {
        PartECBase partECBase;
        if (partECBase.node != null) {
            partECBase.node.destroy();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double d, double d2, double d3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderInventory(IPartRenderHelper var1, RenderBlocks var2);

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryBusLights(IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        iPartRenderHelper.setInvColor(0xFFFFFF);
        IIcon  2 = TextureManager.BUS_COLOR.getTextures()[0];
        IIcon  3 = TextureManager.BUS_SIDE.getTexture();
        iPartRenderHelper.setTexture( 2,  2,  3,  3,  2,  2);
        iPartRenderHelper.renderInventoryBox(renderBlocks);
        tessellator.func_78380_c(0xD000D0);
        iPartRenderHelper.setInvColor(AEColor.Transparent.blackVariant);
        iPartRenderHelper.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.UP, renderBlocks);
        iPartRenderHelper.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.DOWN, renderBlocks);
        iPartRenderHelper.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.NORTH, renderBlocks);
        iPartRenderHelper.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.EAST, renderBlocks);
        iPartRenderHelper.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.renderInventoryFace(TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.WEST, renderBlocks);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(int var1, int var2, int var3, IPartRenderHelper var4, RenderBlocks var5);

    @SideOnly(value=Side.CLIENT)
    public void renderStaticBusLights(int n, int n2, int n3, IPartRenderHelper iPartRenderHelper, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon  2 = TextureManager.BUS_COLOR.getTextures()[0];
        IIcon  3 = TextureManager.BUS_SIDE.getTexture();
        iPartRenderHelper.setTexture( 2,  2,  3,  3,  2,  2);
        iPartRenderHelper.renderBlock(n, n2, n3, renderBlocks);
        if ( .isActive()) {
            tessellator.func_78380_c(0xD000D0);
            tessellator.func_78378_d( .host.getColor().blackVariant);
        } else {
            tessellator.func_78378_d(0);
        }
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.UP, renderBlocks);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.DOWN, renderBlocks);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.NORTH, renderBlocks);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.EAST, renderBlocks);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.SOUTH, renderBlocks);
        iPartRenderHelper.renderFace(n, n2, n3, TextureManager.BUS_COLOR.getTextures()[1], ForgeDirection.WEST, renderBlocks);
    }

    public boolean requireDynamicRender() {
        return false;
    }

    protected final void saveData() {
        PartECBase partECBase;
        if (partECBase.host != null) {
            partECBase.host.markForSave();
        }
    }

    public void securityBreak() {
        PartECBase $;
        $.getHost().removePart($.side, false);
    }

    protected void setActive(boolean bl) {
         .isActive = bl;
    }

    public void setPartHostInfo(ForgeDirection forgeDirection, IPartHost iPartHost, TileEntity tileEntity) {
         .side = forgeDirection;
         .host = iPartHost;
         .tile = tileEntity;
         .hostTile = tileEntity;
         .setPower(null);
    }

    @MENetworkEventSubscribe
    public void setPower(MENetworkPowerStatusChange mENetworkPowerStatusChange) {
        if ( .node != null) {
             .isActive =  .node.isActive();
            IGrid iGrid =  .node.getGrid();
            if (iGrid != null && (  = (IEnergyGrid)iGrid.getCache(IEnergyGrid.class)) != null) {
                 .isPowerd =  .isNetworkPowered();
            }
             .host.markForUpdate();
        }
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        if ( .node != null) {
              = new NBTTagCompound();
             .node.saveToNBT(\u0435hv."\u0430a z",  );
            nBTTagCompound.func_74782_a(t\u043d\u0435."e ip", (NBTBase) );
        }
    }

    public void writeToStream(ByteBuf byteBuf) throws IOException {
        byteBuf.writeBoolean( .node != null &&  .node.isActive());
        byteBuf.writeBoolean( .isPowerd);
    }
}

