/*
 * Decompiled with CFR 0.152.
 */
package com.TominoCZ.FBP.util;

import com.TominoCZ.FBP.FBP;
import com.TominoCZ.FBP.vector.FBPVector3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class FBPRenderUtil {
    public static void renderCubeShaded_S(Tessellator tes, FBPVector3d[] par, double f5, double f6, double f7, double scale, FBPVector3d rotVec, int brightness, float r, float g, float b, float a, boolean cartoon) {
        Tessellator.field_78398_a.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        RenderHelper.func_74519_b();
        tes.func_78373_b(f5, f6, f7);
        FBPRenderUtil.putCube_S(tes, par, scale, rotVec, brightness, r, g, b, a, FBP.cartoonMode);
        tes.func_78373_b(0.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        RenderHelper.func_74518_a();
    }

    public static void renderCubeShaded_WH(Tessellator tes, FBPVector3d[] par, double f5, double f6, double f7, double width, double height, FBPVector3d rotVec, int brightness, float r, float g, float b, float a, boolean cartoon) {
        Tessellator.field_78398_a.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        RenderHelper.func_74519_b();
        tes.func_78373_b(f5, f6, f7);
        FBPRenderUtil.putCube_WH(tes, par, width, height, rotVec, brightness, r, g, b, a, FBP.cartoonMode);
        tes.func_78373_b(0.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        tes.func_78382_b();
        RenderHelper.func_74518_a();
    }

    static void putCube_S(Tessellator tes, FBPVector3d[] par, double scale, FBPVector3d rotVec, int brightness, float r, float g, float b, float a, boolean cartoon) {
        float radsX = (float)Math.toRadians(rotVec.x);
        float radsY = (float)Math.toRadians(rotVec.y);
        float radsZ = (float)Math.toRadians(rotVec.z);
        for (int i = 0; i < FBP.CUBE.length; i += 4) {
            FBPVector3d v1 = FBP.CUBE[i];
            FBPVector3d v2 = FBP.CUBE[i + 1];
            FBPVector3d v3 = FBP.CUBE[i + 2];
            FBPVector3d v4 = FBP.CUBE[i + 3];
            v1 = FBPRenderUtil.rotatef_d(v1, radsX, radsY, radsZ);
            v2 = FBPRenderUtil.rotatef_d(v2, radsX, radsY, radsZ);
            v3 = FBPRenderUtil.rotatef_d(v3, radsX, radsY, radsZ);
            v4 = FBPRenderUtil.rotatef_d(v4, radsX, radsY, radsZ);
            FBPVector3d normal = FBPRenderUtil.rotatef_d(FBP.CUBE_NORMALS[i / 4], radsX, radsY, radsZ);
            if (!cartoon) {
                FBPRenderUtil.addVt_S(tes, scale, v1, par[0].x, par[0].y, brightness, r, g, b, a, normal);
                FBPRenderUtil.addVt_S(tes, scale, v2, par[1].x, par[1].y, brightness, r, g, b, a, normal);
                FBPRenderUtil.addVt_S(tes, scale, v3, par[2].x, par[2].y, brightness, r, g, b, a, normal);
                FBPRenderUtil.addVt_S(tes, scale, v4, par[3].x, par[3].y, brightness, r, g, b, a, normal);
                continue;
            }
            FBPRenderUtil.addVt_S(tes, scale, v1, par[0].x, par[0].y, brightness, r, g, b, a, normal);
            FBPRenderUtil.addVt_S(tes, scale, v2, par[0].x, par[0].y, brightness, r, g, b, a, normal);
            FBPRenderUtil.addVt_S(tes, scale, v3, par[0].x, par[0].y, brightness, r, g, b, a, normal);
            FBPRenderUtil.addVt_S(tes, scale, v4, par[0].x, par[0].y, brightness, r, g, b, a, normal);
        }
    }

    static void putCube_WH(Tessellator worldRendererIn, FBPVector3d[] par, double width, double height, FBPVector3d rotVec, int brightness, float r, float g, float b, float a, boolean cartoon) {
        float radsX = (float)Math.toRadians(rotVec.x);
        float radsY = (float)Math.toRadians(rotVec.y);
        float radsZ = (float)Math.toRadians(rotVec.z);
        for (int i = 0; i < FBP.CUBE.length; i += 4) {
            FBPVector3d v1 = FBP.CUBE[i];
            FBPVector3d v2 = FBP.CUBE[i + 1];
            FBPVector3d v3 = FBP.CUBE[i + 2];
            FBPVector3d v4 = FBP.CUBE[i + 3];
            v1 = FBPRenderUtil.rotatef_d(v1, radsX, radsY, radsZ);
            v2 = FBPRenderUtil.rotatef_d(v2, radsX, radsY, radsZ);
            v3 = FBPRenderUtil.rotatef_d(v3, radsX, radsY, radsZ);
            v4 = FBPRenderUtil.rotatef_d(v4, radsX, radsY, radsZ);
            FBPVector3d normal = FBPRenderUtil.rotatef_d(FBP.CUBE_NORMALS[i / 4], radsX, radsY, radsZ);
            if (!cartoon) {
                FBPRenderUtil.addVt_WH(worldRendererIn, width, height, v1, par[0].x, par[0].y, brightness, r, g, b, a, normal);
                FBPRenderUtil.addVt_WH(worldRendererIn, width, height, v2, par[1].x, par[1].y, brightness, r, g, b, a, normal);
                FBPRenderUtil.addVt_WH(worldRendererIn, width, height, v3, par[2].x, par[2].y, brightness, r, g, b, a, normal);
                FBPRenderUtil.addVt_WH(worldRendererIn, width, height, v4, par[3].x, par[3].y, brightness, r, g, b, a, normal);
                continue;
            }
            FBPRenderUtil.addVt_WH(worldRendererIn, width, height, v1, par[0].x, par[0].y, brightness, r, g, b, a, normal);
            FBPRenderUtil.addVt_WH(worldRendererIn, width, height, v2, par[0].x, par[0].y, brightness, r, g, b, a, normal);
            FBPRenderUtil.addVt_WH(worldRendererIn, width, height, v3, par[0].x, par[0].y, brightness, r, g, b, a, normal);
            FBPRenderUtil.addVt_WH(worldRendererIn, width, height, v4, par[0].x, par[0].y, brightness, r, g, b, a, normal);
        }
    }

    static void addVt_S(Tessellator tes, double scale, FBPVector3d pos, double u, double v, int brightness, float r, float g, float b, float a, FBPVector3d n) {
        tes.func_78369_a(r, g, b, a);
        tes.func_78380_c(brightness);
        tes.func_78375_b((float)n.x, (float)n.y, (float)n.z);
        tes.func_78374_a(pos.x * scale, pos.y * scale, pos.z * scale, u, v);
    }

    static void addVt_WH(Tessellator tes, double width, double height, FBPVector3d pos, double u, double v, int brightness, float r, float g, float b, float a, FBPVector3d n) {
        tes.func_78369_a(r, g, b, a);
        tes.func_78380_c(brightness);
        tes.func_78374_a(pos.x * width, pos.y * height, pos.z * width, u, v);
        tes.func_78375_b((float)n.x, (float)n.y, (float)n.z);
    }

    public static FBPVector3d rotatef_d(FBPVector3d vec, float AngleX, float AngleY, float AngleZ) {
        FBPVector3d sin = new FBPVector3d(MathHelper.func_76126_a((float)AngleX), MathHelper.func_76126_a((float)AngleY), MathHelper.func_76126_a((float)AngleZ));
        FBPVector3d cos = new FBPVector3d(MathHelper.func_76134_b((float)AngleX), MathHelper.func_76134_b((float)AngleY), MathHelper.func_76134_b((float)AngleZ));
        vec = new FBPVector3d(vec.x, vec.y * cos.x - vec.z * sin.x, vec.y * sin.x + vec.z * cos.x);
        vec = new FBPVector3d(vec.x * cos.z - vec.y * sin.z, vec.x * sin.z + vec.y * cos.z, vec.z);
        vec = new FBPVector3d(vec.x * cos.y + vec.z * sin.y, vec.y, vec.x * sin.y - vec.z * cos.y);
        return vec;
    }

    public static Vector3d rotatef_f(Vector3f pos, float AngleX, float AngleY, float AngleZ, EnumFacing facing) {
        FBPVector3d sin = new FBPVector3d(MathHelper.func_76126_a((float)AngleX), MathHelper.func_76126_a((float)AngleY), MathHelper.func_76126_a((float)AngleZ));
        FBPVector3d cos = new FBPVector3d(MathHelper.func_76134_b((float)AngleX), MathHelper.func_76134_b((float)AngleY), MathHelper.func_76134_b((float)AngleZ));
        FBPVector3d pos1 = new FBPVector3d(pos.x, pos.y, pos.z);
        if (facing == EnumFacing.EAST) {
            pos1.x -= 1.0;
        } else if (facing == EnumFacing.WEST) {
            pos1.x += 1.0;
        } else if (facing == EnumFacing.SOUTH) {
            pos1.z -= 1.0;
            pos1.x -= 1.0;
        }
        FBPVector3d pos2 = new FBPVector3d(pos1.x, pos1.y * cos.x - pos1.z * sin.x, pos1.y * sin.x + pos1.z * cos.x);
        pos2 = new FBPVector3d(pos2.x * cos.z - pos2.y * sin.z, pos2.x * sin.z + pos2.y * cos.z, pos2.z);
        pos2 = new FBPVector3d(pos2.x * cos.y + pos2.z * sin.y, pos2.y, pos2.x * sin.y - pos2.z * cos.y);
        if (facing == EnumFacing.EAST) {
            pos2.x += 1.0;
        } else if (facing == EnumFacing.WEST) {
            pos2.x -= 1.0;
        } else if (facing == EnumFacing.SOUTH) {
            pos2.z += 1.0;
            pos2.x += 1.0;
        }
        return new Vector3d(pos2.x, pos2.y, pos2.z);
    }
}

