/*
 * Decompiled with CFR 0.152.
 */
package com.detrav.items.behaviours;

import com.detrav.DetravScannerMod;
import cpw.mods.fml.common.registry.LanguageRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.GT_Pollution;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import gregtech.common.items.behaviors.Behaviour_None;
import java.util.HashMap;
import java.util.SplittableRandom;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;

public class BehaviourDetravToolProPick
extends Behaviour_None {
    HashMap<String, Integer> ores;
    int badluck;
    protected final int mCosts;

    public BehaviourDetravToolProPick(int aCosts) {
        this.mCosts = aCosts;
    }

    public boolean onItemUse(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        int chance;
        SplittableRandom aRandom = new SplittableRandom();
        int n = chance = (1 + aStack.func_77960_j()) * 8 > 100 ? 100 : (1 + aStack.func_77960_j()) * 8;
        if (aWorld.field_72995_K) {
            return false;
        }
        if (aWorld.func_147439_a(aX, aY, aZ) == Blocks.field_150357_h) {
            if (!aWorld.field_72995_K && aRandom.nextInt(100) < chance) {
                FluidStack fluidStack = GT_UndergroundOil.undergroundOil((Chunk)aWorld.func_72938_d(aX, aZ), (float)-1.0f);
            }
            return true;
        }
        if (aWorld.func_147439_a(aX, aY, aZ).func_149688_o() == Material.field_151576_e || aWorld.func_147439_a(aX, aY, aZ).func_149688_o() == Material.field_151578_c || aWorld.func_147439_a(aX, aY, aZ) == GregTech_API.sBlockOres1) {
            if (!aWorld.field_72995_K) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    protected void prospectSingleChunk(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        this.ores = new HashMap();
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("detrav.scanner.prospecting", new Object[]{aX, aZ}));
        this.processOreProspecting(aItem, aStack, aPlayer, aWorld.func_72938_d(aX, aZ), aWorld.func_147438_o(aX, aY, aZ), GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(aWorld.func_147439_a(aX, aY, aZ), 1, aWorld.func_72805_g(aX, aY, aZ))), new SplittableRandom(), 1000);
        for (String key : this.ores.keySet()) {
            int value = this.ores.get(key);
            this.addChatMassageByValue(aPlayer, value, key);
        }
    }

    protected void processOreProspecting(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, Chunk aChunk, TileEntity aTileEntity, ItemData tAssotiation, SplittableRandom aRandom, int chance) {
        String lang;
        String string = lang = aPlayer instanceof EntityPlayerMP ? ((EntityPlayerMP)aPlayer).field_71148_cg : "en_US";
        if (aTileEntity != null) {
            if (aTileEntity instanceof GT_TileEntity_Ores) {
                GT_TileEntity_Ores gt_entity = (GT_TileEntity_Ores)aTileEntity;
                short meta = gt_entity.getMetaData();
                String name = this.getTranslatedNameFromBlock(lang, "gt.blockores." + meta + ".name", meta % 1000);
                this.addOreToHashMap(name, aPlayer);
                return;
            }
        } else if (tAssotiation != null) {
            try {
                GT_TileEntity_Ores gt_entity = (GT_TileEntity_Ores)aTileEntity;
                String name = tAssotiation.toString();
                this.addChatMassageByValue(aPlayer, -1, name);
                return;
            }
            catch (Exception e) {
                this.addChatMassageByValue(aPlayer, -1, "ERROR, lol ^_^");
            }
        } else {
            if (aRandom.nextInt(100) < chance) {
                int data = this.getMode(aStack);
                String small_ore_keyword = StatCollector.func_74838_a((String)"detrav.scanner.small_ore.keyword");
                String ore_keyword = StatCollector.func_74838_a((String)"detrav.scanner.ore.keyword");
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        int ySize = aChunk.func_76611_b(x, z);
                        for (int y = 1; y < ySize; ++y) {
                            String name;
                            Block tBlock = aChunk.func_150810_a(x, y, z);
                            short tMetaID = (short)aChunk.func_76628_c(x, y, z);
                            if (tBlock instanceof GT_Block_Ores_Abstract) {
                                TileEntity tTileEntity = aChunk.getTileEntityUnsafe(x, y, z);
                                if (!(tTileEntity instanceof GT_TileEntity_Ores) || !((GT_TileEntity_Ores)tTileEntity).mNatural) continue;
                                tMetaID = ((GT_TileEntity_Ores)tTileEntity).getMetaData();
                                try {
                                    name = Materials.getLocalizedNameForItem((String)GT_LanguageManager.getTranslation((String)(tBlock.func_149739_a() + "." + tMetaID + ".name")), (int)(tMetaID % 1000));
                                    if (data != 1 && name.startsWith(small_ore_keyword) || name.startsWith(small_ore_keyword) && data != 1) continue;
                                    String translateName = this.getTranslatedNameFromBlock(lang, tBlock.func_149739_a() + "." + tMetaID + ".name", tMetaID % 1000);
                                    this.addOreToHashMap(translateName, aPlayer);
                                }
                                catch (Exception e) {
                                    String name2 = tBlock.func_149739_a() + ".";
                                    if (data != 1 && name2.contains(".small.") || name2.startsWith(small_ore_keyword) && data != 1) continue;
                                    this.addOreToHashMap(name2, aPlayer);
                                }
                                continue;
                            }
                            if (data != 1 || (tAssotiation = GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(tBlock, 1, (int)tMetaID))) == null || !tAssotiation.mPrefix.toString().startsWith(ore_keyword)) continue;
                            try {
                                try {
                                    tMetaID = (short)tAssotiation.mMaterial.mMaterial.mMetaItemSubID;
                                    String name3 = this.getTranslatedNameFromBlock(lang, tBlock.func_149739_a() + "." + tMetaID + ".name", tMetaID % 1000);
                                    this.addOreToHashMap(name3, aPlayer);
                                }
                                catch (Exception e1) {
                                    name = tAssotiation.toString();
                                    this.addOreToHashMap(name, aPlayer);
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                return;
            }
            if (DetravScannerMod.DEBUGBUILD) {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + " Failed on this chunk"));
            }
            ++this.badluck;
        }
    }

    void addOreToHashMap(String orename, EntityPlayer aPlayer) {
        String oreDistance = orename;
        if (!this.ores.containsKey(oreDistance)) {
            if (DetravScannerMod.DEBUGBUILD) {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentText(oreDistance));
            }
            this.ores.put(oreDistance, 1);
        } else {
            int val = this.ores.get(oreDistance);
            this.ores.put(oreDistance, val + 1);
        }
    }

    void addChatMassageByValue(EntityPlayer aPlayer, int value, String name) {
        if (value < 1) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("detrav.scanner.prospecting.nothing", new Object[0]));
        } else if (value < 10) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("detrav.scanner.prospecting.traces", new Object[]{new ChatComponentTranslation(name, new Object[0]), value}));
        } else if (value < 30) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("detrav.scanner.prospecting.smallsample", new Object[]{new ChatComponentTranslation(name, new Object[0]), value}));
        } else if (value < 60) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("detrav.scanner.prospecting.mediumsample", new Object[]{new ChatComponentTranslation(name, new Object[0]), value}));
        } else if (value < 100) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("detrav.scanner.prospecting.largesample", new Object[]{new ChatComponentTranslation(name, new Object[0]), value}));
        } else {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("detrav.scanner.prospecting.verylargesample", new Object[]{new ChatComponentTranslation(name, new Object[0]), value}));
        }
    }

    public static int getPolution(World aWorld, int aX, int aZ) {
        return GT_Pollution.getPollution((Chunk)aWorld.func_72938_d(aX, aZ));
    }

    protected int getMode(ItemStack is) {
        if (is == null || is.func_77978_p() == null) {
            return 0;
        }
        return is.func_77978_p().func_74762_e("mode");
    }

    protected void setMode(ItemStack is, int mode) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = is.func_77978_p() == null ? new NBTTagCompound() : is.func_77978_p();
        tag.func_74768_a("mode", mode);
        is.func_77982_d(tag);
    }

    private String getTranslatedNameFromBlock(String lang, String alternative, int meta) {
        Materials material;
        if (meta >= 0 && meta < 1000 && (material = GregTech_API.sGeneratedMaterials[meta]) != null) {
            String materialName = material.mLocalizedName;
            material.mLocalizedName = LanguageRegistry.instance().getStringLocalization("Material." + material.mName.toLowerCase(), lang);
            String result = material.getLocalizedNameForItem(LanguageRegistry.instance().getStringLocalization(alternative, lang));
            material.mLocalizedName = materialName;
            return result;
        }
        return LanguageRegistry.instance().getStringLocalization(alternative, lang);
    }
}

