/*
 * Decompiled with CFR 0.152.
 */
package com.detrav.net;

import com.detrav.DetravScannerMod;
import com.detrav.gui.DetravScannerGUI;
import com.detrav.gui.textures.DetravMapTexture;
import com.detrav.net.DetravPacket;
import com.google.common.base.Objects;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_LanguageManager;
import java.util.HashMap;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ProspectingPacket
extends DetravPacket {
    public int chunkX;
    public int chunkZ;
    public int posX;
    public int posZ;
    public int size;
    public int ptype;
    public HashMap<Byte, Short>[][] map;
    public HashMap<String, Integer> ores;
    public HashMap<Short, String> metaMap;
    public static final HashMap<Integer, short[]> fluidColors = new HashMap();
    public int level = -1;

    public ProspectingPacket() {
    }

    public ProspectingPacket(int chunkX, int chunkZ, int posX, int posZ, int size, int ptype) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.posX = posX;
        this.posZ = posZ;
        this.size = size;
        this.ptype = ptype;
        this.map = new HashMap[(size * 2 + 1) * 16][(size * 2 + 1) * 16];
        this.ores = new HashMap();
        this.metaMap = new HashMap();
    }

    private static void addOre(ProspectingPacket packet, byte y, int i, int j, short meta) {
        short[] rgba;
        String name;
        block7: {
            name = null;
            rgba = new short[]{};
            try {
                if (packet.ptype == 0 || packet.ptype == 1) {
                    if (meta > 0 && (meta < 7000 || meta > 7500)) {
                        Materials tMaterial = GregTech_API.sGeneratedMaterials[meta % 1000];
                        rgba = tMaterial.getRGBA();
                        name = tMaterial.getLocalizedNameForItem(GT_LanguageManager.getTranslation((String)("gt.blockores." + meta + ".name")));
                        break block7;
                    }
                    return;
                }
                if (packet.ptype == 2) {
                    rgba = fluidColors.get(meta);
                    if (rgba == null) {
                        DetravScannerMod.proxy.sendPlayerExeption("Unknown fluid ID = " + meta + " Please add to FluidColors.java!");
                        rgba = new short[]{125, 123, 118, 0};
                    }
                    name = (String)Objects.firstNonNull((Object)FluidRegistry.getFluid((int)meta).getLocalizedName(new FluidStack(FluidRegistry.getFluid((int)meta), 0)), (Object)StatCollector.func_74838_a((String)"gui.detrav.scanner.unknown_fluid"));
                    break block7;
                }
                if (packet.ptype == 3) {
                    name = StatCollector.func_74838_a((String)"gui.detrav.scanner.pollution");
                    rgba = new short[]{125, 123, 118, 0};
                    break block7;
                }
                return;
            }
            catch (Exception ignored) {
                return;
            }
        }
        packet.ores.put(name, ((rgba[0] & 0xFF) << 16) + ((rgba[1] & 0xFF) << 8) + (rgba[2] & 0xFF));
        packet.metaMap.put(meta, name);
    }

    @Override
    public Object decode(ByteArrayDataInput aData) {
        ProspectingPacket packet = new ProspectingPacket(aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
        packet.level = aData.readInt();
        int aSize = (packet.size * 2 + 1) * 16;
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                int kSize = aData.readByte();
                if (kSize == 0) continue;
                packet.map[i][j] = new HashMap();
                for (int k = 0; k < kSize; ++k) {
                    byte y = aData.readByte();
                    short meta = aData.readShort();
                    packet.map[i][j].put(y, meta);
                    if (packet.ptype != 2 || y == 1) {
                        ProspectingPacket.addOre(packet, y, i, j, meta);
                    }
                    ++checkOut;
                }
            }
        }
        int checkOut2 = aData.readInt();
        if (checkOut != checkOut2) {
            return null;
        }
        return packet;
    }

    @Override
    public int getPacketID() {
        return 0;
    }

    @Override
    public byte[] encode() {
        ByteArrayDataOutput tOut = ByteStreams.newDataOutput((int)1);
        tOut.writeInt(this.chunkX);
        tOut.writeInt(this.chunkZ);
        tOut.writeInt(this.posX);
        tOut.writeInt(this.posZ);
        tOut.writeInt(this.size);
        tOut.writeInt(this.ptype);
        tOut.writeInt(this.level);
        int aSize = (this.size * 2 + 1) * 16;
        int checkOut = 0;
        for (int i = 0; i < aSize; ++i) {
            for (int j = 0; j < aSize; ++j) {
                if (this.map[i][j] == null) {
                    tOut.writeByte(0);
                    continue;
                }
                tOut.writeByte(this.map[i][j].keySet().size());
                for (byte key : this.map[i][j].keySet()) {
                    tOut.writeByte((int)key);
                    tOut.writeShort((int)this.map[i][j].get(key).shortValue());
                    ++checkOut;
                }
            }
        }
        tOut.writeInt(checkOut);
        return tOut.toByteArray();
    }

    @Override
    public void process() {
        DetravScannerGUI.newMap(new DetravMapTexture(this));
        DetravScannerMod.proxy.openProspectorGUI();
    }

    public void addBlock(int x, int y, int z, short metaData) {
        int aX = x - (this.chunkX - this.size) * 16;
        int aZ = z - (this.chunkZ - this.size) * 16;
        if (this.map[aX][aZ] == null) {
            this.map[aX][aZ] = new HashMap();
        }
        this.map[aX][aZ].put((byte)y, metaData);
    }

    public int getSize() {
        return (this.size * 2 + 1) * 16;
    }
}

