/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemAtmosphericValve;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityMethaneSynthesizer
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IFluidHandler {
    private final int tankCapacity = 4000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank gasTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank gasTank2 = new FluidTank(this.tankCapacity / 2);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank = new FluidTank(this.tankCapacity / 2);
    public int processTimeRequired = 3;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = -8;
    private ItemStack[] containingItems = new ItemStack[5];
    private int hasCO2 = -1;
    private boolean noCoal = true;
    private int coalPartial = 0;

    public TileEntityMethaneSynthesizer() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 30.0f);
        this.setTierGC(2);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.hasCO2 == -1) {
            this.hasCO2 = this.getAirProducts();
        }
        if (!this.field_145850_b.field_72995_K) {
            Block blockAbove;
            ItemStack inputCanister;
            if (this.hasCO2 == 0 && this.gasTank2.getFluidAmount() > 0) {
                this.gasTank2.drain(this.gasTank2.getFluidAmount(), true);
            }
            if ((inputCanister = this.containingItems[2]) != null && inputCanister.func_77973_b() instanceof ItemAtmosphericValve && this.hasCO2 > 0 && this.gasTank2.getFluidAmount() < this.gasTank2.getCapacity() && (blockAbove = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) != null && blockAbove.func_149688_o() == Material.field_151579_a && blockAbove != GCBlocks.breatheableAir && blockAbove != GCBlocks.brightBreatheableAir && !OxygenUtil.inOxygenBubble((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e + 0.5))) {
                FluidStack gcAtmosphere = FluidRegistry.getFluidStack((String)"carbondioxide", (int)4);
                this.gasTank2.fill(gcAtmosphere, true);
            }
            this.checkFluidTankTransfer(4, this.liquidTank);
            if (this.hasEnoughEnergyToRun && this.canProcess()) {
                if (this.tierGC == 2) {
                    int n = this.processTimeRequired = this.poweredByTierGC == 2 ? 2 : 3;
                }
                if (this.processTicks <= 0) {
                    this.processTicks = this.processTimeRequired;
                } else if (--this.processTicks <= 0) {
                    this.doLiquefaction();
                    this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                }
            } else if (this.processTicks > 0) {
                this.processTicks = 0;
            } else if (--this.processTicks <= -8) {
                this.processTicks = -8;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        if (FluidUtil.isValidContainer((ItemStack)this.containingItems[slot])) {
            FluidStack liquid = tank.getFluid();
            if (liquid != null) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)AsteroidsItems.methaneCanister);
            }
        } else if (this.containingItems[slot] != null && this.containingItems[slot].func_77973_b() instanceof ItemAtmosphericValve) {
            tank.drain(4, true);
        }
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getFluid() != null ? this.gasTank.getFluid().amount * i / this.gasTank.getCapacity() : 0;
    }

    public int getScaledGasLevel2(int i) {
        return this.gasTank2.getFluid() != null ? this.gasTank2.getFluid().amount * i / this.gasTank2.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.liquidTank.getFluid() != null ? this.liquidTank.getFluid().amount * i / this.liquidTank.getCapacity() : 0;
    }

    public boolean canProcess() {
        if (this.gasTank.getFluid() == null || this.gasTank.getFluid().amount <= 0 || this.getDisabled(0)) {
            return false;
        }
        boolean bl = this.noCoal = this.containingItems[3] == null || this.containingItems[3].field_77994_a == 0 || this.containingItems[3].func_77973_b() != MarsItems.carbonFragments;
        if (this.noCoal && this.coalPartial == 0 && (this.gasTank2.getFluid() == null || this.gasTank2.getFluidAmount() <= 0)) {
            return false;
        }
        return this.liquidTank.getFluidAmount() < this.liquidTank.getCapacity();
    }

    public int getAirProducts() {
        WorldProvider WP = this.field_145850_b.field_73011_w;
        if (WP instanceof WorldProviderSpace) {
            ArrayList atmos = ((WorldProviderSpace)WP).getCelestialBody().atmosphere;
            if (atmos.size() > 0 && atmos.get(0) == IAtmosphericGas.CO2) {
                return 1;
            }
            if (atmos.size() > 1 && atmos.get(1) == IAtmosphericGas.CO2) {
                return 1;
            }
            if (atmos.size() > 2 && atmos.get(2) == IAtmosphericGas.CO2) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public void doLiquefaction() {
        if (this.noCoal && this.coalPartial == 0) {
            if (this.gasTank2.getFluid() == null || this.gasTank2.drain((int)1, (boolean)true).amount < 1) {
                return;
            }
        } else {
            if (this.coalPartial == 0) {
                this.func_70298_a(3, 1);
            }
            ++this.coalPartial;
            if (this.coalPartial == 40) {
                this.coalPartial = 0;
            }
        }
        this.gasTank.drain(this.placeIntoFluidTanks(2) * 8, true);
    }

    private int placeIntoFluidTanks(int amountToDrain) {
        int fuelSpace = this.liquidTank.getCapacity() - this.liquidTank.getFluidAmount();
        if (fuelSpace > 0) {
            if (amountToDrain > fuelSpace) {
                amountToDrain = fuelSpace;
            }
            this.liquidTank.fill(FluidRegistry.getFluidStack((String)"methane", (int)amountToDrain), true);
        } else {
            amountToDrain = 0;
        }
        return amountToDrain;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("gasTank")) {
            this.gasTank.readFromNBT(nbt.func_74775_l("gasTank"));
        }
        if (nbt.func_74764_b("gasTank2")) {
            this.gasTank2.readFromNBT(nbt.func_74775_l("gasTank2"));
        }
        if (nbt.func_74764_b("liquidTank")) {
            this.liquidTank.readFromNBT(nbt.func_74775_l("liquidTank"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt);
        if (this.gasTank.getFluid() != null) {
            nbt.func_74782_a("gasTank", (NBTBase)this.gasTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.gasTank2.getFluid() != null) {
            nbt.func_74782_a("gasTank2", (NBTBase)this.gasTank2.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank.getFluid() != null) {
            nbt.func_74782_a("liquidTank", (NBTBase)this.liquidTank.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.marsMachine.5.name");
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemstack);
                }
                case 3: {
                    return itemstack.func_77973_b() == MarsItems.carbonFragments;
                }
                case 4: {
                    return FluidUtil.isEmptyContainer((ItemStack)itemstack, (Item)AsteroidsItems.methaneCanister);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty((ItemStack)itemstack) || !this.shouldPullEnergy();
                }
                case 4: {
                    return FluidUtil.isFullContainer((ItemStack)itemstack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: {
                return false;
            }
            case 2: {
                return itemstack.func_77973_b() instanceof ItemAtmosphericValve;
            }
            case 3: {
                return itemstack.func_77973_b() == MarsItems.carbonFragments;
            }
            case 4: {
                return FluidUtil.isValidContainer((ItemStack)itemstack);
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public double getPacketRange() {
        return 320.0;
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.DOWN;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.liquidTank.getFluid() != null && this.liquidTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1) && resource != null && resource.isFluidEqual(this.liquidTank.getFluid())) {
            return this.liquidTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.liquidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.ordinal() == this.func_145832_p() + 2) {
            return fluid != null && "hydrogen".equals(fluid.getName());
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid()) && this.gasTank.getFluidAmount() < this.gasTank.getCapacity()) {
            used = this.gasTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.gasTank)};
        } else if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank)};
        }
        return tankInfo;
    }

    public int func_145832_p() {
        if (this.field_145847_g == -1) {
            this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.field_145847_g & 3;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (!stack.getGas().getName().equals("hydrogen")) {
            return 0;
        }
        int used = 0;
        if (this.gasTank.getFluidAmount() < this.gasTank.getCapacity()) {
            used = this.gasTank.fill(FluidRegistry.getFluidStack((String)"hydrogen", (int)stack.amount), doTransfer);
        }
        return used;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return type.getName().equals("hydrogen") && side.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.ITubeConnection", modID="Mekanism")
    public boolean canTubeConnect(ForgeDirection side) {
        return side.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)));
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN) || type == NetworkType.OXYGEN) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        return direction.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)));
    }

    public Float getHydrogenRequest(ForgeDirection direction) {
        return Float.valueOf(this.receiveHydrogen(direction, 1000000.0f, false));
    }

    public boolean shouldPullHydrogen() {
        return this.gasTank.getFluidAmount() < this.gasTank.getCapacity();
    }

    public float receiveHydrogen(ForgeDirection from, float receive, boolean doReceive) {
        if (from.ordinal() == this.func_145832_p() + 2 && this.shouldPullHydrogen()) {
            FluidStack fluidToFill = FluidRegistry.getFluidStack((String)"hydrogen", (int)((int)receive));
            return this.gasTank.fill(fluidToFill, doReceive);
        }
        return 0.0f;
    }
}

