/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.core.blocks.BlockAirLockFrame;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class BlockAdvanced
extends BlockContainer {
    public BlockAdvanced(Material material) {
        super(material);
        this.func_149711_c(0.6f);
        this.func_149752_b(2.5f);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (this.isUsableWrench(entityPlayer, entityPlayer.field_71071_by.func_70448_g(), x, y, z)) {
            this.damageWrench(entityPlayer, entityPlayer.field_71071_by.func_70448_g(), x, y, z);
            if (entityPlayer.func_70093_af() && this.onSneakUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
                return true;
            }
            if (this.onUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
                return true;
            }
        }
        if (entityPlayer.func_70093_af() && this.onSneakMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (world.field_72995_K && !(this instanceof BlockAirLockFrame)) {
            return false;
        }
        return this.onMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    public boolean isUsableWrench(EntityPlayer entityPlayer, ItemStack itemStack, int x, int y, int z) {
        if (entityPlayer != null && itemStack != null) {
            Class<?> wrenchClass = itemStack.func_77973_b().getClass();
            try {
                Method methodCanWrench = wrenchClass.getMethod("canWrench", EntityPlayer.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return (Boolean)methodCanWrench.invoke((Object)itemStack.func_77973_b(), entityPlayer, x, y, z);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrench") || wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrenchElectric")) {
                    return itemStack.func_77960_j() < itemStack.func_77958_k();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean damageWrench(EntityPlayer entityPlayer, ItemStack itemStack, int x, int y, int z) {
        if (this.isUsableWrench(entityPlayer, itemStack, x, y, z)) {
            Class<?> wrenchClass = itemStack.func_77973_b().getClass();
            try {
                Method methodWrenchUsed = wrenchClass.getMethod("wrenchUsed", EntityPlayer.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                methodWrenchUsed.invoke((Object)itemStack.func_77973_b(), entityPlayer, x, y, z);
                return true;
            }
            catch (Exception methodWrenchUsed) {
                try {
                    if (wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrench") || wrenchClass == Class.forName("ic2.core.item.tool.ItemToolWrenchElectric")) {
                        Method methodWrenchDamage = wrenchClass.getMethod("damage", ItemStack.class, Integer.TYPE, EntityPlayer.class);
                        methodWrenchDamage.invoke((Object)itemStack.func_77973_b(), itemStack, 1, entityPlayer);
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean onSneakUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        return this.onUseWrench(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }
}

