/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.command.GCInvSaveData;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.InventoryExtended;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class CommandGCInv
extends CommandBase {
    protected static final Map<String, ItemStack[]> savedata = new HashMap<String, ItemStack[]>();
    private static final Set<String> dontload = new HashSet<String>();
    private static boolean firstuse = true;
    private static GCInvSaveData savefile;

    public String func_71518_a(ICommandSender var1) {
        return "/" + this.func_71517_b() + " [save|restore|drop|clear] <playername>";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "gcinv";
    }

    public List func_71516_a(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        if (par2ArrayOfStr.length == 1) {
            return CommandGCInv.func_71530_a((String[])par2ArrayOfStr, (String[])new String[]{"save", "restore", "drop", "clear"});
        }
        if (par2ArrayOfStr.length == 2) {
            return CommandGCInv.func_71530_a((String[])par2ArrayOfStr, (String[])this.getPlayers());
        }
        return null;
    }

    protected String[] getPlayers() {
        return MinecraftServer.func_71276_C().func_71213_z();
    }

    public boolean func_82358_a(String[] par1ArrayOfStr, int par2) {
        return par2 == 1;
    }

    public void func_71515_b(ICommandSender icommandsender, String[] astring) {
        block15: {
            if (firstuse) {
                firstuse = false;
                CommandGCInv.initialise();
            }
            if (astring.length == 2) {
                try {
                    ItemStack[] saveinv;
                    EntityPlayerMP thePlayer = PlayerUtil.getPlayerBaseServerFromPlayerUsername(astring[1], true);
                    if (thePlayer != null && !thePlayer.field_70128_L && thePlayer.field_70170_p != null) {
                        GCPlayerStats stats = GCPlayerStats.get(thePlayer);
                        if (astring[0].equalsIgnoreCase("drop")) {
                            InventoryExtended gcInventory = stats.extendedInventory;
                            gcInventory.dropExtendedItems((EntityPlayer)thePlayer);
                            break block15;
                        }
                        if (astring[0].equalsIgnoreCase("save")) {
                            InventoryExtended gcInventory = stats.extendedInventory;
                            ItemStack[] saveinv2 = new ItemStack[gcInventory.func_70302_i_()];
                            for (int i = 0; i < gcInventory.func_70302_i_(); ++i) {
                                saveinv2[i] = gcInventory.func_70301_a(i);
                                gcInventory.func_70299_a(i, null);
                            }
                            savedata.put(astring[1].toLowerCase(), saveinv2);
                            dontload.add(astring[1].toLowerCase());
                            CommandGCInv.writefile();
                            System.out.println("[GCInv] Saving and clearing GC inventory slots of " + thePlayer.func_146103_bH().getName());
                            break block15;
                        }
                        if (astring[0].equalsIgnoreCase("restore")) {
                            ItemStack[] saveinv3 = savedata.get(astring[1].toLowerCase());
                            dontload.remove(astring[1].toLowerCase());
                            if (saveinv3 == null) {
                                System.out.println("[GCInv] Tried to restore but player " + thePlayer.func_146103_bH().getName() + " had no saved GC inventory items.");
                                return;
                            }
                            CommandGCInv.doLoad(thePlayer);
                            break block15;
                        }
                        if (astring[0].equalsIgnoreCase("clear")) {
                            InventoryExtended gcInventory = stats.extendedInventory;
                            for (int i = 0; i < gcInventory.func_70302_i_(); ++i) {
                                gcInventory.func_70299_a(i, null);
                            }
                            break block15;
                        }
                        throw new WrongUsageException("Invalid GCInv command. Usage: " + this.func_71518_a(icommandsender), new Object[0]);
                    }
                    if (astring[0].equalsIgnoreCase("restore") && (saveinv = savedata.get(astring[1].toLowerCase())) != null) {
                        System.out.println("[GCInv] Restore command for offline player " + astring[1] + ", setting to restore GCInv on next login.");
                        dontload.remove(astring[1].toLowerCase());
                        return;
                    }
                    if (astring[0].equalsIgnoreCase("clear") || astring[0].equalsIgnoreCase("save") || astring[0].equalsIgnoreCase("drop")) {
                        System.out.println("GCInv command: player " + astring[1] + " not found.");
                        break block15;
                    }
                    throw new WrongUsageException("Invalid GCInv command. Usage: " + this.func_71518_a(icommandsender), new Object[0]);
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                    e.printStackTrace();
                }
            } else {
                throw new WrongUsageException("Not enough command arguments! Usage: " + this.func_71518_a(icommandsender), new Object[0]);
            }
        }
    }

    public static void doLoad(EntityPlayerMP thePlayer) {
        String theName = thePlayer.func_146103_bH().getName().toLowerCase();
        if (!dontload.contains(theName)) {
            ItemStack[] saveinv = savedata.get(theName);
            InventoryExtended gcInventory = GCPlayerStats.get((EntityPlayerMP)thePlayer).extendedInventory;
            for (int i = 0; i < gcInventory.func_70302_i_(); ++i) {
                gcInventory.func_70299_a(i, saveinv[i]);
            }
            savedata.remove(theName);
            CommandGCInv.writefile();
            System.out.println("[GCInv] Restored GC inventory slots of " + thePlayer.func_146103_bH().getName());
        } else {
            System.out.println("[GCInv] Player " + thePlayer.func_146103_bH().getName() + " was spawned without restoring the GCInv save.  Run /gcinv restore playername to restore it.");
        }
    }

    private static void writefile() {
        savefile.func_76187_b(new NBTTagCompound());
        savefile.func_76185_a();
    }

    private static void initialise() {
        World world0 = GalacticraftCore.proxy.getWorldForID(0);
        if (world0 == null) {
            return;
        }
        savefile = (GCInvSaveData)world0.func_72943_a(GCInvSaveData.class, "GCInv_savefile");
        if (savefile == null) {
            savefile = new GCInvSaveData();
            world0.func_72823_a("GCInv_savefile", (WorldSavedData)savefile);
        }
    }

    public static ItemStack[] getSaveData(String p) {
        if (firstuse) {
            firstuse = false;
            CommandGCInv.initialise();
        }
        return savedata.get(p);
    }
}

