/*
 * Decompiled with CFR 0.152.
 */
package gravisuite;

import cpw.mods.fml.common.FMLCommonHandler;
import gravisuite.GraviSuite;
import gravisuite.network.PacketLocalizedChatMessage;
import gravisuite.utils.Helpers;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class ServerProxy {
    private Map<EntityPlayer, Boolean> isFlyActiveByMod = new HashMap<EntityPlayer, Boolean>();
    private Map<EntityPlayer, Boolean> lastUndressed = new HashMap<EntityPlayer, Boolean>();
    private Map<EntityPlayer, Boolean> isLastCreativeState = new HashMap<EntityPlayer, Boolean>();

    public void initCore() {
    }

    public static void sendClientLocalizedMessage(EntityPlayer player, String message) {
        if (player instanceof EntityPlayerMP) {
            PacketLocalizedChatMessage.issue(message, (EntityPlayerMP)player);
        } else {
            ServerProxy.sendPlayerMessage(player, Helpers.getLocalizedMessage(message));
        }
    }

    public static void sendPlayerMessage(EntityPlayer player, String message) {
        if (GraviSuite.isSimulating()) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(message, new Object[0]));
        }
    }

    public void setLastUndressed(EntityPlayer player, Boolean value) {
        this.lastUndressed.put(player, value);
    }

    public void SetFlyActiveByMod(EntityPlayer player, Boolean value) {
        this.isFlyActiveByMod.put(player, value);
    }

    public void SetLastCreativeState(EntityPlayer player, Boolean value) {
        this.isLastCreativeState.put(player, value);
    }

    public boolean checkLastUndressed(EntityPlayer player) {
        return this.lastUndressed.containsKey(player) && this.lastUndressed.get(player) != false;
    }

    public boolean checkFlyActiveByMod(EntityPlayer player) {
        return this.isFlyActiveByMod.containsKey(player) && this.isFlyActiveByMod.get(player) != false;
    }

    public boolean checkLastCreativeState(EntityPlayer player) {
        return this.isLastCreativeState.containsKey(player) && this.isLastCreativeState.get(player) != false;
    }

    public static boolean isSimulating() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public void playSoundSp(String sound, float var2, float var3) {
    }

    public void registerSoundHandler() {
    }

    public void registerRenderers() {
    }

    public EntityPlayer getPlayerInstance() {
        return null;
    }

    public int addArmor(String armorName) {
        return 0;
    }
}

