/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.audio;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.Config;
import gravisuite.GraviSuite;
import gravisuite.audio.AudioManager;
import gravisuite.audio.AudioPosition;
import gravisuite.audio.AudioSource;
import gravisuite.audio.PositionSpec;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public class AudioManagerClient
extends AudioManager {
    public float fadingDistance = 16.0f;
    private boolean enabled = true;
    private int maxSourceCount = 32;
    private final int streamingSourceCount = 4;
    private SoundManager soundManager;
    private Field soundManagerLoaded;
    private volatile Thread initThread;
    private SoundSystem soundSystem = null;
    private float masterVolume = 0.5f;
    public float defaultVolume = 1.2f;
    private int nextId = 0;
    private final Map<WeakObject, List<AudioSource>> objectToAudioSourceMap = new HashMap<WeakObject, List<AudioSource>>();

    @Override
    public void initialize() {
        this.enabled = !Config.disableSounds;
        this.maxSourceCount = 32;
        if (this.maxSourceCount <= 6) {
            GraviSuite.addLog("Audio source limit too low to enable sounds.");
            this.enabled = false;
        }
        if (!this.enabled) {
            GraviSuite.addLog("Sounds disabled.");
        } else if (this.maxSourceCount < 6) {
            this.enabled = false;
        } else {
            GraviSuite.addLog("Using " + this.maxSourceCount + " audio sources.");
            SoundSystemConfig.setNumberStreamingChannels((int)4);
            SoundSystemConfig.setNumberNormalChannels((int)(this.maxSourceCount - 4));
            int found = 0;
            for (Field field : SoundManager.class.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(Boolean.TYPE)) continue;
                this.soundManagerLoaded = field;
                ++found;
            }
            if (found != 1) {
                GraviSuite.addLog("Can't find SoundManager.loaded, audio disabled.");
                this.enabled = false;
            } else {
                this.soundManagerLoaded.setAccessible(true);
                MinecraftForge.EVENT_BUS.register((Object)this);
            }
        }
    }

    @SubscribeEvent
    public void onSoundSetup(SoundLoadEvent event) {
        if (this.enabled) {
            this.objectToAudioSourceMap.clear();
            GraviSuite.addLog("Audio starting.");
            this.soundSystem = null;
            this.soundManager = AudioManagerClient.getSoundManager();
            this.initThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            boolean loaded;
                            System.out.println("Thread");
                            try {
                                loaded = AudioManagerClient.this.soundManagerLoaded.getBoolean(AudioManagerClient.this.soundManager);
                            }
                            catch (Exception var3) {
                                throw new RuntimeException(var3);
                            }
                            if (loaded) {
                                AudioManagerClient var4 = AudioManagerClient.this;
                                AudioManagerClient.this.soundSystem = AudioManagerClient.getSoundSystem(AudioManagerClient.this.soundManager);
                                if (AudioManagerClient.this.soundSystem == null) {
                                    GraviSuite.addLog("Audio unavailable.");
                                }
                                GraviSuite.addLog("Audio ready.");
                                break;
                            }
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AudioManagerClient.this.soundSystem = null;
                }
            }, "GraviSuite audio init thread");
            this.initThread.setDaemon(true);
            this.initThread.start();
        }
    }

    private static SoundManager getSoundManager() {
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        for (Field field : SoundHandler.class.getDeclaredFields()) {
            if (!SoundManager.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                System.out.println("Found SoundHandler");
                return (SoundManager)field.get(handler);
            }
            catch (Exception var6) {
                throw new RuntimeException(var6);
            }
        }
        return null;
    }

    private static SoundSystem getSoundSystem(SoundManager soundManager) {
        for (Field field : SoundManager.class.getDeclaredFields()) {
            if (!SoundSystem.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                System.out.println("Found SoundSystem");
                return (SoundSystem)field.get(soundManager);
            }
            catch (Exception var6) {
                throw new RuntimeException(var6);
            }
        }
        return null;
    }

    @Override
    public void onTick() {
        if (this.enabled && this.valid()) {
            float configSoundVolume = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER);
            if (configSoundVolume != this.masterVolume) {
                this.masterVolume = configSoundVolume;
            }
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            Vector<WeakObject> audioSourceObjectsToRemove = new Vector<WeakObject>();
            if (player == null) {
                audioSourceObjectsToRemove.addAll(this.objectToAudioSourceMap.keySet());
            } else {
                PriorityQueue<AudioSource> validAudioSources = new PriorityQueue<AudioSource>();
                for (Map.Entry<WeakObject, List<AudioSource>> entry : this.objectToAudioSourceMap.entrySet()) {
                    if (entry.getKey().isEnqueued()) {
                        audioSourceObjectsToRemove.add(entry.getKey());
                        continue;
                    }
                    for (AudioSource audioSource : entry.getValue()) {
                        audioSource.updateVolume((EntityPlayer)player);
                        if (!(audioSource.getRealVolume() > 0.0f)) continue;
                        validAudioSources.add(audioSource);
                    }
                }
                int i = 0;
                while (!validAudioSources.isEmpty()) {
                    if (i < this.maxSourceCount) {
                        ((AudioSource)validAudioSources.poll()).activate();
                    } else {
                        ((AudioSource)validAudioSources.poll()).cull();
                    }
                    ++i;
                }
            }
            for (WeakObject asToRemove : audioSourceObjectsToRemove) {
                this.removeSources(asToRemove);
            }
        }
    }

    @Override
    public AudioSource createSource(Object obj, String initialSoundFile) {
        return this.createSource(obj, PositionSpec.Center, initialSoundFile, false, false, this.defaultVolume);
    }

    @Override
    public AudioSource createSource(Object obj, PositionSpec positionSpec, String initialSoundFile, boolean loop, boolean prioritized, float volume) {
        if (!this.enabled) {
            return null;
        }
        if (!this.valid()) {
            return null;
        }
        String sourceName = AudioManagerClient.getSourceName(this.nextId);
        ++this.nextId;
        AudioSource audioSource = new AudioSource(this.soundSystem, sourceName, obj, positionSpec, initialSoundFile, loop, prioritized, volume);
        WeakObject key = new WeakObject(obj);
        if (!this.objectToAudioSourceMap.containsKey(key)) {
            this.objectToAudioSourceMap.put(key, new LinkedList());
        }
        this.objectToAudioSourceMap.get(key).add(audioSource);
        return audioSource;
    }

    @Override
    public void removeSources(Object obj) {
        WeakObject key;
        if (this.valid() && this.objectToAudioSourceMap.containsKey(key = obj instanceof WeakObject ? (WeakObject)obj : new WeakObject(obj))) {
            for (AudioSource audioSource : this.objectToAudioSourceMap.get(key)) {
                audioSource.remove();
            }
            this.objectToAudioSourceMap.remove(key);
        }
    }

    @Override
    public void playOnce(Object obj, String soundFile) {
        this.playOnce(obj, PositionSpec.Center, soundFile, false, this.defaultVolume);
    }

    @Override
    public void playOnce(Object obj, PositionSpec positionSpec, String soundFile, boolean prioritized, float volume) {
        if (this.enabled && this.valid()) {
            System.out.println("Play once sound");
            AudioPosition position = AudioPosition.getFrom(obj, positionSpec);
            if (position != null) {
                URL url = AudioSource.class.getClassLoader().getResource("assets/gravisuite/sounds/" + soundFile);
                if (url == null) {
                    GraviSuite.addLog("Invalid sound file: " + soundFile);
                } else {
                    String sourceName = this.soundSystem.quickPlay(prioritized, url, soundFile, false, position.x, position.y, position.z, 2, this.fadingDistance * Math.max(volume, 1.0f));
                    this.soundSystem.setVolume(sourceName, this.masterVolume * Math.min(volume, 1.0f));
                }
            }
        }
    }

    public static void playSound(Object obj, PositionSpec positionSpec, String soundName) {
        ResourceLocation soundFile = new ResourceLocation("gravisuite", soundName);
        AudioPosition position = AudioPosition.getFrom(obj, positionSpec);
        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(soundFile, 1.0f, 1.0f, position.x, position.y, position.z));
    }

    @Override
    public float getMasterVolume() {
        return this.masterVolume;
    }

    @Override
    protected boolean valid() {
        try {
            return this.soundSystem != null && this.soundManager != null && this.soundManagerLoaded.getBoolean(this.soundManager);
        }
        catch (Exception var2) {
            throw new RuntimeException();
        }
    }

    private static String getSourceName(int id) {
        return "asm_snd" + id;
    }

    public static class WeakObject
    extends WeakReference<Object> {
        public WeakObject(Object obj) {
            super(obj);
        }

        public boolean equals(Object object) {
            return object instanceof WeakObject ? ((WeakObject)object).get() == this.get() : this.get() == object;
        }

        public int hashCode() {
            Object object = this.get();
            return object == null ? 0 : object.hashCode();
        }
    }
}

