/*
 * Decompiled with CFR 0.152.
 */
package gravisuite.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.Config;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import gravisuite.keyboard.Keyboard;
import gravisuite.utils.Helpers;
import gravisuite.utils.NBTHelper;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ml.luxinfine.gravisuite.EventConfig;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemSVajra
extends ItemSword
implements IElectricItem {
    private final int maxCharge;
    private final int tier;
    private final float effPower;
    private final int energyPerOperation;
    private final int transferLimit;
    private final int toolMode;

    protected ItemSVajra(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.func_77656_e(27);
        this.maxCharge = 3000000;
        this.tier = 2;
        this.transferLimit = 60000;
        this.effPower = 20000.0f;
        this.energyPerOperation = 3333;
        this.func_77637_a(GraviSuite.graviSuiteCreativeTab);
        this.toolMode = 0;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"axe", (Object)"shovel");
    }

    public static int readToolMode(ItemStack itemStack) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        int toolMode = nbtTagCompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 1) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void saveToolMode(ItemStack itemStack, int toolMode) {
        NBTTagCompound nbtTagCompound = NBTHelper.getOrCreateNbtData(itemStack);
        nbtTagCompound.func_74768_a("toolMode", toolMode);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && Keyboard.isModeKeyDown(player)) {
            if (!Config.disableVajraAccurate) {
                int toolMode = ItemSVajra.readToolMode(itemStack);
                if (++toolMode > 1) {
                    toolMode = 0;
                }
                this.saveToolMode(itemStack, toolMode);
                if (toolMode == 0) {
                    ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GOLD + "{message.vajra.silkTouchMode}: " + EnumChatFormatting.RED + "{message.text.disabled}");
                }
                if (toolMode == 1) {
                    ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.GOLD + "{message.vajra.silkTouchMode}: " + EnumChatFormatting.GREEN + "{message.text.enabled}");
                }
            } else {
                ServerProxy.sendClientLocalizedMessage(player, EnumChatFormatting.RED + "{message.vajra.silkTouchDisabled}");
            }
        }
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int i, int j, int k, int side, float a, float b, float c) {
        int toolMode = ItemSVajra.readToolMode(itemStack);
        if (!world.field_72995_K && !Config.disableVajraAccurate && toolMode == 1) {
            try {
                int metaData = world.func_72805_g(i, j, k);
                Block block = world.func_147439_a(i, j, k);
                if (block != Blocks.field_150357_h && block != Blocks.field_150474_ac && block.canHarvestBlock(entityPlayer, metaData) && block.func_149650_a(metaData, world.field_73012_v, 1) != null) {
                    if (!ElectricItem.manager.canUse(itemStack, (double)this.energyPerOperation)) {
                        return false;
                    }
                    if (!world.field_72995_K) {
                        boolean dropFlag = false;
                        if (block.canSilkHarvest(world, entityPlayer, i, j, k, metaData)) {
                            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                            ItemStack stack = this.createStackedBlock(block, metaData);
                            if (stack != null) {
                                items.add(stack);
                            }
                            ForgeEventFactory.fireBlockHarvesting(items, (World)world, (Block)block, (int)i, (int)j, (int)k, (int)metaData, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)entityPlayer);
                            for (ItemStack is : items) {
                                Helpers.dropAsEntity(world, i, j, k, is);
                            }
                            dropFlag = true;
                        } else {
                            int count = block.quantityDropped(metaData, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemStack), world.field_73012_v);
                            if (count > 0) {
                                int exp = block.getExpDrop((IBlockAccess)world, metaData, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemStack));
                                block.func_149657_c(world, i, j, k, exp);
                                float blockHardness = block.func_149712_f(world, i, j, k);
                                block.func_149681_a(world, i, j, k, metaData, entityPlayer);
                                if (block.removedByPlayer(world, entityPlayer, i, j, k, true)) {
                                    block.func_149664_b(world, i, j, k, metaData);
                                    block.func_149636_a(world, entityPlayer, i, j, k, metaData);
                                }
                                if (blockHardness > 0.0f) {
                                    this.func_150894_a(itemStack, world, block, i, j, k, (EntityLivingBase)entityPlayer);
                                }
                                world.func_147479_m(i, j, k);
                                dropFlag = true;
                            }
                        }
                        if (dropFlag) {
                            world.func_147468_f(i, j, k);
                            world.func_147479_m(i, j, k);
                            world.func_72926_e(2001, i, j, k, Block.func_149682_b((Block)block) + (metaData << 12));
                            ElectricItem.manager.use(itemStack, (double)this.energyPerOperation, (EntityLivingBase)entityPlayer);
                        }
                    }
                    return true;
                }
            }
            catch (Exception var22) {
                GraviSuite.addLog("Vajra: Error in destroy function (" + var22.getLocalizedMessage() + ")");
            }
        }
        return false;
    }

    protected ItemStack createStackedBlock(Block block, int meta) {
        int j = 0;
        Item item = Item.func_150898_a((Block)block);
        if (item != null && item.func_77614_k()) {
            j = meta;
        }
        return new ItemStack(item, 1, j);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return block != Blocks.field_150357_h;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return EventConfig.vajraLvl;
    }

    public float getDigSpeed(ItemStack tool, Block block, int meta) {
        return ElectricItem.manager.canUse(tool, (double)this.energyPerOperation) ? (this.canHarvestBlock(block, tool) ? this.effPower : 1.0f) : 1.0f;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase entityLivingBase, EntityLivingBase attacker) {
        return attacker.field_70170_p.field_72995_K || ElectricItem.manager.use(item, (double)(this.energyPerOperation * 2), attacker);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", ElectricItem.manager.canUse(stack, (double)(this.energyPerOperation * 2)) ? 25.0 : 1.0, 0));
        return multimap;
    }

    public int func_77619_b() {
        return EventConfig.vajraEnchantableLvl;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("gravisuite:itemVajra");
    }

    public float getStrVsBlock(ItemStack itemStack, Block block) {
        return ElectricItem.manager.canUse(itemStack, (double)this.energyPerOperation) ? this.effPower : 0.5f;
    }

    public boolean func_150894_a(ItemStack itemstack, World world, Block block, int xPos, int yPos, int zPos, EntityLivingBase entityLivingBase) {
        if (!world.field_72995_K && (double)block.func_149712_f(world, xPos, yPos, zPos) > 0.0) {
            if (entityLivingBase != null) {
                ElectricItem.manager.use(itemstack, (double)this.energyPerOperation, entityLivingBase);
            } else {
                ElectricItem.manager.discharge(itemstack, (double)this.energyPerOperation, this.tier, true, false, false);
            }
        }
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack var1) {
        return EnumRarity.epic;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        Integer toolMode = ItemSVajra.readToolMode(itemStack);
        if (toolMode == 0) {
            list.add(EnumChatFormatting.RED + Helpers.formatMessage("message.vajra.silkTouchMode") + ": " + EnumChatFormatting.DARK_RED + Helpers.formatMessage("message.text.disabled"));
        }
        if (toolMode == 1) {
            list.add(EnumChatFormatting.RED + Helpers.formatMessage("message.vajra.silkTouchMode") + ": " + EnumChatFormatting.GREEN + Helpers.formatMessage("message.text.enabled"));
        }
        list.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(itemStack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs var2, List var3) {
        ItemStack var4 = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
        var3.add(var4);
        var3.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }
}

