/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.network.ChannelHandler;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketAcounter;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketClientColor;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketClientDisplaySettings;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketClientRangeTrigger;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketClientRequest;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketClientSensor;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketClientSound;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketDispSettingsAll;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketDispSettingsUpdate;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketEncounter;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketSensor;
import shedar.mods.ic2.nuclearcontrol.network.message.PacketSensorTitle;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAverageCounter;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityEnergyCounter;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;

public class NuclearNetworkHelper {
    public static final int FIELD_DOUBLE = 1;
    public static final int FIELD_INT = 2;
    public static final int FIELD_STRING = 3;
    public static final int FIELD_BOOLEAN = 4;
    public static final int FIELD_TAG = 5;
    public static final int FIELD_NULL = 6;
    public static final int FIELD_LONG = 7;

    public static void sendEnergyCounterValue(TileEntityEnergyCounter counter, ICrafting crafter) {
        if (counter == null || !(crafter instanceof EntityPlayerMP)) {
            return;
        }
        ChannelHandler.network.sendTo((IMessage)new PacketEncounter(counter.field_145851_c, counter.field_145848_d, counter.field_145849_e, counter.counter), (EntityPlayerMP)crafter);
    }

    public static void sendAverageCounterValue(TileEntityAverageCounter counter, ICrafting crafter, int average) {
        if (counter == null || !(crafter instanceof EntityPlayerMP)) {
            return;
        }
        ChannelHandler.network.sendTo((IMessage)new PacketAcounter(counter.field_145851_c, counter.field_145848_d, counter.field_145849_e, average), (EntityPlayerMP)crafter);
    }

    private static void sendPacketToAllAround(int x, int y, int z, int dist, World world, IMessage packet) {
        List players = world.field_73010_i;
        for (EntityPlayerMP player : players) {
            double dx = (double)x - player.field_70165_t;
            double dy = (double)y - player.field_70163_u;
            double dz = (double)z - player.field_70161_v;
            if (!(dx * dx + dy * dy + dz * dz < (double)(dist * dist))) continue;
            ChannelHandler.network.sendTo(packet, player);
        }
    }

    public static void setSensorCardField(TileEntity panel, byte slot, Map<String, Object> fields) {
        if (fields == null || fields.isEmpty() || panel == null || !(panel instanceof TileEntityInfoPanel) || slot == -1) {
            return;
        }
        if (panel.func_145831_w().field_72995_K) {
            return;
        }
        NuclearNetworkHelper.sendPacketToAllAround(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, 64, panel.func_145831_w(), new PacketSensor(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, slot, fields));
    }

    public static void setDisplaySettings(TileEntityInfoPanel panel, byte slot, int settings) {
        if (panel == null) {
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return;
        }
        ChannelHandler.network.sendToServer((IMessage)new PacketClientDisplaySettings(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, slot, settings));
    }

    public static void setCardSettings(ItemStack card, TileEntity panelTE, Map<String, Object> fields, int slot) {
        if (card == null || fields == null || fields.isEmpty() || panelTE == null || !(panelTE instanceof TileEntityInfoPanel)) {
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return;
        }
        ChannelHandler.network.sendToServer((IMessage)new PacketClientSensor(panelTE.field_145851_c, panelTE.field_145848_d, panelTE.field_145849_e, slot, card.func_77973_b().getClass().getName(), fields));
    }

    public static void setSensorCardTitle(TileEntityInfoPanel panel, byte slot, String title) {
        if (title == null || panel == null) {
            return;
        }
        NuclearNetworkHelper.sendPacketToAllAround(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, 64, panel.func_145831_w(), new PacketSensorTitle(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, slot, title));
    }

    public static void chatMessage(EntityPlayer player, String message) {
        String[] chunks = message.split(":");
        if (chunks.length > 1) {
            Object[] args = new Object[chunks.length - 1];
            System.arraycopy(chunks, 1, args, 0, chunks.length - 1);
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.nc." + chunks[0], args));
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("msg.nc." + chunks[0], new Object[0]));
        }
    }

    public static void setNewAlarmSound(int x, int y, int z, byte slot, String soundName) {
        ChannelHandler.network.sendToServer((IMessage)new PacketClientSound(x, y, z, slot, soundName));
    }

    public static void setRangeTrigger(int x, int y, int z, double value, boolean isEnd) {
        ChannelHandler.network.sendToServer((IMessage)new PacketClientRangeTrigger(x, y, z, value, isEnd));
    }

    public static void setScreenColor(int x, int y, int z, int back, int text) {
        ChannelHandler.network.sendToServer((IMessage)new PacketClientColor(x, y, z, back << 4 | text));
    }

    public static void requestDisplaySettings(TileEntityInfoPanel panel) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            ChannelHandler.network.sendToServer((IMessage)new PacketClientRequest(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e));
        }
    }

    public static void sendDisplaySettingsToPlayer(int x, int y, int z, EntityPlayerMP player) {
        TileEntity tileEntity = player.field_70170_p.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityInfoPanel)) {
            return;
        }
        Map<Byte, Map<UUID, Integer>> settings = ((TileEntityInfoPanel)tileEntity).getDisplaySettings();
        if (settings == null) {
            return;
        }
        ChannelHandler.network.sendTo((IMessage)new PacketDispSettingsAll(x, y, z, settings), player);
    }

    public static void sendDisplaySettingsUpdate(TileEntityInfoPanel panel, byte slot, UUID key, int value) {
        NuclearNetworkHelper.sendPacketToAllAround(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, 64, panel.func_145831_w(), new PacketDispSettingsUpdate(panel.field_145851_c, panel.field_145848_d, panel.field_145849_e, slot, key, value));
    }
}

