/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.miccore;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import micdoodle8.mods.miccore.ConfigManagerMicCore;
import micdoodle8.mods.miccore.DepLoader;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.io.FileUtils;

@IFMLLoadingPlugin.TransformerExclusions(value={"micdoodle8.mods.miccore"})
public class MicdoodlePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static boolean hasRegistered = false;
    public static final String mcVersion = "[1.7.2],[1.7.10]";
    public static File mcDir;
    public static File canonicalConfigDir;
    private static boolean checkedVersions;
    private static Constructor<?> sleepCancelledConstructor;
    private static Constructor<?> orientCameraConstructor;
    private static String galacticraftCoreClass;

    public MicdoodlePlugin() {
        DepLoader.load();
    }

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support minecraft version " + mcVersion;
            System.err.println(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your mods folder and check <a href=\"http://micdoodle8.com\">here</a> for updates" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public String[] getASMTransformerClass() {
        MicdoodlePlugin.versionCheck(mcVersion, "MicdoodleCore");
        String[] asmStrings = new String[]{"micdoodle8.mods.miccore.MicdoodleTransformer"};
        if (!hasRegistered) {
            List<String> asm = Arrays.asList(asmStrings);
            for (String s : asm) {
                try {
                    Class<?> c = Class.forName(s);
                    if (c == null) continue;
                    System.out.println("Successfully Registered Transformer");
                }
                catch (Exception ex) {
                    System.out.println("Error while running transformer " + s);
                    return null;
                }
            }
            hasRegistered = true;
        }
        return asmStrings;
    }

    public String getModContainerClass() {
        return "micdoodle8.mods.miccore.MicdoodleModContainer";
    }

    public String getSetupClass() {
        return "micdoodle8.mods.miccore.MicdoodlePlugin";
    }

    public void injectData(Map<String, Object> data) {
        if (data.containsKey("mcLocation")) {
            String canonicalConfigPath;
            mcDir = (File)data.get("mcLocation");
            File configDir = new File(mcDir, "config");
            File modsDir = new File(mcDir, "mods");
            String minecraftVersion = (String)FMLInjectionData.data()[4];
            File subDir = new File(modsDir, minecraftVersion);
            if (!checkedVersions) {
                checkedVersions = true;
                boolean obfuscated = false;
                try {
                    obfuscated = Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (obfuscated) {
                    Collection fileList = FileUtils.listFiles((File)modsDir, (String[])new String[]{"jar", "zip"}, (boolean)false);
                    String[] micCoreVersion = null;
                    String[] gcVersion = null;
                    if (fileList != null) {
                        if (subDir.isDirectory()) {
                            fileList.addAll(FileUtils.listFiles((File)subDir, (String[])new String[]{"jar", "zip"}, (boolean)false));
                        }
                        for (File file : fileList) {
                            String micVersion;
                            String[] split0;
                            String fileName;
                            if (file.getName().toLowerCase().contains("dragonapi") && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                                this.jarIntegrityCheck(file, true);
                            }
                            if (file.getName().toLowerCase().contains("micdoodlecore")) {
                                fileName = file.getName().toLowerCase();
                                split0 = fileName.split("\\-");
                                if (split0.length == 4) {
                                    micVersion = split0[3].replace(".jar", "").replace(".zip", "");
                                    micCoreVersion = micVersion.split("\\.");
                                } else if (split0.length == 3) {
                                    micVersion = split0[2].replace(".jar", "").replace(".zip", "");
                                    micCoreVersion = micVersion.split("\\.");
                                }
                                if (!this.jarIntegrityCheck(file, false)) {
                                    MicdoodlePlugin.showErrorDialog(new Object[]{"Re-download", "Ignore"}, "Mod file " + file.getName() + " is an incomplete download and will likely cause errors, please re-download it!");
                                }
                            }
                            if (file.getName().toLowerCase().contains("galacticraftcore")) {
                                fileName = file.getName().toLowerCase();
                                split0 = fileName.split("\\-");
                                if (split0.length == 4) {
                                    micVersion = split0[3].replace(".jar", "").replace(".zip", "");
                                    gcVersion = micVersion.split("\\.");
                                } else if (split0.length == 3) {
                                    micVersion = split0[2].replace(".jar", "").replace(".zip", "");
                                    gcVersion = micVersion.split("\\.");
                                }
                                if (!this.jarIntegrityCheck(file, false)) {
                                    MicdoodlePlugin.showErrorDialog(new Object[]{"Re-download", "Ignore"}, "Mod file " + file.getName() + " is an incomplete download and will likely cause errors, please re-download it!");
                                }
                            }
                            if (!file.getName().toLowerCase().contains("galacticraft-planets") || this.jarIntegrityCheck(file, false)) continue;
                            MicdoodlePlugin.showErrorDialog(new Object[]{"Re-download", "Ignore"}, "Mod file " + file.getName() + " is an incomplete download and will likely cause errors, please re-download it!");
                        }
                    }
                    if (micCoreVersion == null) {
                        FMLLog.info((String)"Failed to find MicdoodleCore file in mods folder, skipping GC version check.", (Object[])new Object[0]);
                    } else if (gcVersion == null) {
                        MicdoodlePlugin.showErrorDialog(new Object[]{"Install", "Ignore"}, "Failed to find Galacticraft file in mods folder!");
                    } else if (micCoreVersion.length != gcVersion.length) {
                        MicdoodlePlugin.showErrorDialog(new Object[]{"Reinstall", "Ignore"}, "Failed to match Galacticraft version to MicdoodleCore version!");
                    } else {
                        int i;
                        for (i = 0; i < (micCoreVersion.length & gcVersion.length); ++i) {
                            micCoreVersion[i] = this.trimInvalidIntegers((String)micCoreVersion[i]);
                            gcVersion[i] = this.trimInvalidIntegers((String)gcVersion[i]);
                        }
                        for (i = 0; i < micCoreVersion.length; ++i) {
                            int gcVersionI;
                            if (micCoreVersion[i].equals(gcVersion[i])) continue;
                            int micCoreVersionI = Integer.parseInt((String)micCoreVersion[i]);
                            if (micCoreVersionI < (gcVersionI = Integer.parseInt((String)gcVersion[i]))) {
                                MicdoodlePlugin.showErrorDialog(new Object[]{"Update", "Ignore"}, "MicdoodleCore Update Required!", "Galacticraft and MicdoodleCore should always be at the same version", "Severe issues can be caused from not updating");
                                continue;
                            }
                            MicdoodlePlugin.showErrorDialog(new Object[]{"Update", "Ignore"}, "Galacticraft Update Required!", "Galacticraft and MicdoodleCore should always be at the same version", "Severe issues can be caused from not updating");
                        }
                    }
                }
            }
            try {
                canonicalConfigPath = configDir.getCanonicalPath();
                canonicalConfigDir = configDir.getCanonicalFile();
            }
            catch (IOException ioe) {
                throw new LoaderException((Throwable)ioe);
            }
            if (!canonicalConfigDir.exists()) {
                FMLLog.fine((String)"No config directory found, creating one: %s", (Object[])new Object[]{canonicalConfigPath});
                boolean dirMade = canonicalConfigDir.mkdir();
                if (!dirMade) {
                    FMLLog.severe((String)"Unable to create the config directory %s", (Object[])new Object[]{canonicalConfigPath});
                    throw new LoaderException();
                }
                FMLLog.info((String)"Config directory created successfully", (Object[])new Object[0]);
            }
            ConfigManagerMicCore.init();
        }
        System.out.println("[Micdoodle8Core]: Patching game...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jarIntegrityCheck(File file, boolean checkDragonAPI) {
        ZipFile zipfile = null;
        ZipInputStream zis = null;
        try {
            zipfile = new ZipFile(file);
            zis = new ZipInputStream(new FileInputStream(file));
            ZipEntry ze = zis.getNextEntry();
            if (ze == null) {
                boolean bl = false;
                return bl;
            }
            while (ze != null) {
                zipfile.getInputStream(ze);
                ze.getCrc();
                ze.getCompressedSize();
                if (checkDragonAPI && "micdoodle8/mods/galacticraft/api/".equals(ze.getName())) {
                    MicdoodlePlugin.showErrorDialog(new Object[]{"Quit", "Ignore"}, "DragonAPI will prevent Galacticraft from working properly!", "To fix: remove or modify DragonAPI", "More info: http://wiki.micdoodle8.com/wiki/Compatibility");
                } else {
                    ze.getName();
                }
                ze = zis.getNextEntry();
            }
            boolean bl = true;
            return bl;
        }
        catch (ZipException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (IOException e) {
                return false;
            }
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    public static void showErrorDialog(Object[] options, String ... messages) {
        try {
            String err = "<html>";
            for (String s : messages) {
                System.err.print(s);
                err = err.concat(s + "<br />");
            }
            err = err.concat("</html>");
            JEditorPane ep = new JEditorPane("text/html", err);
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            int ret = JOptionPane.showOptionDialog(null, ep, "Fatal error", -1, 0, null, options, options[0]);
            System.err.println(ret);
            switch (ret) {
                case 0: {
                    try {
                        if ("Quit".equals(options[0])) {
                            Desktop.getDesktop().browse(new URL("http://wiki.micdoodle8.com/wiki/Compatibility#DragonAPI").toURI());
                        } else {
                            Desktop.getDesktop().browse(new URL("http://micdoodle8.com/mods/galacticraft/downloads").toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.exit(0);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: Lacking graphical display: unable to display normal error messagebox with options.");
            System.out.println("-----------------------------------------------------------------------------------------");
            System.out.println("The error would have been:");
            for (int i = 0; i < messages.length; ++i) {
                System.out.println("    " + messages[i]);
            }
        }
    }

    private String trimInvalidIntegers(String toTrim) {
        String c;
        String newString = "";
        for (int j = 0; j < toTrim.length() && "0123456789".contains(c = toTrim.substring(j, j + 1)); ++j) {
            newString = newString.concat(c);
        }
        return newString;
    }

    public Void call() throws Exception {
        return null;
    }

    public static void onSleepCancelled() {
        try {
            if (sleepCancelledConstructor == null) {
                sleepCancelledConstructor = Class.forName(galacticraftCoreClass + "$SleepCancelledEvent").getConstructor(new Class[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)sleepCancelledConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void orientCamera() {
        try {
            if (orientCameraConstructor == null) {
                orientCameraConstructor = Class.forName(galacticraftCoreClass + "$OrientCameraEvent").getConstructor(new Class[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)orientCameraConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAccessTransformerClass() {
        boolean deobfuscated = true;
        try {
            deobfuscated = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (deobfuscated) {
            return "micdoodle8.mods.miccore.MicdoodleAccessTransformerDeObf";
        }
        return "micdoodle8.mods.miccore.MicdoodleAccessTransformer";
    }

    static {
        checkedVersions = false;
        galacticraftCoreClass = "micdoodle8.mods.galacticraft.core.event.EventHandlerGC";
    }
}

