/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.fsp.handlers;

import flaxbeard.steamcraft.api.CrucibleFormula;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.Tuple3;
import java.util.HashMap;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.fsp.FSPHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.MutablePair;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.fsp.Crucible")
public class Crucible {
    public static final String nameLiquid = "FSP Crucible (Liquid)";
    public static final String nameMelting = "FSP Crucible (Liquid)";
    public static final String nameDunking = "FSP Crucible (Dunking)";

    @ZenMethod
    public static void addLiquid(String name, IItemStack ingot, IItemStack plate, IItemStack nugget, int r, int g, int b) {
        MineTweakerAPI.apply((IUndoableAction)new AddLiquid(new CrucibleLiquid(name, InputHelper.toStack(ingot), InputHelper.toStack(plate), InputHelper.toStack(nugget), null, r, g, b)));
    }

    @ZenMethod
    public static void addLiquid(String name, IItemStack ingot, IItemStack plate, IItemStack nugget, int r, int g, int b, String l1, int n1, String l2, int n2, int n3) {
        MineTweakerAPI.apply((IUndoableAction)new AddLiquid(new CrucibleLiquid(name, InputHelper.toStack(ingot), InputHelper.toStack(plate), InputHelper.toStack(nugget), new CrucibleFormula(FSPHelper.getLiquid(l1), n1, FSPHelper.getLiquid(l2), n2, n3), r, g, b)));
    }

    @ZenMethod
    public static void addMelting(IItemStack input, String liquid, int volume) {
        ItemStack stack = InputHelper.toStack(input);
        CrucibleLiquid fluid = FSPHelper.getLiquid(liquid);
        if (fluid != null) {
            MineTweakerAPI.apply((IUndoableAction)new AddMelting(stack, (MutablePair<Item, Integer>)MutablePair.of((Object)stack.func_77973_b(), (Object)stack.func_77960_j()), (MutablePair<CrucibleLiquid, Integer>)MutablePair.of((Object)fluid, (Object)volume)));
        }
    }

    @ZenMethod
    public static void removeMelting(IIngredient input) {
        HashMap<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> recipes = new HashMap<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>>();
        for (Map.Entry entry : SteamcraftRegistry.smeltThings.entrySet()) {
            if (!StackHelper.matches(input, InputHelper.toIItemStack(new ItemStack((Item)((MutablePair)entry.getKey()).left, 1, ((Integer)((MutablePair)entry.getKey()).right).intValue())))) continue;
            recipes.put((MutablePair<Item, Integer>)entry.getKey(), (MutablePair<CrucibleLiquid, Integer>)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMelting(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipes found for %s", "FSP Crucible (Liquid)", input));
        }
    }

    @ZenMethod
    public static void addDunking(IItemStack input, String liquid, int volume, IItemStack output) {
        ItemStack stack = InputHelper.toStack(input);
        CrucibleLiquid fluid = FSPHelper.getLiquid(liquid);
        if (fluid != null) {
            MineTweakerAPI.apply((IUndoableAction)new AddDunking(new Tuple3((Object)stack.func_77973_b(), (Object)stack.func_77960_j(), (Object)fluid), (MutablePair<Integer, ItemStack>)MutablePair.of((Object)volume, (Object)InputHelper.toStack(output))));
        }
    }

    @ZenMethod
    public static void removeDunking(IIngredient input, String liquid) {
        HashMap<Tuple3, MutablePair<Integer, ItemStack>> recipes = new HashMap<Tuple3, MutablePair<Integer, ItemStack>>();
        for (Map.Entry recipe : SteamcraftRegistry.dunkThings.entrySet()) {
            if (recipe.getValue() == null || ((MutablePair)recipe.getValue()).right == null || !StackHelper.matches(input, InputHelper.toIItemStack((ItemStack)((MutablePair)recipe.getValue()).right)) || !((CrucibleLiquid)((Tuple3)recipe.getKey()).third).equals(FSPHelper.getLiquid(liquid))) continue;
            recipes.put((Tuple3)recipe.getKey(), (MutablePair<Integer, ItemStack>)recipe.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveDunking(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s and %s. Command ignored!", nameDunking, input.toString(), liquid));
        }
    }

    private static class RemoveDunking
    extends BaseMapRemoval<Tuple3, MutablePair<Integer, ItemStack>> {
        public RemoveDunking(Map<Tuple3, MutablePair<Integer, ItemStack>> recipes) {
            super(Crucible.nameDunking, SteamcraftRegistry.dunkThings, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<Tuple3, MutablePair<Integer, ItemStack>> recipe) {
            return LogHelper.getStackDescription(recipe.getValue().right);
        }
    }

    private static class AddDunking
    extends BaseMapAddition<Tuple3, MutablePair<Integer, ItemStack>> {
        public AddDunking(Tuple3 key, MutablePair<Integer, ItemStack> recipe) {
            super(Crucible.nameDunking, SteamcraftRegistry.dunkThings);
            this.recipes.put(key, recipe);
        }

        @Override
        public String getRecipeInfo(Map.Entry<Tuple3, MutablePair<Integer, ItemStack>> recipe) {
            return LogHelper.getStackDescription(recipe.getValue().right);
        }
    }

    private static class RemoveMelting
    extends BaseMapRemoval<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> {
        public RemoveMelting(Map<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> recipes) {
            super("FSP Crucible (Liquid)", SteamcraftRegistry.smeltThings, recipes);
        }

        @Override
        protected String getRecipeInfo(Map.Entry<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> recipe) {
            return LogHelper.getStackDescription(new ItemStack((Item)recipe.getKey().left, 1, ((Integer)recipe.getKey().right).intValue()));
        }
    }

    private static class AddMelting
    extends BaseMapAddition<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> {
        public AddMelting(ItemStack stack, MutablePair<Item, Integer> key, MutablePair<CrucibleLiquid, Integer> recipe) {
            super("FSP Crucible (Liquid)", SteamcraftRegistry.smeltThings);
            this.map.put(key, recipe);
        }

        @Override
        protected String getRecipeInfo(Map.Entry<MutablePair<Item, Integer>, MutablePair<CrucibleLiquid, Integer>> recipe) {
            return LogHelper.getStackDescription(new ItemStack((Item)recipe.getKey().left, 1, ((Integer)recipe.getKey().right).intValue()));
        }
    }

    private static class AddLiquid
    extends BaseListAddition<CrucibleLiquid> {
        public AddLiquid(CrucibleLiquid recipe) {
            super("FSP Crucible (Liquid)", SteamcraftRegistry.liquids);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(CrucibleLiquid recipe) {
            return recipe.name;
        }
    }
}

