/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.NEIChestGuiHandler;
import codechicken.nei.NEICreativeGuiHandler;
import codechicken.nei.NEIDummySlotHandler;
import codechicken.nei.NEIPotionGuiHandler;
import codechicken.nei.api.API;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.recipe.CheatItemHandler;
import codechicken.nei.recipe.FillFluidContainerHandler;
import codechicken.nei.recipe.GuiRecipeCatalyst;
import codechicken.nei.recipe.SearchInputDropHandler;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;

public class GuiInfo {
    public static final LinkedList<INEIGuiHandler> guiHandlers = new LinkedList();
    public static final HashSet<Class<? extends GuiContainer>> customSlotGuis = new HashSet();
    public static ReentrantReadWriteLock guiHandlersLock = new ReentrantReadWriteLock();
    public static Lock writeLock = guiHandlersLock.writeLock();
    public static Lock readLock = guiHandlersLock.readLock();

    public static void load() {
        API.registerNEIGuiHandler(new NEICreativeGuiHandler());
        API.registerNEIGuiHandler(new NEIChestGuiHandler());
        API.registerNEIGuiHandler(new NEIDummySlotHandler());
        API.registerNEIGuiHandler(new GuiRecipeCatalyst(null));
        API.registerNEIGuiHandler(new SearchInputDropHandler());
        API.registerNEIGuiHandler(new FillFluidContainerHandler());
        API.registerNEIGuiHandler(new CheatItemHandler());
        API.registerNEIGuiHandler(new NEIPotionGuiHandler());
        customSlotGuis.add(GuiContainerCreative.class);
    }

    public static void clearGuiHandlers() {
        try {
            writeLock.lock();
            guiHandlers.removeIf(ineiGuiHandler -> ineiGuiHandler instanceof GuiContainer);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static boolean hasCustomSlots(GuiContainer gui) {
        return customSlotGuis.contains(gui.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hideItemPanelSlot(GuiContainer gui, Rectangle4i rect) {
        try {
            readLock.lock();
            for (INEIGuiHandler handler : guiHandlers) {
                if (!handler.hideItemPanelSlot(gui, rect.x, rect.y, rect.w, rect.h)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            readLock.unlock();
        }
        for (Object item : gui.field_146292_n) {
            GuiButton button = (GuiButton)item;
            if (!new Rectangle4i(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g).intersects(rect)) continue;
            return true;
        }
        return false;
    }
}

