/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.gamerforea.parallelmipmap.ParallelUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureClock;
import net.minecraft.client.renderer.texture.TextureCompass;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class TextureMap
extends AbstractTexture
implements ITickableTextureObject,
IIconRegister {
    private static final boolean ENABLE_SKIP = Boolean.parseBoolean(System.getProperty("fml.skipFirstTextureLoad", "true"));
    private static final Logger field_147635_d = LogManager.getLogger();
    public static final ResourceLocation field_110575_b = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation field_110576_c = new ResourceLocation("textures/atlas/items.png");
    private final List field_94258_i = Lists.newArrayList();
    private final Map field_110574_e = Maps.newHashMap();
    private final Map field_94252_e = Maps.newHashMap();
    private final int field_94255_a;
    private final String field_94254_c;
    private int field_147636_j;
    private int field_147637_k = 1;
    private final TextureAtlasSprite field_94249_f = new TextureAtlasSprite("missingno");
    private static final String __OBFID = "CL_00001058";
    private boolean skipFirst = false;

    public TextureMap(int p_i1281_1_, String p_i1281_2_) {
        this(p_i1281_1_, p_i1281_2_, false);
    }

    public TextureMap(int p_i1281_1_, String p_i1281_2_, boolean skipFirst) {
        this.field_94255_a = p_i1281_1_;
        this.field_94254_c = p_i1281_2_;
        this.func_110573_f();
        this.skipFirst = skipFirst && ENABLE_SKIP;
    }

    private void func_110569_e() {
        int[] aint;
        if ((float)this.field_147637_k > 1.0f) {
            boolean flag = true;
            boolean flag1 = true;
            boolean flag2 = true;
            this.field_94249_f.func_110966_b(32);
            this.field_94249_f.func_110969_c(32);
            aint = new int[1024];
            System.arraycopy(TextureUtil.field_110999_b, 0, aint, 0, TextureUtil.field_110999_b.length);
            TextureUtil.func_147948_a((int[])aint, (int)16, (int)16, (int)8);
        } else {
            aint = TextureUtil.field_110999_b;
            this.field_94249_f.func_110966_b(16);
            this.field_94249_f.func_110969_c(16);
        }
        int[][] aint1 = new int[this.field_147636_j + 1][];
        aint1[0] = aint;
        this.field_94249_f.func_110968_a((List)Lists.newArrayList((Object[])new int[][][]{aint1}));
    }

    public void func_110551_a(IResourceManager p_110551_1_) throws IOException {
        this.func_110569_e();
        this.func_147631_c();
        this.func_110571_b(p_110551_1_);
    }

    public void func_110571_b(IResourceManager p_110571_1_) {
        TextureAtlasSprite textureatlassprite2;
        this.func_110573_f();
        int i = Minecraft.func_71369_N();
        Stitcher stitcher = new Stitcher(i, i, true, 0, this.field_147636_j);
        this.field_94252_e.clear();
        this.field_94258_i.clear();
        int j = Integer.MAX_VALUE;
        ForgeHooksClient.onTextureStitchedPre((TextureMap)this);
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Texture Loading", (int)(this.skipFirst ? 0 : this.field_110574_e.size()));
        Iterator iterator = this.field_110574_e.entrySet().iterator();
        while (!this.skipFirst && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ResourceLocation resourcelocation = new ResourceLocation((String)entry.getKey());
            textureatlassprite2 = (TextureAtlasSprite)entry.getValue();
            ResourceLocation resourcelocation1 = this.func_147634_a(resourcelocation, 0);
            bar.step(resourcelocation1.func_110623_a());
            if (textureatlassprite2.hasCustomLoader(p_110571_1_, resourcelocation)) {
                if (textureatlassprite2.load(p_110571_1_, resourcelocation)) continue;
                j = Math.min(j, Math.min(textureatlassprite2.func_94211_a(), textureatlassprite2.func_94216_b()));
                stitcher.func_110934_a(textureatlassprite2);
                continue;
            }
            try {
                IResource iresource = p_110571_1_.func_110536_a(resourcelocation1);
                BufferedImage[] abufferedimage = new BufferedImage[1 + this.field_147636_j];
                abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
                TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                if (texturemetadatasection != null) {
                    int l;
                    List list = texturemetadatasection.func_148535_c();
                    if (!list.isEmpty()) {
                        int k = abufferedimage[0].getWidth();
                        l = abufferedimage[0].getHeight();
                        if (MathHelper.func_151236_b((int)k) != k || MathHelper.func_151236_b((int)l) != l) {
                            throw new RuntimeException("Unable to load extra miplevels, source-texture is not power of two");
                        }
                    }
                    Iterator iterator3 = list.iterator();
                    while (iterator3.hasNext()) {
                        l = (Integer)iterator3.next();
                        if (l <= 0 || l >= abufferedimage.length - 1 || abufferedimage[l] != null) continue;
                        ResourceLocation resourcelocation2 = this.func_147634_a(resourcelocation, l);
                        try {
                            abufferedimage[l] = ImageIO.read(p_110571_1_.func_110536_a(resourcelocation2).func_110527_b());
                        }
                        catch (IOException ioexception) {
                            field_147635_d.error("Unable to load miplevel {} from: {}", new Object[]{l, resourcelocation2, ioexception});
                        }
                    }
                }
                AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
                textureatlassprite2.func_147964_a(abufferedimage, animationmetadatasection, (float)this.field_147637_k > 1.0f);
            }
            catch (RuntimeException runtimeexception) {
                FMLClientHandler.instance().trackBrokenTexture(resourcelocation1, runtimeexception.getMessage());
                continue;
            }
            catch (IOException ioexception1) {
                FMLClientHandler.instance().trackMissingTexture(resourcelocation1);
                continue;
            }
            j = Math.min(j, Math.min(textureatlassprite2.func_94211_a(), textureatlassprite2.func_94216_b()));
            stitcher.func_110934_a(textureatlassprite2);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        int i1 = MathHelper.func_151239_c((int)j);
        if (i1 < this.field_147636_j) {
            field_147635_d.debug("{}: dropping miplevel from {} to {}, because of minTexel: {}", new Object[]{this.field_94254_c, this.field_147636_j, i1, j});
            this.field_147636_j = i1;
        }
        Iterator<TextureAtlasSprite> iterator1 = this.field_110574_e.values().iterator();
        bar = ProgressManager.push((String)"Mipmap generation", (int)(this.skipFirst ? 0 : this.field_110574_e.size()));
        if (!this.skipFirst) {
            ParallelUtils.generateMipMaps_MultiThread(iterator1, bar, this.field_147636_j);
        }
        this.field_94249_f.func_147963_d(this.field_147636_j);
        stitcher.func_110934_a(this.field_94249_f);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        this.skipFirst = false;
        bar = ProgressManager.push((String)"Texture creation", (int)3);
        bar.step("Stitching");
        stitcher.func_94305_f();
        field_147635_d.info("Created: {}x{} {}-atlas", new Object[]{stitcher.func_110935_a(), stitcher.func_110936_b(), this.field_94254_c});
        bar.step("Allocating GL texture");
        TextureUtil.func_147946_a((int)this.func_110552_b(), (int)this.field_147636_j, (int)stitcher.func_110935_a(), (int)stitcher.func_110936_b(), (float)this.field_147637_k);
        HashMap hashmap = Maps.newHashMap((Map)this.field_110574_e);
        Iterator<Object> iterator2 = stitcher.func_94309_g().iterator();
        bar.step("Uploading GL texture");
        while (iterator2.hasNext()) {
            textureatlassprite2 = (TextureAtlasSprite)iterator2.next();
            String s = textureatlassprite2.func_94215_i();
            hashmap.remove(s);
            this.field_94252_e.put(s, textureatlassprite2);
            try {
                TextureUtil.func_147955_a((int[][])textureatlassprite2.func_147965_a(0), (int)textureatlassprite2.func_94211_a(), (int)textureatlassprite2.func_94216_b(), (int)textureatlassprite2.func_130010_a(), (int)textureatlassprite2.func_110967_i(), (boolean)false, (boolean)false);
            }
            catch (Throwable throwable) {
                CrashReport crashreport1 = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Texture being stitched together");
                crashreportcategory1.func_71507_a("Atlas path", (Object)this.field_94254_c);
                crashreportcategory1.func_71507_a("Sprite", (Object)textureatlassprite2);
                throw new ReportedException(crashreport1);
            }
            if (textureatlassprite2.func_130098_m()) {
                this.field_94258_i.add(textureatlassprite2);
                continue;
            }
            textureatlassprite2.func_130103_l();
        }
        for (TextureAtlasSprite textureatlassprite2 : hashmap.values()) {
            textureatlassprite2.func_94217_a(this.field_94249_f);
        }
        ForgeHooksClient.onTextureStitchedPost((TextureMap)this);
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    private ResourceLocation func_147634_a(ResourceLocation p_147634_1_, int p_147634_2_) {
        return p_147634_2_ == 0 ? new ResourceLocation(p_147634_1_.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, p_147634_1_.func_110623_a(), ".png")) : new ResourceLocation(p_147634_1_.func_110624_b(), String.format("%s/mipmaps/%s.%d%s", this.field_94254_c, p_147634_1_.func_110623_a(), p_147634_2_, ".png"));
    }

    private void func_110573_f() {
        this.field_110574_e.clear();
        if (this.field_94255_a == 0) {
            for (Block block : Block.field_149771_c) {
                if (block.func_149688_o() == Material.field_151579_a) continue;
                block.func_149651_a((IIconRegister)this);
            }
            Minecraft.func_71410_x().field_71438_f.func_94140_a((IIconRegister)this);
            RenderManager.field_78727_a.func_94178_a((IIconRegister)this);
        }
        for (Item item : Item.field_150901_e) {
            if (item == null || item.func_94901_k() != this.field_94255_a) continue;
            item.func_94581_a((IIconRegister)this);
        }
    }

    public TextureAtlasSprite func_110572_b(String p_110572_1_) {
        TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.field_94252_e.get(p_110572_1_);
        if (textureatlassprite == null) {
            textureatlassprite = this.field_94249_f;
        }
        return textureatlassprite;
    }

    public void func_94248_c() {
        TextureUtil.func_94277_a((int)this.func_110552_b());
        for (TextureAtlasSprite textureatlassprite : this.field_94258_i) {
            textureatlassprite.func_94219_l();
        }
    }

    public IIcon func_94245_a(String p_94245_1_) {
        if (p_94245_1_ == null) {
            throw new IllegalArgumentException("Name cannot be null!");
        }
        if (p_94245_1_.indexOf(92) == -1) {
            Object object = (TextureAtlasSprite)this.field_110574_e.get(p_94245_1_);
            if (object == null) {
                object = this.field_94255_a == 1 ? ("clock".equals(p_94245_1_) ? new TextureClock(p_94245_1_) : ("compass".equals(p_94245_1_) ? new TextureCompass(p_94245_1_) : new TextureAtlasSprite(p_94245_1_))) : new TextureAtlasSprite(p_94245_1_);
                this.field_110574_e.put(p_94245_1_, object);
            }
            return (IIcon)object;
        }
        throw new IllegalArgumentException("Name cannot contain slashes!");
    }

    public int func_130086_a() {
        return this.field_94255_a;
    }

    public void func_110550_d() {
        this.func_94248_c();
    }

    public void func_147633_a(int p_147633_1_) {
        this.field_147636_j = p_147633_1_;
    }

    public void func_147632_b(int p_147632_1_) {
        this.field_147637_k = p_147632_1_;
    }

    public TextureAtlasSprite getTextureExtry(String name) {
        return (TextureAtlasSprite)this.field_110574_e.get(name);
    }

    public boolean setTextureEntry(String name, TextureAtlasSprite entry) {
        if (!this.field_110574_e.containsKey(name)) {
            this.field_110574_e.put(name, entry);
            return true;
        }
        return false;
    }
}

