/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.buildcraft;

import cpw.mods.fml.common.Loader;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.api.biome.buildcraft.config.BiomeConfigBC;
import rtg.util.Logger;
import rtg.world.biome.realistic.RealisticBiomeBase;
import rtg.world.biome.realistic.buildcraft.RealisticBiomeBCDesertOilField;
import rtg.world.biome.realistic.buildcraft.RealisticBiomeBCOceanOilField;
import rtg.world.gen.surface.SurfaceBase;
import rtg.world.gen.terrain.TerrainBase;

public class RealisticBiomeBCBase
extends RealisticBiomeBase {
    public static RealisticBiomeBase bcDesertOilField;
    public static RealisticBiomeBase bcOceanOilField;

    public RealisticBiomeBCBase(BiomeConfig config, BiomeGenBase b, BiomeGenBase riverbiome, TerrainBase t, SurfaceBase s) {
        super(config, b, riverbiome, t, s);
        this.waterSurfaceLakeChance = 0;
        this.lavaSurfaceLakeChance = 0;
    }

    public static void addBiomes() {
        if (Loader.isModLoaded((String)"BuildCraft|Core")) {
            BiomeGenBase[] b = BiomeGenBase.func_150565_n();
            for (int i = 0; i < 256; ++i) {
                if (b[i] == null) continue;
                if (b[i].field_76791_y == null) {
                    Logger.warn("Biome ID %d has no name.", b[i].field_76756_M);
                    continue;
                }
                BiomeGenBase bcBiome = b[i];
                String biomeName = b[i].field_76791_y;
                String biomeClass = b[i].func_150562_l().getName();
                if (biomeName == "Desert Oil Field" && biomeClass == "buildcraft.energy.worldgen.BiomeGenOilDesert") {
                    bcDesertOilField = new RealisticBiomeBCDesertOilField(bcBiome, BiomeConfigBC.biomeConfigBCDesertOilField);
                    continue;
                }
                if (biomeName != "Ocean Oil Field" || biomeClass != "buildcraft.energy.worldgen.BiomeGenOilOcean") continue;
                bcOceanOilField = new RealisticBiomeBCOceanOilField(bcBiome, BiomeConfigBC.biomeConfigBCOceanOilField);
            }
        }
    }
}

