/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.enhancedbiomes;

import enhancedbiomes.api.EBAPI;
import enhancedbiomes.blocks.EnhancedBiomesBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CellNoise;
import rtg.util.CliffCalculator;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.surface.enhancedbiomes.SurfaceEBBase;

public class SurfaceEBBorealPlateau
extends SurfaceEBBase {
    private Block blockMixTop;
    private byte byteMixTop;
    private Block blockMixFiller;
    private byte byteMixFiller;
    private Block blockCliff1;
    private byte byteCliff1;
    private Block blockCliff2;
    private byte byteCliff2;
    private float floMixWidth;
    private float floMixHeight;
    private float floSmallWidth;
    private float floSmallStrength;

    public SurfaceEBBorealPlateau(BiomeConfig config, Block top, byte topByte, Block filler, byte fillerByte, Block mixTop, byte mixTopByte, Block mixFiller, byte mixFillerByte, Block cliff1, byte cliff1Byte, Block cliff2, byte cliff2Byte, float mixWidth, float mixHeight, float smallWidth, float smallStrength) {
        super(config, top, topByte, filler, fillerByte);
        this.blockMixTop = mixTop;
        this.byteMixTop = mixTopByte;
        this.blockMixFiller = mixFiller;
        this.byteMixFiller = mixFillerByte;
        this.blockCliff1 = cliff1;
        this.byteCliff1 = cliff1Byte;
        this.blockCliff2 = cliff2;
        this.byteCliff2 = cliff2Byte;
        this.floMixWidth = mixWidth;
        this.floMixHeight = mixHeight;
        this.floSmallWidth = smallWidth;
        this.floSmallStrength = smallStrength;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 2.4f;
        boolean mix = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (this.shouldReplaceStone()) {
                blocks[(y * 16 + x) * 256 + k] = EBAPI.ebStonify(EnhancedBiomesBlocks.stoneEB, this.hcStone(world, i, j, x, y, k));
                metadata[(y * 16 + x) * 256 + k] = EBAPI.ebStonify((byte)8, this.hcStoneMeta(world, i, j, x, y, k));
            }
            if (cliff) {
                if (depth > -1 && depth < 2) {
                    if (rand.nextInt(3) == 0) {
                        blocks[(y * 16 + x) * 256 + k] = this.blockCliff2;
                        metadata[(y * 16 + x) * 256 + k] = this.byteCliff2;
                        continue;
                    }
                    blocks[(y * 16 + x) * 256 + k] = this.blockCliff1;
                    metadata[(y * 16 + x) * 256 + k] = this.byteCliff1;
                    continue;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = this.blockCliff1;
                metadata[(y * 16 + x) * 256 + k] = this.byteCliff1;
                continue;
            }
            if (depth == 0 && k > 61) {
                if (simplex.noise2((float)i / this.floMixWidth, (float)j / this.floMixWidth) + simplex.noise2((float)i / this.floSmallWidth, (float)j / this.floSmallWidth) * this.floSmallStrength > this.floMixHeight) {
                    blocks[(y * 16 + x) * 256 + k] = this.blockMixTop;
                    metadata[(y * 16 + x) * 256 + k] = this.byteMixTop;
                    mix = true;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                continue;
            }
            if (depth >= 4) continue;
            if (mix) {
                blocks[(y * 16 + x) * 256 + k] = this.blockMixFiller;
                metadata[(y * 16 + x) * 256 + k] = this.byteMixFiller;
                continue;
            }
            blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
            metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
        }
    }
}

