/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.surface.vanilla;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rtg.api.biome.BiomeConfig;
import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.surface.SurfaceBase;

public class SurfaceVanillaFrozenOcean
extends SurfaceBase {
    private Block mixBlock;
    private byte mixBlockMeta;
    private float width;
    private float height;
    private float mixCheck;
    private final int sandMetadata = 0;

    public SurfaceVanillaFrozenOcean(BiomeConfig config, Block top, Block filler, Block mix, float mixWidth, float mixHeight) {
        super(config, top, (byte)0, filler, (byte)0);
        this.mixBlock = this.getConfigBlock(config, "surfaceMixBlock", mix);
        this.mixBlockMeta = this.getConfigBlockMeta(config, "surfaceMixBlockMeta", (byte)0);
        this.width = mixWidth;
        this.height = mixHeight;
    }

    @Override
    public void paintTerrain(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, OpenSimplexNoise simplex, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            if (++depth == 0 && k > 0 && k < 63) {
                this.mixCheck = simplex.noise2((float)i / this.width, (float)j / this.width);
                if (this.mixCheck > this.height) {
                    blocks[(y * 16 + x) * 256 + k] = this.mixBlock;
                    metadata[(y * 16 + x) * 256 + k] = this.mixBlockMeta;
                    continue;
                }
                blocks[(y * 16 + x) * 256 + k] = this.topBlock;
                metadata[(y * 16 + x) * 256 + k] = this.topBlockMeta;
                continue;
            }
            if (depth < 4 && k < 63) {
                blocks[(y * 16 + x) * 256 + k] = this.fillerBlock;
                metadata[(y * 16 + x) * 256 + k] = this.fillerBlockMeta;
                continue;
            }
            if (depth != 0 || k >= 69) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150354_m;
            metadata[(y * 16 + x) * 256 + k] = 0;
        }
    }
}

