/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.gen.terrain.highlands;

import rtg.util.CellNoise;
import rtg.util.OpenSimplexNoise;
import rtg.world.gen.terrain.TerrainBase;

public class TerrainHLTallPineForest
extends TerrainBase {
    public static float hillStrength = 60.0f;
    public static float hillWidth = 100.0f;
    public static float hillFloor = 20.0f;

    @Override
    public float generateNoise(OpenSimplexNoise simplex, CellNoise cell, int x, int y, float border, float river) {
        float b = 12.0f + simplex.noise2((float)x / 300.0f, (float)y / 300.0f) * 6.0f;
        float h = cell.noise((double)x / 200.0, (double)y / 200.0, 1.0) * b * river;
        h = (h *= h * 1.5f) > 155.0f ? 155.0f : h;
        float hill = simplex.noise2((float)x / hillWidth, (float)y / hillWidth) * hillStrength * river;
        hill = TerrainHLTallPineForest.above(hill, hillFloor);
        if (h > 2.0f) {
            float d = (h - 2.0f) / 2.0f > 8.0f ? 8.0f : (h - 2.0f) / 2.0f;
            h += simplex.noise2((float)x / 30.0f, (float)y / 30.0f) * d;
            if ((h += simplex.noise2((float)x / 50.0f, (float)y / 50.0f) * d * 0.5f) > 35.0f) {
                float d2 = (h - 35.0f) / 1.5f > 30.0f ? 30.0f : (h - 35.0f) / 1.5f;
                h += cell.noise((double)x / 25.0, (double)y / 25.0, 1.0) * d2;
            }
        }
        h += simplex.noise2((float)x / 18.0f, (float)y / 18.0f) * 3.0f;
        h += simplex.noise2((float)x / 8.0f, (float)y / 8.0f) * 2.0f;
        if (river < 1.0f) {
            float result = 45.0f + h + b * 2.0f + hill;
            return 62.0f + (result - 62.0f) * river;
        }
        return 45.0f + h + b * 2.0f + hill;
    }
}

