/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower;

import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.control.BlockPeripheral;
import com.eloraam.redpower.control.ContainerCPU;
import com.eloraam.redpower.control.ContainerDisplay;
import com.eloraam.redpower.control.GuiCPU;
import com.eloraam.redpower.control.GuiDisplay;
import com.eloraam.redpower.control.ItemBackplane;
import com.eloraam.redpower.control.ItemDisk;
import com.eloraam.redpower.control.MicroPlacementRibbon;
import com.eloraam.redpower.control.RenderBackplane;
import com.eloraam.redpower.control.RenderCPU;
import com.eloraam.redpower.control.RenderDiskDrive;
import com.eloraam.redpower.control.RenderDisplay;
import com.eloraam.redpower.control.RenderIOExpander;
import com.eloraam.redpower.control.RenderRibbon;
import com.eloraam.redpower.control.TileBackplane;
import com.eloraam.redpower.control.TileCPU;
import com.eloraam.redpower.control.TileDiskDrive;
import com.eloraam.redpower.control.TileDisplay;
import com.eloraam.redpower.control.TileIOExpander;
import com.eloraam.redpower.control.TileRAM;
import com.eloraam.redpower.control.TileRibbon;
import com.eloraam.redpower.core.BlockExtended;
import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CraftLib;
import com.eloraam.redpower.core.CreativeExtraTabs;
import com.eloraam.redpower.core.ItemExtended;
import com.eloraam.redpower.core.RenderLib;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="RedPowerControl", name="RedPower Control", version="{VERSION}", dependencies="required-after:RedPowerBase")
public class RedPowerControl
implements IGuiHandler {
    @Mod.Instance(value="RedPowerControl")
    public static RedPowerControl instance;
    public static BlockExtended blockBackplane;
    public static BlockExtended blockPeripheral;
    public static BlockExtended blockFlatPeripheral;
    public static ItemDisk itemDisk;
    public static IIcon ribbonTop;
    public static IIcon ribbonFace;
    @SideOnly(value=Side.CLIENT)
    public static IIcon backplaneTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon backplaneFace;
    @SideOnly(value=Side.CLIENT)
    public static IIcon backplaneSide;
    @SideOnly(value=Side.CLIENT)
    public static IIcon ram8kTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon ram8kFace;
    @SideOnly(value=Side.CLIENT)
    public static IIcon ram8kSide;
    @SideOnly(value=Side.CLIENT)
    public static IIcon peripheralBottom;
    @SideOnly(value=Side.CLIENT)
    public static IIcon peripheralTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon peripheralSide;
    @SideOnly(value=Side.CLIENT)
    public static IIcon peripheralBack;
    @SideOnly(value=Side.CLIENT)
    public static IIcon cpuFront;
    @SideOnly(value=Side.CLIENT)
    public static IIcon displayFront;
    @SideOnly(value=Side.CLIENT)
    public static IIcon diskDriveSide;
    @SideOnly(value=Side.CLIENT)
    public static IIcon diskDriveTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon diskDriveFront;
    @SideOnly(value=Side.CLIENT)
    public static IIcon diskDriveFrontFull;
    @SideOnly(value=Side.CLIENT)
    public static IIcon diskDriveFrontOn;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        RedPowerControl.setupBlocks();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.registerRenderers();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)instance);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private static void setupBlocks() {
        blockBackplane = new BlockMultipart(CoreLib.materialRedpower);
        GameRegistry.registerBlock((Block)blockBackplane, ItemBackplane.class, (String)"backplane");
        blockBackplane.func_149647_a(CreativeExtraTabs.tabMachine);
        blockBackplane.func_149711_c(1.0f);
        blockBackplane.setBlockName(0, "rpbackplane");
        blockBackplane.setBlockName(1, "rpram");
        blockPeripheral = new BlockPeripheral();
        GameRegistry.registerBlock((Block)blockPeripheral, ItemExtended.class, (String)"peripheral");
        blockPeripheral.func_149711_c(1.0f);
        blockPeripheral.setBlockName(0, "rpdisplay");
        blockPeripheral.setBlockName(1, "rpcpu");
        blockPeripheral.setBlockName(2, "rpdiskdrive");
        blockFlatPeripheral = new BlockMultipart(Material.field_151576_e);
        blockFlatPeripheral.func_149647_a(CreativeExtraTabs.tabMachine);
        GameRegistry.registerBlock((Block)blockFlatPeripheral, ItemExtended.class, (String)"peripheralFlat");
        blockFlatPeripheral.func_149711_c(1.0f);
        blockFlatPeripheral.setBlockName(0, "rpioexp");
        GameRegistry.registerTileEntity(TileBackplane.class, (String)"RPConBP");
        blockBackplane.addTileEntityMapping(0, TileBackplane::new);
        GameRegistry.registerTileEntity(TileRAM.class, (String)"RPConRAM");
        blockBackplane.addTileEntityMapping(1, TileRAM::new);
        GameRegistry.registerTileEntity(TileDisplay.class, (String)"RPConDisp");
        blockPeripheral.addTileEntityMapping(0, TileDisplay::new);
        GameRegistry.registerTileEntity(TileDiskDrive.class, (String)"RPConDDrv");
        blockPeripheral.addTileEntityMapping(2, TileDiskDrive::new);
        GameRegistry.registerTileEntity(TileCPU.class, (String)"RPConCPU");
        blockPeripheral.addTileEntityMapping(1, TileCPU::new);
        GameRegistry.registerTileEntity(TileIOExpander.class, (String)"RPConIOX");
        blockFlatPeripheral.addTileEntityMapping(0, TileIOExpander::new);
        GameRegistry.registerTileEntity(TileRibbon.class, (String)"RPConRibbon");
        RedPowerBase.blockMicro.addTileEntityMapping(12, TileRibbon::new);
        MicroPlacementRibbon imp = new MicroPlacementRibbon();
        RedPowerBase.blockMicro.registerPlacement(12, imp);
        itemDisk = new ItemDisk();
        itemDisk.func_77637_a(CreativeExtraTabs.tabMachine);
        CraftLib.addOreRecipe(new ItemStack((Item)itemDisk, 1), "WWW", "W W", "WIW", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('W'), "plankWood");
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)itemDisk, 1, 1), (Object[])new Object[]{new ItemStack((Item)itemDisk, 1, 0), Items.field_151137_ax});
        GameRegistry.registerItem((Item)itemDisk, (String)"diskette");
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)itemDisk, 1, 2), (Object[])new Object[]{new ItemStack((Item)itemDisk, 1, 1), Items.field_151137_ax});
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)itemDisk, 1, 1), 0, 1, 1));
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack((Item)itemDisk, 1, 2), 0, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        RenderLib.setRenderer(blockBackplane, 0, RenderBackplane::new);
        RenderLib.setRenderer(blockBackplane, 1, RenderBackplane::new);
        RenderLib.setRenderer(blockPeripheral, 0, RenderDisplay::new);
        RenderLib.setRenderer(blockPeripheral, 1, RenderCPU::new);
        RenderLib.setRenderer(blockPeripheral, 2, RenderDiskDrive::new);
        RenderLib.setRenderer(blockFlatPeripheral, 0, RenderIOExpander::new);
        RenderLib.setHighRenderer(RedPowerBase.blockMicro, 12, RenderRibbon::new);
        ClientRegistry.bindTileEntitySpecialRenderer(TileBackplane.class, (TileEntitySpecialRenderer)new RenderBackplane((Block)blockBackplane));
        ClientRegistry.bindTileEntitySpecialRenderer(TileRibbon.class, (TileEntitySpecialRenderer)new RenderRibbon((Block)RedPowerBase.blockMicro));
        ClientRegistry.bindTileEntitySpecialRenderer(TileIOExpander.class, (TileEntitySpecialRenderer)new RenderIOExpander((Block)blockPeripheral));
        ClientRegistry.bindTileEntitySpecialRenderer(TileCPU.class, (TileEntitySpecialRenderer)new RenderCPU((Block)blockPeripheral));
        ClientRegistry.bindTileEntitySpecialRenderer(TileDiskDrive.class, (TileEntitySpecialRenderer)new RenderDiskDrive((Block)blockPeripheral));
        ClientRegistry.bindTileEntitySpecialRenderer(TileDisplay.class, (TileEntitySpecialRenderer)new RenderDisplay((Block)blockPeripheral));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        TextureMap map = evt.map;
        if (map.func_130086_a() == 0) {
            ribbonTop = map.func_94245_a("rpcontrol:ribbonTop");
            ribbonFace = map.func_94245_a("rpcontrol:ribbonFace");
            backplaneTop = map.func_94245_a("rpcontrol:backplaneTop");
            backplaneFace = map.func_94245_a("rpcontrol:backplaneFace");
            backplaneSide = map.func_94245_a("rpcontrol:backplaneSide");
            ram8kTop = map.func_94245_a("rpcontrol:ram8kTop");
            ram8kFace = map.func_94245_a("rpcontrol:ram8kFace");
            ram8kSide = map.func_94245_a("rpcontrol:ram8kSide");
            peripheralBottom = map.func_94245_a("rpcontrol:peripheralBottom");
            peripheralTop = map.func_94245_a("rpcontrol:peripheralTop");
            peripheralSide = map.func_94245_a("rpcontrol:peripheralSide");
            peripheralBack = map.func_94245_a("rpcontrol:peripheralBack");
            cpuFront = map.func_94245_a("rpcontrol:cpuFront");
            displayFront = map.func_94245_a("rpcontrol:displayFront");
            diskDriveSide = map.func_94245_a("rpcontrol:diskDriveSide");
            diskDriveTop = map.func_94245_a("rpcontrol:diskDriveTop");
            diskDriveFront = map.func_94245_a("rpcontrol:diskDriveFront");
            diskDriveFrontFull = map.func_94245_a("rpcontrol:diskDriveFrontFull");
            diskDriveFrontOn = map.func_94245_a("rpcontrol:diskDriveFrontOn");
        }
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 1: {
                return new GuiDisplay((IInventory)player.field_71071_by, CoreLib.getGuiTileEntity(world, x, y, z, TileDisplay.class));
            }
            case 2: {
                return new GuiCPU(player.field_71071_by, CoreLib.getGuiTileEntity(world, x, y, z, TileCPU.class));
            }
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        switch (id) {
            case 1: {
                return new ContainerDisplay((IInventory)player.field_71071_by, CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileDisplay.class));
            }
            case 2: {
                return new ContainerCPU((IInventory)player.field_71071_by, CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileCPU.class));
            }
        }
        return null;
    }
}

