/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower;

import com.eloraam.redpower.core.BaseConnectableAdaptor;
import com.eloraam.redpower.core.Config;
import com.eloraam.redpower.core.CoreEvents;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverRecipe;
import com.eloraam.redpower.core.IRedPowerConnectableAdaptor;
import com.eloraam.redpower.core.PacketHandler;
import com.eloraam.redpower.core.RenderHighlight;
import com.eloraam.redpower.core.RenderSimpleCovered;
import com.eloraam.redpower.core.TileCovered;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="RedPowerCore", name="RedPower Core", version="{VERSION}")
public class RedPowerCore {
    @Mod.Instance(value="RedPowerCore")
    public static RedPowerCore instance;
    public static PacketHandler packetHandler;
    public static int customBlockModel;
    public static int nullBlockModel;
    @SideOnly(value=Side.CLIENT)
    public static IIcon missing;
    public static List<IRedPowerConnectableAdaptor> redPowerAdaptors;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.loadConfig();
        CoreLib.readOres();
        MinecraftForge.EVENT_BUS.register((Object)new CoreEvents());
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
        redPowerAdaptors = new ArrayList<IRedPowerConnectableAdaptor>();
        redPowerAdaptors.add(new BaseConnectableAdaptor());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        packetHandler.init();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.setupRenderers();
        }
        CraftingManager.func_77594_a().func_77592_b().add(new CoverRecipe());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.saveConfig();
    }

    public static File getSaveDir(World world) {
        return DimensionManager.getCurrentSaveRootDirectory();
    }

    public static void sendPacketToServer(IMessage msg) {
        packetHandler.sendToServer(msg);
    }

    public static void sendPacketToCrafting(ICrafting icr, IMessage msg) {
        if (icr instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)icr;
            packetHandler.sendTo(msg, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupRenderers() {
        customBlockModel = RenderingRegistry.getNextAvailableRenderId();
        nullBlockModel = RenderingRegistry.getNextAvailableRenderId();
        MinecraftForge.EVENT_BUS.register((Object)new RenderHighlight());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCovered.class, (TileEntitySpecialRenderer)new RenderSimpleCovered());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        TextureMap map = evt.map;
        if (map.func_130086_a() == 0) {
            missing = map.func_94245_a("rpcore:missing");
        }
    }

    static {
        packetHandler = new PacketHandler();
        customBlockModel = -1;
        nullBlockModel = -1;
        redPowerAdaptors = new ArrayList<IRedPowerConnectableAdaptor>();
    }
}

