/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower;

import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.RenderLib;
import com.eloraam.redpower.lighting.BlockLamp;
import com.eloraam.redpower.lighting.BlockShapedLamp;
import com.eloraam.redpower.lighting.ItemLamp;
import com.eloraam.redpower.lighting.RenderLamp;
import com.eloraam.redpower.lighting.RenderShapedLamp;
import com.eloraam.redpower.lighting.TileLamp;
import com.eloraam.redpower.lighting.TileShapedLamp;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="RedPowerLighting", name="RedPower Lighting", version="{VERSION}", dependencies="required-after:RedPowerBase")
public class RedPowerLighting {
    @Mod.Instance(value="RedPowerLighting")
    public static RedPowerLighting instance;
    public static BlockLamp blockLamp;
    public static BlockShapedLamp blockShapedLamp;
    public static CreativeTabs tabLamp;
    public static IIcon[] lampOff;
    public static IIcon[] lampOn;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        RedPowerLighting.setupLighting();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.registerRenderers();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static void setupLighting() {
        String nm;
        int color;
        blockLamp = new BlockLamp();
        blockLamp.func_149663_c("rplamp");
        GameRegistry.registerBlock((Block)blockLamp, ItemLamp.class, (String)"lampo");
        GameRegistry.registerTileEntity(TileLamp.class, (String)"RPLamp");
        blockLamp.addTileEntityMapping(0, TileLamp::new);
        for (color = 0; color < 16; ++color) {
            nm = "rplamp." + CoreLib.rawColorNames[color];
            blockLamp.setBlockName(color, nm);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLamp, 1, color), (Object[])new Object[]{"GLG", "GLG", "GRG", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('L'), new ItemStack((Item)RedPowerBase.itemLumar, 1, color), Character.valueOf('R'), Items.field_151137_ax});
        }
        for (color = 0; color < 16; ++color) {
            nm = "rpilamp." + CoreLib.rawColorNames[color];
            blockLamp.setBlockName(color + 16, nm);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLamp, 1, 16 + color), (Object[])new Object[]{"GLG", "GLG", "GRG", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('L'), new ItemStack((Item)RedPowerBase.itemLumar, 1, color), Character.valueOf('R'), Blocks.field_150429_aA});
        }
        blockShapedLamp = new BlockShapedLamp();
        GameRegistry.registerBlock((Block)blockShapedLamp, ItemLamp.class, (String)"shlamp");
        GameRegistry.registerTileEntity(TileShapedLamp.class, (String)"RPShLamp");
        blockShapedLamp.addTileEntityMapping(0, TileShapedLamp::new);
        for (color = 0; color < 16; ++color) {
            nm = "rpshlamp." + CoreLib.rawColorNames[color];
            blockShapedLamp.setBlockName(color, nm);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockShapedLamp, 1, color), (Object[])new Object[]{"GLG", "GLG", "SRS", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('L'), new ItemStack((Item)RedPowerBase.itemLumar, 1, color), Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('S'), Blocks.field_150333_U});
        }
        for (color = 0; color < 16; ++color) {
            nm = "rpishlamp." + CoreLib.rawColorNames[color];
            blockShapedLamp.setBlockName(color + 16, nm);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockShapedLamp, 1, 16 + color), (Object[])new Object[]{"GLG", "GLG", "SRS", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('L'), new ItemStack((Item)RedPowerBase.itemLumar, 1, color), Character.valueOf('R'), Blocks.field_150429_aA, Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U, 1, 0)});
        }
        for (color = 0; color < 16; ++color) {
            nm = "rpshlamp2." + CoreLib.rawColorNames[color];
            blockShapedLamp.setBlockName(color + 32, nm);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockShapedLamp, 1, 32 + color), (Object[])new Object[]{"ILI", "GLG", "SRS", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('L'), new ItemStack((Item)RedPowerBase.itemLumar, 1, color), Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('I'), Blocks.field_150411_aY, Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U, 1, 0)});
        }
        for (color = 0; color < 16; ++color) {
            nm = "rpishlamp2." + CoreLib.rawColorNames[color];
            blockShapedLamp.setBlockName(color + 48, nm);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockShapedLamp, 1, 48 + color), (Object[])new Object[]{"ILI", "GLG", "SRS", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('L'), new ItemStack((Item)RedPowerBase.itemLumar, 1, color), Character.valueOf('R'), Blocks.field_150429_aA, Character.valueOf('I'), Blocks.field_150411_aY, Character.valueOf('S'), Blocks.field_150333_U});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        RenderLib.setDefaultRenderer(blockLamp, 10, RenderLamp::new);
        RenderLib.setDefaultRenderer(blockShapedLamp, 10, RenderShapedLamp::new);
        ClientRegistry.bindTileEntitySpecialRenderer(TileLamp.class, (TileEntitySpecialRenderer)new RenderLamp(blockLamp));
        ClientRegistry.bindTileEntitySpecialRenderer(TileShapedLamp.class, (TileEntitySpecialRenderer)new RenderShapedLamp(blockShapedLamp));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        TextureMap map = evt.map;
        if (map.func_130086_a() == 0) {
            if (lampOff == null) {
                lampOff = new IIcon[16];
            }
            if (lampOn == null) {
                lampOn = new IIcon[16];
            }
            for (int i = 0; i < 16; ++i) {
                RedPowerLighting.lampOff[i] = map.func_94245_a("rplighting:lampOff/" + i);
                RedPowerLighting.lampOn[i] = map.func_94245_a("rplighting:lampOn/" + i);
            }
        }
    }

    static {
        tabLamp = new CreativeTabs(CreativeTabs.getNextID(), "RPLights"){

            public ItemStack func_151244_d() {
                return new ItemStack((Block)blockLamp, 1, 16);
            }

            public Item func_78016_d() {
                return null;
            }
        };
    }
}

