/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower;

import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.core.Config;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.ItemParts;
import com.eloraam.redpower.core.RenderLib;
import com.eloraam.redpower.logic.BlockLogic;
import com.eloraam.redpower.logic.ContainerCounter;
import com.eloraam.redpower.logic.ContainerTimer;
import com.eloraam.redpower.logic.GuiCounter;
import com.eloraam.redpower.logic.GuiTimer;
import com.eloraam.redpower.logic.ItemLogic;
import com.eloraam.redpower.logic.RenderLogicAdv;
import com.eloraam.redpower.logic.RenderLogicArray;
import com.eloraam.redpower.logic.RenderLogicPointer;
import com.eloraam.redpower.logic.RenderLogicSimple;
import com.eloraam.redpower.logic.RenderLogicStorage;
import com.eloraam.redpower.logic.TileLogicAdv;
import com.eloraam.redpower.logic.TileLogicArray;
import com.eloraam.redpower.logic.TileLogicPointer;
import com.eloraam.redpower.logic.TileLogicSimple;
import com.eloraam.redpower.logic.TileLogicStorage;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="RedPowerLogic", name="RedPower Logic", version="{VERSION}", dependencies="required-after:RedPowerBase")
public class RedPowerLogic
implements IGuiHandler {
    @Mod.Instance(value="RedPowerLogic")
    public static RedPowerLogic instance;
    public static BlockLogic blockLogic;
    public static ItemParts itemParts;
    public static ItemStack itemAnode;
    public static ItemStack itemCathode;
    public static ItemStack itemWire;
    public static ItemStack itemWafer;
    public static ItemStack itemPointer;
    public static ItemStack itemPlate;
    public static ItemStack itemWaferRedwire;
    public static ItemStack itemChip;
    public static ItemStack itemTaintedChip;
    public static ItemStack itemWaferBundle;
    public static boolean soundsEnabled;
    @SideOnly(value=Side.CLIENT)
    public static IIcon torch;
    @SideOnly(value=Side.CLIENT)
    public static IIcon torchOn;
    @SideOnly(value=Side.CLIENT)
    public static IIcon lever;
    @SideOnly(value=Side.CLIENT)
    public static IIcon cobblestone;
    public static IIcon[] logicOne;
    public static IIcon[] logicTwo;
    public static IIcon[] logicSensor;

    private static void setupLogic() {
        GameRegistry.registerTileEntity(TileLogicSimple.class, (String)"RPLgSmp");
        GameRegistry.registerTileEntity(TileLogicArray.class, (String)"RPLgAr");
        GameRegistry.registerTileEntity(TileLogicStorage.class, (String)"RPLgStor");
        GameRegistry.registerTileEntity(TileLogicAdv.class, (String)"RPLgAdv");
        GameRegistry.registerTileEntity(TileLogicPointer.class, (String)"RPLgPtr");
        itemParts = new ItemParts();
        itemParts.addItem(0, "rplogic:wafer", "item.irwafer");
        itemParts.addItem(1, "rplogic:wire", "item.irwire");
        itemParts.addItem(2, "rplogic:anode", "item.iranode");
        itemParts.addItem(3, "rplogic:cathode", "item.ircathode");
        itemParts.addItem(4, "rplogic:pointer", "item.irpointer");
        itemParts.addItem(5, "rplogic:redWire", "item.irredwire");
        itemParts.addItem(6, "rplogic:plate", "item.irplate");
        itemParts.addItem(7, "rplogic:chip", "item.irchip");
        itemParts.addItem(8, "rplogic:tchip", "item.irtchip");
        itemParts.addItem(9, "rplogic:bundle", "item.irbundle");
        GameRegistry.registerItem((Item)itemParts, (String)"parts");
        itemWafer = new ItemStack((Item)itemParts, 1, 0);
        itemWire = new ItemStack((Item)itemParts, 1, 1);
        itemAnode = new ItemStack((Item)itemParts, 1, 2);
        itemCathode = new ItemStack((Item)itemParts, 1, 3);
        itemPointer = new ItemStack((Item)itemParts, 1, 4);
        itemWaferRedwire = new ItemStack((Item)itemParts, 1, 5);
        itemPlate = new ItemStack((Item)itemParts, 1, 6);
        itemChip = new ItemStack((Item)itemParts, 1, 7);
        itemTaintedChip = new ItemStack((Item)itemParts, 1, 8);
        itemWaferBundle = new ItemStack((Item)itemParts, 1, 9);
        FurnaceRecipes.func_77602_a().func_151393_a(Blocks.field_150348_b, new ItemStack((Item)itemParts, 2, 0), 0.1f);
        GameRegistry.addRecipe((ItemStack)itemWire, (Object[])new Object[]{"R", "B", Character.valueOf('B'), itemWafer, Character.valueOf('R'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)itemParts, 3, 2), (Object[])new Object[]{" R ", "RRR", "BBB", Character.valueOf('B'), itemWafer, Character.valueOf('R'), Items.field_151137_ax});
        GameRegistry.addRecipe((ItemStack)itemCathode, (Object[])new Object[]{"T", "B", Character.valueOf('B'), itemWafer, Character.valueOf('T'), Blocks.field_150429_aA});
        GameRegistry.addRecipe((ItemStack)itemPointer, (Object[])new Object[]{"S", "T", "B", Character.valueOf('B'), itemWafer, Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('T'), Blocks.field_150429_aA});
        GameRegistry.addRecipe((ItemStack)itemWaferRedwire, (Object[])new Object[]{"W", "B", Character.valueOf('B'), itemWafer, Character.valueOf('W'), new ItemStack((Block)RedPowerBase.blockMicro, 1, 256)});
        GameRegistry.addRecipe((ItemStack)itemPlate, (Object[])new Object[]{" B ", "SRS", "BCB", Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('R'), itemChip, Character.valueOf('S'), Items.field_151055_y});
        GameRegistry.addRecipe((ItemStack)itemWaferBundle, (Object[])new Object[]{"W", "B", Character.valueOf('B'), itemWafer, Character.valueOf('W'), new ItemStack((Block)RedPowerBase.blockMicro, 1, 768)});
        blockLogic = new BlockLogic();
        GameRegistry.registerBlock((Block)blockLogic, ItemLogic.class, (String)"logic");
        blockLogic.addTileEntityMapping(0, TileLogicPointer::new);
        blockLogic.addTileEntityMapping(1, TileLogicSimple::new);
        blockLogic.addTileEntityMapping(2, TileLogicArray::new);
        blockLogic.addTileEntityMapping(3, TileLogicStorage::new);
        blockLogic.addTileEntityMapping(4, TileLogicAdv::new);
        blockLogic.setBlockName(0, "irtimer");
        blockLogic.setBlockName(1, "irseq");
        blockLogic.setBlockName(2, "irstate");
        blockLogic.setBlockName(256, "irlatch");
        blockLogic.setBlockName(257, "irnor");
        blockLogic.setBlockName(258, "iror");
        blockLogic.setBlockName(259, "irnand");
        blockLogic.setBlockName(260, "irand");
        blockLogic.setBlockName(261, "irxnor");
        blockLogic.setBlockName(262, "irxor");
        blockLogic.setBlockName(263, "irpulse");
        blockLogic.setBlockName(264, "irtoggle");
        blockLogic.setBlockName(265, "irnot");
        blockLogic.setBlockName(266, "irbuf");
        blockLogic.setBlockName(267, "irmux");
        blockLogic.setBlockName(268, "irrepeater");
        blockLogic.setBlockName(269, "irsync");
        blockLogic.setBlockName(270, "irrand");
        blockLogic.setBlockName(271, "irdlatch");
        blockLogic.setBlockName(272, "rplightsensor");
        blockLogic.setBlockName(512, "rpanc");
        blockLogic.setBlockName(513, "rpainv");
        blockLogic.setBlockName(514, "rpaninv");
        blockLogic.setBlockName(768, "ircounter");
        blockLogic.setBlockName(1024, "irbusxcvr");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 0), (Object[])new Object[]{"BWB", "WPW", "ACA", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode, Character.valueOf('P'), itemPointer});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 1), (Object[])new Object[]{"BCB", "CPC", "BCB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode, Character.valueOf('P'), itemPointer});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 2), (Object[])new Object[]{"BAC", "WSP", "BWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode, Character.valueOf('P'), itemPointer, Character.valueOf('S'), itemChip});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 256), (Object[])new Object[]{"WWA", "CBC", "AWW", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 257), (Object[])new Object[]{"BAB", "WCW", "BWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 258), (Object[])new Object[]{"BCB", "WCW", "BWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 259), (Object[])new Object[]{"AAA", "CCC", "BWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 260), (Object[])new Object[]{"ACA", "CCC", "BWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 261), (Object[])new Object[]{"ACA", "CAC", "WCW", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 262), (Object[])new Object[]{"AWA", "CAC", "WCW", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 263), (Object[])new Object[]{"ACA", "CAC", "WWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 264), (Object[])new Object[]{"BCB", "WLW", "BCB", Character.valueOf('L'), Blocks.field_150442_at, Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 265), (Object[])new Object[]{"BAB", "ACA", "BWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 266), (Object[])new Object[]{"ACA", "WCW", "BWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 267), (Object[])new Object[]{"ACA", "CBC", "ACW", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 268), (Object[])new Object[]{"BCW", "BAW", "BWC", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('A'), itemAnode, Character.valueOf('C'), itemCathode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 269), (Object[])new Object[]{"WCW", "SAS", "WWW", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('A'), itemAnode, Character.valueOf('C'), itemCathode, Character.valueOf('S'), itemChip});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 270), (Object[])new Object[]{"BSB", "WWW", "SWS", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('S'), itemTaintedChip});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 271), (Object[])new Object[]{"ACW", "CCC", "CWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('A'), itemAnode});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 768), (Object[])new Object[]{"BWB", "CPC", "BWB", Character.valueOf('W'), itemWire, Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('P'), itemPointer});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 512), (Object[])new Object[]{"BRB", "RRR", "BRB", Character.valueOf('B'), itemWafer, Character.valueOf('R'), itemWaferRedwire});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 513), (Object[])new Object[]{"BRB", "RPR", "BRB", Character.valueOf('B'), itemWafer, Character.valueOf('R'), itemWaferRedwire, Character.valueOf('P'), itemPlate});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockLogic, 1, 514), (Object[])new Object[]{"BRB", "RPR", "BRC", Character.valueOf('B'), itemWafer, Character.valueOf('C'), itemCathode, Character.valueOf('R'), itemWaferRedwire, Character.valueOf('P'), itemPlate});
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        soundsEnabled = Config.getInt("settings.logic.enableSounds", 1) > 0;
        RedPowerLogic.setupLogic();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.registerRenderers();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)instance);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int X, int Y, int Z) {
        switch (ID) {
            case 1: {
                return new GuiCounter(player.field_71071_by, CoreLib.getGuiTileEntity(world, X, Y, Z, TileLogicStorage.class));
            }
            case 2: {
                return new GuiTimer(player.field_71071_by, CoreLib.getGuiTileEntity(world, X, Y, Z, TileLogicPointer.class));
            }
        }
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int X, int Y, int Z) {
        switch (ID) {
            case 1: {
                return new ContainerCounter((IInventory)player.field_71071_by, CoreLib.getTileEntity((IBlockAccess)world, X, Y, Z, TileLogicStorage.class));
            }
            case 2: {
                return new ContainerTimer((IInventory)player.field_71071_by, CoreLib.getTileEntity((IBlockAccess)world, X, Y, Z, TileLogicPointer.class));
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        RenderLib.setHighRenderer(blockLogic, 0, RenderLogicPointer::new);
        RenderLib.setHighRenderer(blockLogic, 1, RenderLogicSimple::new);
        RenderLib.setHighRenderer(blockLogic, 2, RenderLogicArray::new);
        RenderLib.setHighRenderer(blockLogic, 3, RenderLogicStorage::new);
        RenderLib.setHighRenderer(blockLogic, 4, RenderLogicAdv::new);
        ClientRegistry.bindTileEntitySpecialRenderer(TileLogicAdv.class, (TileEntitySpecialRenderer)new RenderLogicAdv((Block)blockLogic));
        ClientRegistry.bindTileEntitySpecialRenderer(TileLogicSimple.class, (TileEntitySpecialRenderer)new RenderLogicSimple((Block)blockLogic));
        ClientRegistry.bindTileEntitySpecialRenderer(TileLogicArray.class, (TileEntitySpecialRenderer)new RenderLogicArray((Block)blockLogic));
        ClientRegistry.bindTileEntitySpecialRenderer(TileLogicStorage.class, (TileEntitySpecialRenderer)new RenderLogicStorage((Block)blockLogic));
        ClientRegistry.bindTileEntitySpecialRenderer(TileLogicPointer.class, (TileEntitySpecialRenderer)new RenderLogicPointer((Block)blockLogic));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        TextureMap map = evt.map;
        if (map.func_130086_a() == 0) {
            int i;
            for (i = 0; i < 232; ++i) {
                RedPowerLogic.logicOne[i] = map.func_94245_a("rplogic:logic1/" + i);
            }
            for (i = 0; i < 256; ++i) {
                RedPowerLogic.logicTwo[i] = map.func_94245_a("rplogic:logic2/" + i);
            }
            for (i = 0; i < 23; ++i) {
                RedPowerLogic.logicSensor[i] = map.func_94245_a("rplogic:sensors/" + i);
            }
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post evt) {
        TextureMap map = evt.map;
        if (map.func_130086_a() == 0) {
            torch = map.func_110572_b("redstone_torch_off");
            torchOn = map.func_110572_b("redstone_torch_on");
            lever = map.func_110572_b("lever");
            cobblestone = map.func_110572_b("cobblestone");
        }
    }

    static {
        logicOne = new IIcon[232];
        logicTwo = new IIcon[256];
        logicSensor = new IIcon[23];
    }
}

