/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower;

import codechicken.nei.ItemStackSet;
import codechicken.nei.SubsetWidget;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.base.ItemHandsaw;
import com.eloraam.redpower.nei.MicroRecipeHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Mod(modid="RedPowerNEIPlugin", name="RedPower NEI Plugin", version="1.4.3.1", dependencies="required-after:NotEnoughItems;after:RedPowerBase;after:RedPowerControl;after:RedPowerCore;after:RedPowerLighting;after:RedPowerLogic;after:RedPowerWiring;")
public class RedPowerNEIPlugin {
    @Mod.Instance(value="RedPowerNEIPlugin")
    public static RedPowerNEIPlugin instance;
    public static boolean wiring;
    public static boolean logic;
    public static boolean control;
    public static boolean lighting;
    public static boolean world;
    public static boolean machine;
    public static boolean base;
    public static boolean compat;
    static Block micro;
    private List<ItemRange> validMicroTypes = new ArrayList<ItemRange>();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            FMLLog.severe((String)"[RedPowerNEIPlugin] Server env detected, disabling...", (Object[])new Object[0]);
        } else if (Loader.isModLoaded((String)"NotEnoughItems")) {
            wiring = Loader.isModLoaded((String)"RedPowerWiring");
            logic = Loader.isModLoaded((String)"RedPowerLogic");
            control = Loader.isModLoaded((String)"RedPowerControl");
            lighting = Loader.isModLoaded((String)"RedPowerLighting");
            world = Loader.isModLoaded((String)"RedPowerWorld");
            machine = Loader.isModLoaded((String)"RedPowerMachine");
            base = Loader.isModLoaded((String)"RedPowerBase");
            compat = Loader.isModLoaded((String)"RedPowerCompat");
            if (base) {
                this.loadCoverSubSets();
                this.loadSaws();
                API.hideItem((ItemStack)new ItemStack((Block)RedPowerBase.blockMultiblock));
                API.registerRecipeHandler((ICraftingHandler)new MicroRecipeHandler());
                API.registerUsageHandler((IUsageHandler)new MicroRecipeHandler());
            }
        } else {
            FMLCommonHandler.instance().getFMLLogger().warn("[RedPowerNEIPlugin] No NEI detected, disabling...");
        }
    }

    private void loadSaws() {
        ArrayList<ItemHandsaw> saws = new ArrayList<ItemHandsaw>();
        for (Object item : Item.field_150901_e) {
            if (!(item instanceof ItemHandsaw)) continue;
            saws.add((ItemHandsaw)((Object)item));
        }
        MicroRecipeHandler.saws = new ItemHandsaw[saws.size()];
        for (int i = 0; i < saws.size(); ++i) {
            MicroRecipeHandler.saws[i] = (ItemHandsaw)((Object)saws.get(i));
        }
        ItemStackSet set = new ItemStackSet().with((Item[])MicroRecipeHandler.saws);
        API.addSubset((SubsetWidget.SubsetTag)new SubsetWidget.SubsetTag("RedPower.Tools.Saws", (ItemFilter)set));
        API.addSubset((SubsetWidget.SubsetTag)new SubsetWidget.SubsetTag("Items.Tools.Saws", (ItemFilter)set));
    }

    private void loadCoverSubSets() {
        if (base) {
            micro = RedPowerBase.blockMicro;
            int startRange = -1;
            for (int i = 0; i < 256; ++i) {
                ItemStack stack = new ItemStack(micro, 1, i);
                String name = GuiContainerManager.itemDisplayNameShort((ItemStack)stack);
                if (!name.endsWith("Unnamed") && !name.endsWith("null")) {
                    if (startRange != -1) continue;
                    startRange = i;
                    continue;
                }
                if (startRange == -1) continue;
                this.validMicroTypes.add(new ItemRange(micro, startRange, i - 1));
                startRange = -1;
            }
            this.registerMicroSet("MicroBlocks.Cover", 0);
            this.registerMicroSet("MicroBlocks.Panel", 16);
            this.registerMicroSet("MicroBlocks.Slab", 17);
            this.registerMicroSet("MicroBlocks.Hollow Cover", 24);
            this.registerMicroSet("MicroBlocks.Hollow Panel", 25);
            this.registerMicroSet("MicroBlocks.Hollow Slab", 26);
            this.registerMicroSet("MicroBlocks.Cover Corner", 18);
            this.registerMicroSet("MicroBlocks.Panel Corner", 19);
            this.registerMicroSet("MicroBlocks.Slab Corner", 20);
            this.registerMicroSet("MicroBlocks.Cover Strip", 21);
            this.registerMicroSet("MicroBlocks.Panel Strip", 22);
            this.registerMicroSet("MicroBlocks.Slab Strip", 23);
            this.registerMicroSet("MicroBlocks.Triple Cover", 27);
            this.registerMicroSet("MicroBlocks.Cover Slab", 28);
            this.registerMicroSet("MicroBlocks.Triple Panel", 29);
            this.registerMicroSet("MicroBlocks.Anticover", 30);
            this.registerMicroSet("MicroBlocks.Hollow Triple Cover", 31);
            this.registerMicroSet("MicroBlocks.Hollow Cover Slab", 32);
            this.registerMicroSet("MicroBlocks.Hollow Triple Panel", 33);
            this.registerMicroSet("MicroBlocks.Hollow Anticover", 34);
            this.registerMicroSet("MicroBlocks.Triple Cover Corner", 35);
            this.registerMicroSet("MicroBlocks.Cover Slab Corner", 36);
            this.registerMicroSet("MicroBlocks.Triple Panel Corner", 37);
            this.registerMicroSet("MicroBlocks.Anticover Corner", 38);
            this.registerMicroSet("MicroBlocks.Triple Cover Strip", 39);
            this.registerMicroSet("MicroBlocks.Cover Slab Strip", 40);
            this.registerMicroSet("MicroBlocks.Triple Panel Strip", 41);
            this.registerMicroSet("MicroBlocks.Anticover Strip", 42);
            this.registerMicroSet("MicroBlocks.Post", 43);
            this.registerMicroSet("MicroBlocks.Pillar", 44);
            this.registerMicroSet("MicroBlocks.Column", 45);
            if (wiring) {
                this.registerMicroSet("Wiring.Jacketed Wire", 64);
                this.registerMicroSet("Wiring.Jacketed Cable", 65);
                this.registerMicroSet("Bluetricity.Jacketed Bluewire", 66);
            }
        }
    }

    private void registerMicroSet(String RPName, int microID) {
        ItemStackSet set = new ItemStackSet();
        for (ItemRange type : this.validMicroTypes) {
            set.with((ItemStack[])IntStream.rangeClosed(type.start, type.end).mapToObj(i -> new ItemStack(type.bl, 1, i + microID * 256)).toArray(ItemStack[]::new));
        }
        API.addSubset((String)("RedPower." + RPName), (ItemFilter)set);
    }

    private class ItemRange {
        private final Block bl;
        private final int start;
        private final int end;

        public ItemRange(Block bl, int start, int end) {
            this.bl = bl;
            this.start = start;
            this.end = end;
        }
    }
}

