/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower;

import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.CraftLib;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.RenderLib;
import com.eloraam.redpower.core.TileCovered;
import com.eloraam.redpower.wiring.MicroPlacementJacket;
import com.eloraam.redpower.wiring.MicroPlacementWire;
import com.eloraam.redpower.wiring.RenderRedwire;
import com.eloraam.redpower.wiring.TileCable;
import com.eloraam.redpower.wiring.TileInsulatedWire;
import com.eloraam.redpower.wiring.TileRedwire;
import com.eloraam.redpower.wiring.TileWiring;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="RedPowerWiring", name="RedPower Wiring", version="{VERSION}", dependencies="required-after:RedPowerBase")
public class RedPowerWiring {
    @Mod.Instance(value="RedPowerWiring")
    public static RedPowerWiring instance;
    @SideOnly(value=Side.CLIENT)
    public static IIcon redwireTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon redwireFace;
    @SideOnly(value=Side.CLIENT)
    public static IIcon bundledTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon bundledFace;
    @SideOnly(value=Side.CLIENT)
    public static IIcon powerTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon powerFace;
    @SideOnly(value=Side.CLIENT)
    public static IIcon highPowerTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon highPowerFace;
    @SideOnly(value=Side.CLIENT)
    public static IIcon jumboSides;
    @SideOnly(value=Side.CLIENT)
    public static IIcon jumboTop;
    @SideOnly(value=Side.CLIENT)
    public static IIcon jumboCent;
    @SideOnly(value=Side.CLIENT)
    public static IIcon jumboCentSide;
    @SideOnly(value=Side.CLIENT)
    public static IIcon jumboEnd;
    @SideOnly(value=Side.CLIENT)
    public static IIcon jumboCorners;
    @SideOnly(value=Side.CLIENT)
    public static IIcon redwireCableOff;
    @SideOnly(value=Side.CLIENT)
    public static IIcon redwireCableOn;
    @SideOnly(value=Side.CLIENT)
    public static IIcon bundledCable;
    public static IIcon[] insulatedTop;
    public static IIcon[] insulatedFaceOff;
    public static IIcon[] insulatedFaceOn;
    public static IIcon[] bundledColTop;
    public static IIcon[] bundledColFace;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        RedPowerWiring.initJacketRecipes();
        RedPowerWiring.setupWires();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.registerRenderers();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private static void initJacketRecipes() {
        CoverLib.addMaterialHandler(material -> {
            if (!CoverLib.isTransparent(material)) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)RedPowerBase.blockMicro, 1, 16384 + material), (Object[])new Object[]{"SSS", "SRS", "SSS", Character.valueOf('S'), new ItemStack((Block)RedPowerBase.blockMicro, 1, material), Character.valueOf('R'), new ItemStack((Block)RedPowerBase.blockMicro, 1, 256)});
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)RedPowerBase.blockMicro, 1, 16640 + material), (Object[])new Object[]{"SSS", "SCS", "SSS", Character.valueOf('S'), new ItemStack((Block)RedPowerBase.blockMicro, 1, material), Character.valueOf('C'), new ItemStack((Block)RedPowerBase.blockMicro, 1, 768)});
            }
        });
    }

    public static void setupWires() {
        int i;
        int j;
        GameRegistry.registerTileEntity(TileRedwire.class, (String)"Redwire");
        GameRegistry.registerTileEntity(TileInsulatedWire.class, (String)"InsRedwire");
        GameRegistry.registerTileEntity(TileCable.class, (String)"RedCable");
        GameRegistry.registerTileEntity(TileCovered.class, (String)"Covers");
        MicroPlacementWire wre = new MicroPlacementWire();
        RedPowerBase.blockMicro.registerPlacement(1, wre);
        RedPowerBase.blockMicro.registerPlacement(2, wre);
        RedPowerBase.blockMicro.registerPlacement(3, wre);
        RedPowerBase.blockMicro.registerPlacement(5, wre);
        MicroPlacementJacket jkt = new MicroPlacementJacket();
        RedPowerBase.blockMicro.registerPlacement(64, jkt);
        RedPowerBase.blockMicro.registerPlacement(65, jkt);
        RedPowerBase.blockMicro.addTileEntityMapping(1, TileRedwire::new);
        RedPowerBase.blockMicro.addTileEntityMapping(2, TileInsulatedWire::new);
        RedPowerBase.blockMicro.addTileEntityMapping(3, TileCable::new);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)RedPowerBase.blockMicro, 1, 1281), (Object[])new Object[]{new ItemStack((Block)RedPowerBase.blockMicro, 1, 1280), Blocks.field_150325_L});
        for (int color = 0; color < 16; ++color) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)RedPowerBase.blockMicro, 12, 512 + color), (Object[])new Object[]{"WRW", "WRW", "WRW", Character.valueOf('R'), new ItemStack((Block)RedPowerBase.blockMicro, 1, 256), Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, color)});
            for (j = 0; j < 16; ++j) {
                if (color == j) continue;
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)RedPowerBase.blockMicro, 1, 512 + color), (Object[])new Object[]{new ItemStack((Block)RedPowerBase.blockMicro, 1, 512 + j), new ItemStack(Items.field_151100_aR, 1, 15 - color)});
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)RedPowerBase.blockMicro, 1, 769 + color), (Object[])new Object[]{new ItemStack((Block)RedPowerBase.blockMicro, 1, 769 + j), new ItemStack(Items.field_151100_aR, 1, 15 - color)});
            }
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)RedPowerBase.blockMicro, 2, 768), (Object[])new Object[]{"SWS", "WWW", "SWS", Character.valueOf('W'), new ItemStack((Block)RedPowerBase.blockMicro, 1, 512 + color), Character.valueOf('S'), Items.field_151007_F});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)RedPowerBase.blockMicro, 1, 769 + color), (Object[])new Object[]{new ItemStack((Block)RedPowerBase.blockMicro, 1, 768), new ItemStack(Items.field_151100_aR, 1, 15 - color), Items.field_151121_aF});
        }
        for (i = 0; i < 16; ++i) {
            if (i == 11) continue;
            CraftLib.addShapelessOreRecipe(new ItemStack((Block)RedPowerBase.blockMicro, 1, 523), new ItemStack((Block)RedPowerBase.blockMicro, 1, 512 + i), "dyeBlue");
            CraftLib.addShapelessOreRecipe(new ItemStack((Block)RedPowerBase.blockMicro, 1, 780), new ItemStack((Block)RedPowerBase.blockMicro, 1, 769 + i), "dyeBlue");
        }
        CraftLib.addShapelessOreRecipe(new ItemStack((Block)RedPowerBase.blockMicro, 1, 780), new ItemStack((Block)RedPowerBase.blockMicro, 1, 768), "dyeBlue", Items.field_151121_aF);
        RedPowerLib.addCompatibleMapping(0, 1);
        for (i = 0; i < 16; ++i) {
            RedPowerLib.addCompatibleMapping(0, 2 + i);
            RedPowerLib.addCompatibleMapping(1, 2 + i);
            RedPowerLib.addCompatibleMapping(65, 2 + i);
            for (j = 0; j < 16; ++j) {
                RedPowerLib.addCompatibleMapping(19 + j, 2 + i);
            }
            RedPowerLib.addCompatibleMapping(18, 2 + i);
            RedPowerLib.addCompatibleMapping(18, 19 + i);
        }
        RedPowerLib.addCompatibleMapping(0, 65);
        RedPowerLib.addCompatibleMapping(1, 65);
        RedPowerLib.addCompatibleMapping(64, 65);
        RedPowerLib.addCompatibleMapping(64, 67);
        RedPowerLib.addCompatibleMapping(65, 67);
        RedPowerLib.addCompatibleMapping(66, 67);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        RenderLib.setDefaultRenderer(RedPowerBase.blockMicro, 8, RenderRedwire::new);
        ClientRegistry.bindTileEntitySpecialRenderer(TileWiring.class, (TileEntitySpecialRenderer)new RenderRedwire((Block)RedPowerBase.blockMicro));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        TextureMap map = evt.map;
        if (map.func_130086_a() == 0) {
            redwireTop = map.func_94245_a("rpwiring:redwireTop");
            redwireFace = map.func_94245_a("rpwiring:redwireFace");
            bundledTop = map.func_94245_a("rpwiring:bundledTop");
            bundledFace = map.func_94245_a("rpwiring:bundledFace");
            powerTop = map.func_94245_a("rpwiring:powerTop");
            powerFace = map.func_94245_a("rpwiring:powerFace");
            highPowerTop = map.func_94245_a("rpwiring:highPowerTop");
            highPowerFace = map.func_94245_a("rpwiring:highPowerFace");
            jumboSides = map.func_94245_a("rpwiring:jumboSides");
            jumboTop = map.func_94245_a("rpwiring:jumboTop");
            jumboCent = map.func_94245_a("rpwiring:jumboCent");
            jumboCentSide = map.func_94245_a("rpwiring:jumboCentSide");
            jumboEnd = map.func_94245_a("rpwiring:jumboEnd");
            jumboCorners = map.func_94245_a("rpwiring:jumboCorners");
            redwireCableOff = map.func_94245_a("rpwiring:redwireCableOff");
            redwireCableOn = map.func_94245_a("rpwiring:redwireCableOn");
            bundledCable = map.func_94245_a("rpwiring:bundledCable");
            for (int col = 0; col < 16; ++col) {
                RedPowerWiring.insulatedTop[col] = map.func_94245_a("rpwiring:insulatedTop/" + col);
                RedPowerWiring.insulatedFaceOff[col] = map.func_94245_a("rpwiring:insulatedFaceOff/" + col);
                RedPowerWiring.insulatedFaceOn[col] = map.func_94245_a("rpwiring:insulatedFaceOn/" + col);
                RedPowerWiring.bundledColTop[col] = map.func_94245_a("rpwiring:bundledColTop/" + col);
                RedPowerWiring.bundledColFace[col] = map.func_94245_a("rpwiring:bundledColFace/" + col);
            }
        }
    }

    static {
        insulatedTop = new IIcon[16];
        insulatedFaceOff = new IIcon[16];
        insulatedFaceOn = new IIcon[16];
        bundledColTop = new IIcon[16];
        bundledColFace = new IIcon[16];
    }
}

