/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.base;

import com.eloraam.redpower.RedPowerBase;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.CreativeExtraTabs;
import com.eloraam.redpower.core.ICoverable;
import com.eloraam.redpower.core.IMicroPlacement;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.WorldCoord;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ItemMicro
extends ItemBlock {
    private IMicroPlacement[] placers = new IMicroPlacement[256];

    public ItemMicro(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    private boolean useCover(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side) {
        MovingObjectPosition pos = CoreLib.retraceBlock(world, (EntityLivingBase)player, x, y, z);
        if (pos == null) {
            return false;
        }
        if (pos.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        if ((pos = CoverLib.getPlacement(world, pos, ist.func_77960_j())) == null) {
            return false;
        }
        Block oldBlock = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        if (world.func_147472_a(oldBlock, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, false, side, (Entity)player, ist)) {
            world.func_147465_d(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, (Block)RedPowerBase.blockMicro, 0, 3);
        }
        TileEntity te = world.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        Block newBlock = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        int newMeta = world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        if (!(te instanceof ICoverable)) {
            return false;
        }
        ICoverable icv = (ICoverable)te;
        PlayerInteractEvent event = new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, side, world);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            NBTTagCompound nbt = new NBTTagCompound();
            te.func_145841_b(nbt);
            BlockSnapshot snapshot = new BlockSnapshot(world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, newBlock, newMeta, nbt);
            BlockEvent.PlaceEvent plvt = new BlockEvent.PlaceEvent(snapshot, oldBlock, player);
            if (!MinecraftForge.EVENT_BUS.post((Event)plvt)) {
                if (icv.tryAddCover(pos.subHit, CoverLib.damageToCoverValue(ist.func_77960_j()))) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --ist.field_77994_a;
                    }
                    CoreLib.placeNoise(world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, CoverLib.getBlock(ist.func_77960_j() & 0xFF));
                    RedPowerLib.updateIndirectNeighbors(world, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, (Block)RedPowerBase.blockMicro);
                    world.func_147471_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack ist) {
        return true;
    }

    public boolean func_77648_a(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xp, float yp, float zp) {
        return player != null && !player.func_70093_af() && this.itemUseShared(ist, player, world, x, y, z, side);
    }

    public boolean onItemUseFirst(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side, float xp, float yp, float zp) {
        return !world.field_72995_K && player.func_70093_af() && this.itemUseShared(ist, player, world, x, y, z, side);
    }

    private boolean itemUseShared(ItemStack ist, EntityPlayer player, World world, int x, int y, int z, int side) {
        int hb = ist.func_77960_j();
        return (hb >>= 8) != 0 && (hb < 16 || hb > 45) ? this.placers[hb] != null && this.placers[hb].onPlaceMicro(ist, player, world, new WorldCoord(x, y, z), side) : this.useCover(ist, player, world, x, y, z, side);
    }

    private String getMicroName(int hb) {
        switch (hb) {
            case 0: {
                return "rpcover";
            }
            default: {
                return null;
            }
            case 16: {
                return "rppanel";
            }
            case 17: {
                return "rpslab";
            }
            case 18: {
                return "rpcovc";
            }
            case 19: {
                return "rppanc";
            }
            case 20: {
                return "rpslabc";
            }
            case 21: {
                return "rpcovs";
            }
            case 22: {
                return "rppans";
            }
            case 23: {
                return "rpslabs";
            }
            case 24: {
                return "rphcover";
            }
            case 25: {
                return "rphpanel";
            }
            case 26: {
                return "rphslab";
            }
            case 27: {
                return "rpcov3";
            }
            case 28: {
                return "rpcov5";
            }
            case 29: {
                return "rpcov6";
            }
            case 30: {
                return "rpcov7";
            }
            case 31: {
                return "rphcov3";
            }
            case 32: {
                return "rphcov5";
            }
            case 33: {
                return "rphcov6";
            }
            case 34: {
                return "rphcov7";
            }
            case 35: {
                return "rpcov3c";
            }
            case 36: {
                return "rpcov5c";
            }
            case 37: {
                return "rpcov6c";
            }
            case 38: {
                return "rpcov7c";
            }
            case 39: {
                return "rpcov3s";
            }
            case 40: {
                return "rpcov5s";
            }
            case 41: {
                return "rpcov6s";
            }
            case 42: {
                return "rpcov7s";
            }
            case 43: {
                return "rppole1";
            }
            case 44: {
                return "rppole2";
            }
            case 45: 
        }
        return "rppole3";
    }

    public String func_77667_c(ItemStack ist) {
        int hb = ist.func_77960_j();
        int lb = hb & 0xFF;
        String stub = this.getMicroName(hb >>= 8);
        if (stub != null) {
            String name = CoverLib.getName(lb);
            if (name == null) {
                throw new IndexOutOfBoundsException();
            }
            return "tile." + stub + "." + name;
        }
        if (this.placers[hb] == null) {
            throw new IndexOutOfBoundsException();
        }
        String name = this.placers[hb].getMicroName(hb, lb);
        if (name == null) {
            throw new IndexOutOfBoundsException();
        }
        return name;
    }

    public void registerPlacement(int md, IMicroPlacement imp) {
        this.placers[md] = imp;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        block7: {
            block6: {
                String stub;
                int i;
                if (tab == null || tab == CreativeExtraTabs.tabWires || tab == CreativeExtraTabs.tabMachine) break block6;
                if (tab != CreativeExtraTabs.tabMicros) break block7;
                for (i = 0; i < 255; ++i) {
                    stub = CoverLib.getName(i);
                    if (stub == null) continue;
                    list.add(new ItemStack((Block)RedPowerBase.blockMicro, 1, i));
                }
                for (i = 1; i < 255; ++i) {
                    stub = this.getMicroName(i);
                    if (stub == null) continue;
                    list.add(new ItemStack((Block)RedPowerBase.blockMicro, 1, i << 8));
                }
                for (i = 1; i < 255; ++i) {
                    stub = this.getMicroName(i);
                    if (stub == null) continue;
                    list.add(new ItemStack((Block)RedPowerBase.blockMicro, 1, i << 8 | 2));
                }
                for (i = 1; i < 255; ++i) {
                    stub = this.getMicroName(i);
                    if (stub == null) continue;
                    list.add(new ItemStack((Block)RedPowerBase.blockMicro, 1, i << 8 | 0x17));
                }
                for (i = 1; i < 255; ++i) {
                    stub = this.getMicroName(i);
                    if (stub == null) continue;
                    list.add(new ItemStack((Block)RedPowerBase.blockMicro, 1, i << 8 | 0x1A));
                }
                break block7;
            }
            for (int i = 0; i < 255; ++i) {
                if (this.placers[i] == null) continue;
                this.placers[i].addCreativeItems(i, tab, list);
            }
        }
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{CreativeExtraTabs.tabWires, CreativeExtraTabs.tabMicros, CreativeExtraTabs.tabMachine};
    }
}

