/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.control;

import com.eloraam.redpower.RedPowerCore;
import com.eloraam.redpower.control.TileDisplay;
import com.eloraam.redpower.core.IHandleGuiEvent;
import com.eloraam.redpower.core.PacketGuiEvent;
import java.io.ByteArrayOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ContainerDisplay
extends Container
implements IHandleGuiEvent {
    private TileDisplay tileDisplay;
    private byte[] screen = new byte[4000];
    private int cursx = 0;
    private int cursy = 0;
    private int cursmode = 0;

    private void decompress(byte[] compress, byte[] out) {
        int opos = 0;
        int i = 0;
        while (i < compress.length) {
            int ln;
            int cmd;
            if (opos >= out.length) {
                return;
            }
            if (((cmd = compress[i++] & 0xFF) & 0x80) == 0) {
                opos += cmd & 0x7F;
                continue;
            }
            if (cmd != 255) {
                ln = Math.min(Math.min(cmd & 0x7F, out.length - opos), compress.length - i);
                System.arraycopy(compress, i, out, opos, ln);
                opos += ln;
                i += ln;
                continue;
            }
            if (i + 2 > compress.length) {
                return;
            }
            ln = Math.min(compress[i] & 0xFF, out.length - opos);
            for (int j = 0; j < ln; ++j) {
                out[opos + j] = compress[i + 1];
            }
            opos += ln;
            i += 2;
        }
    }

    public ContainerDisplay(IInventory inv, TileDisplay td) {
        this.tileDisplay = td;
    }

    public ItemStack func_75144_a(int a, int b, int c, EntityPlayer player) {
        return !this.func_75145_c(player) ? null : super.func_75144_a(a, b, c, player);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileDisplay.isUseableByPlayer(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        return null;
    }

    private byte[] getDisplayRLE() {
        RLECompressor rle = new RLECompressor();
        for (int i = 0; i < 4000; ++i) {
            rle.addByte(this.tileDisplay.screen[i], this.screen[i] != this.tileDisplay.screen[i]);
            this.screen[i] = this.tileDisplay.screen[i];
        }
        rle.flush();
        return rle.getByteArray();
    }

    public void func_75142_b() {
        super.func_75142_b();
        byte[] drl = this.getDisplayRLE();
        for (ICrafting ic : this.field_75149_d) {
            if (this.tileDisplay.cursX != this.cursx) {
                ic.func_71112_a((Container)this, 0, this.tileDisplay.cursX);
            }
            if (this.tileDisplay.cursY != this.cursy) {
                ic.func_71112_a((Container)this, 1, this.tileDisplay.cursY);
            }
            if (this.tileDisplay.cursMode != this.cursmode) {
                ic.func_71112_a((Container)this, 2, this.tileDisplay.cursMode);
            }
            if (drl == null) continue;
            RedPowerCore.sendPacketToCrafting(ic, new PacketGuiEvent.GuiMessageEvent(2, this.field_75152_c, drl));
        }
        this.cursx = this.tileDisplay.cursX;
        this.cursy = this.tileDisplay.cursY;
        this.cursmode = this.tileDisplay.cursMode;
    }

    public void func_75137_b(int id, int value) {
        switch (id) {
            case 0: {
                this.tileDisplay.cursX = value;
                return;
            }
            case 1: {
                this.tileDisplay.cursY = value;
                return;
            }
            case 2: {
                this.tileDisplay.cursMode = value;
            }
        }
    }

    @Override
    public void handleGuiEvent(PacketGuiEvent.GuiMessageEvent message) {
        try {
            switch (message.eventId) {
                case 1: {
                    this.tileDisplay.pushKey(message.parameters[0]);
                    this.tileDisplay.updateBlock();
                    break;
                }
                case 2: {
                    this.decompress(message.parameters, this.tileDisplay.screen);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class RLECompressor {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        byte[] datbuf = new byte[256];
        byte srledat = 0;
        int rleoffs = 0;
        int srleoffs = 0;
        int datpos = 0;
        boolean changed = false;

        public void writeRLE() {
            this.bas.write((byte)this.rleoffs);
            this.datpos = 0;
            this.rleoffs = 0;
            this.srleoffs = 0;
        }

        public void writeSRLE() {
            this.bas.write(-1);
            this.bas.write((byte)this.srleoffs);
            this.bas.write(this.srledat);
            this.datpos = 0;
            this.rleoffs = 0;
            this.srleoffs = 0;
        }

        public void writeDat(int bytes) {
            if (bytes != 0) {
                this.bas.write((byte)(0x80 | bytes));
                this.bas.write(this.datbuf, 0, bytes);
                this.datpos -= bytes;
            }
        }

        public void addByte(byte b, boolean diff) {
            if (diff) {
                this.changed = true;
                if (this.rleoffs > 5 && this.rleoffs >= this.srleoffs) {
                    this.writeDat(this.datpos - this.rleoffs);
                    this.writeRLE();
                }
                this.rleoffs = 0;
            } else {
                ++this.rleoffs;
                if (this.rleoffs >= 127) {
                    ++this.datpos;
                    this.writeDat(this.datpos - this.rleoffs);
                    this.writeRLE();
                    return;
                }
            }
            if (this.srleoffs == 0) {
                this.srledat = b;
                this.srleoffs = 1;
            } else if (b == this.srledat) {
                ++this.srleoffs;
                if (this.srleoffs >= 127) {
                    ++this.datpos;
                    this.writeDat(this.datpos - this.srleoffs);
                    this.writeSRLE();
                    return;
                }
            } else {
                if (this.srleoffs > 5 && this.srleoffs >= this.rleoffs) {
                    this.writeDat(this.datpos - this.srleoffs);
                    this.writeSRLE();
                }
                this.srledat = b;
                this.srleoffs = 1;
            }
            this.datbuf[this.datpos] = b;
            ++this.datpos;
            int rem = Math.max(this.srleoffs, this.rleoffs);
            if (rem <= 5 && this.datpos >= 126) {
                this.writeDat(this.datpos);
                this.srleoffs = 0;
                this.rleoffs = 0;
            } else if (this.datpos - rem >= 126) {
                this.writeDat(this.datpos - rem);
            }
        }

        public void flush() {
            this.datpos -= this.rleoffs;
            this.srleoffs = Math.max(0, this.srleoffs - this.rleoffs);
            if (this.datpos != 0) {
                if (this.srleoffs > 5) {
                    this.writeDat(this.datpos - this.srleoffs);
                    this.writeSRLE();
                } else {
                    this.writeDat(this.datpos);
                }
            }
        }

        byte[] getByteArray() {
            return !this.changed ? null : this.bas.toByteArray();
        }
    }
}

