/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.control;

import com.eloraam.redpower.RedPowerControl;
import com.eloraam.redpower.control.ItemDisk;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.IFrameSupport;
import com.eloraam.redpower.core.IRedbusConnectable;
import com.eloraam.redpower.core.MachineLib;
import com.eloraam.redpower.core.TileExtended;
import com.eloraam.redpower.core.WorldCoord;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IBlockAccess;

public class TileDiskDrive
extends TileExtended
implements IRedbusConnectable,
IInventory,
IFrameSupport {
    public int Rotation = 0;
    public boolean hasDisk = false;
    public boolean Active = false;
    private ItemStack[] contents = new ItemStack[1];
    private int accessTime = 0;
    private byte[] databuf = new byte[128];
    private int sector = 0;
    private int cmdreg = 0;
    private int rbaddr = 2;

    @Override
    public int rbGetAddr() {
        return this.rbaddr;
    }

    @Override
    public void rbSetAddr(int addr) {
        this.rbaddr = addr;
    }

    @Override
    public int rbRead(int reg) {
        if (reg < 128) {
            return this.databuf[reg] & 0xFF;
        }
        switch (reg) {
            case 128: {
                return this.sector & 0xFF;
            }
            case 129: {
                return this.sector >> 8;
            }
            case 130: {
                return this.cmdreg & 0xFF;
            }
        }
        return 0;
    }

    @Override
    public void rbWrite(int reg, int dat) {
        this.func_70296_d();
        if (reg < 128) {
            this.databuf[reg] = (byte)dat;
        } else {
            switch (reg) {
                case 128: {
                    this.sector = this.sector & 0xFF00 | dat;
                    break;
                }
                case 129: {
                    this.sector = this.sector & 0xFF | dat << 8;
                    break;
                }
                case 130: {
                    this.cmdreg = dat;
                }
            }
        }
    }

    @Override
    public int getConnectableMask() {
        return 0xFFFFFF;
    }

    @Override
    public int getConnectClass(int side) {
        return 66;
    }

    @Override
    public int getCornerPowerMode() {
        return 0;
    }

    @Override
    public void onBlockPlaced(ItemStack ist, int side, EntityLivingBase ent) {
        this.Rotation = (int)Math.floor((double)(ent.field_70177_z * 4.0f / 360.0f) + 0.5) + 1 & 3;
        if (ent instanceof EntityPlayer) {
            this.Owner = ((EntityPlayer)ent).func_146103_bH();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasDisk && this.contents[0] != null && !this.Active) {
                this.ejectDisk();
                return true;
            }
            return false;
        }
        return true;
    }

    public Block func_145838_q() {
        return RedPowerControl.blockPeripheral;
    }

    @Override
    public int getExtendedID() {
        return 2;
    }

    @Override
    public void onBlockRemoval() {
        for (int i = 0; i < 1; ++i) {
            ItemStack ist = this.contents[i];
            if (ist == null || ist.field_77994_a <= 0) continue;
            CoreLib.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ist);
        }
    }

    boolean setDisk(ItemStack ist) {
        if (this.contents[0] != null) {
            return false;
        }
        this.func_70299_a(0, ist);
        return true;
    }

    private NBTTagCompound getDiskTags() {
        NBTTagCompound tags = this.contents[0].field_77990_d;
        if (tags == null) {
            this.contents[0].func_77982_d(new NBTTagCompound());
            tags = this.contents[0].field_77990_d;
        }
        return tags;
    }

    /*
     * Exception decompiling
     */
    private File startDisk() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runCmd1() {
        Arrays.fill(this.databuf, (byte)0);
        String nm = "";
        if (this.contents[0].func_77960_j() > 0) {
            nm = "System Disk";
        } else {
            NBTTagCompound e = this.contents[0].field_77990_d;
            if (e == null) {
                return;
            }
            nm = e.func_74779_i("label");
        }
        try {
            byte[] e1 = nm.getBytes("US-ASCII");
            System.arraycopy(e1, 0, this.databuf, 0, Math.min(e1.length, 128));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void runCmd2() {
        if (this.contents[0].func_77960_j() > 0) {
            this.cmdreg = -1;
        } else {
            int len;
            NBTTagCompound tags = this.getDiskTags();
            for (len = 0; this.databuf[len] != 0 && len < 64; ++len) {
            }
            this.cmdreg = 0;
            try {
                String e = new String(this.databuf, 0, len, "US-ASCII");
                tags.func_74778_a("label", e);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private void runCmd3() {
        Arrays.fill(this.databuf, (byte)0);
        String nm = "";
        if (this.contents[0].func_77960_j() > 0) {
            nm = String.format("%016d", this.contents[0].func_77960_j());
        } else {
            NBTTagCompound e = this.getDiskTags();
            this.startDisk();
            if (e == null) {
                return;
            }
            nm = e.func_74779_i("serno");
        }
        try {
            byte[] e1 = nm.getBytes("US-ASCII");
            System.arraycopy(e1, 0, this.databuf, 0, Math.min(e1.length, 128));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCmd4() {
        if (this.sector > 2048) {
            this.cmdreg = -1;
        } else {
            long l = this.sector * 128;
            if (this.contents[0].func_77960_j() > 0) {
                InputStream file = null;
                switch (this.contents[0].func_77960_j()) {
                    case 1: {
                        file = RedPowerControl.class.getResourceAsStream("/assets/rpcontrol/forth/redforth.img");
                        break;
                    }
                    case 2: {
                        file = RedPowerControl.class.getResourceAsStream("/assets/rpcontrol/forth/redforthxp.img");
                    }
                }
                try {
                    if (file.skip(l) == l) {
                        if (file.read(this.databuf) == 128) {
                            this.cmdreg = 0;
                            return;
                        }
                        this.cmdreg = -1;
                        return;
                    }
                    this.cmdreg = -1;
                }
                catch (IOException var36) {
                    var36.printStackTrace();
                    this.cmdreg = -1;
                    return;
                }
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
            File file1 = this.startDisk();
            if (file1 == null) {
                this.cmdreg = -1;
            } else {
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(file1, "r");
                    raf.seek(l);
                    if (raf.read(this.databuf) == 128) {
                        this.cmdreg = 0;
                        return;
                    }
                    this.cmdreg = -1;
                }
                catch (IOException var34) {
                    var34.printStackTrace();
                    this.cmdreg = -1;
                }
                finally {
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCmd5() {
        if (this.contents[0].func_77960_j() > 0) {
            this.cmdreg = -1;
        } else if (this.sector > 2048) {
            this.cmdreg = -1;
        } else {
            long l = this.sector * 128;
            File file = this.startDisk();
            if (file == null) {
                this.cmdreg = -1;
            } else {
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(file, "rw");
                    raf.seek(l);
                    raf.write(this.databuf);
                    raf.close();
                    raf = null;
                    this.cmdreg = 0;
                }
                catch (IOException var14) {
                    this.cmdreg = -1;
                }
                finally {
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void runDiskCmd() {
        this.func_70296_d();
        if (this.contents[0] == null) {
            this.cmdreg = -1;
        } else if (!(this.contents[0].func_77973_b() instanceof ItemDisk)) {
            this.cmdreg = -1;
        } else {
            switch (this.cmdreg) {
                case 1: {
                    this.runCmd1();
                    this.cmdreg = 0;
                    break;
                }
                case 2: {
                    this.runCmd2();
                    break;
                }
                case 3: {
                    this.runCmd3();
                    this.cmdreg = 0;
                    break;
                }
                case 4: {
                    this.runCmd4();
                    break;
                }
                case 5: {
                    this.runCmd5();
                    break;
                }
                default: {
                    this.cmdreg = -1;
                }
            }
            this.accessTime = 5;
            if (!this.Active) {
                this.Active = true;
                this.updateBlock();
            }
        }
    }

    private void ejectDisk() {
        if (this.contents[0] != null) {
            MachineLib.ejectItem(this.field_145850_b, new WorldCoord(this), this.contents[0], CoreLib.rotToSide(this.Rotation) ^ 1);
            this.contents[0] = null;
            this.hasDisk = false;
            this.updateBlock();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.contents[0] != null && !(this.contents[0].func_77973_b() instanceof ItemDisk)) {
            this.ejectDisk();
        }
    }

    @Override
    public void func_145845_h() {
        if (this.cmdreg != 0 && this.cmdreg != -1) {
            this.runDiskCmd();
        }
        if (this.accessTime > 0 && --this.accessTime == 0) {
            this.Active = false;
            this.updateBlock();
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return this.contents[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.contents[i] == null) {
            return null;
        }
        if (this.contents[i].field_77994_a <= j) {
            ItemStack tr = this.contents[i];
            this.contents[i] = null;
            this.func_70296_d();
            return tr;
        }
        ItemStack tr = this.contents[i].func_77979_a(j);
        if (this.contents[i].field_77994_a == 0) {
            this.contents[i] = null;
        }
        this.func_70296_d();
        return tr;
    }

    public ItemStack func_70304_b(int i) {
        if (this.contents[i] == null) {
            return null;
        }
        ItemStack ist = this.contents[i];
        this.contents[i] = null;
        return ist;
    }

    public void func_70299_a(int i, ItemStack ist) {
        this.contents[i] = ist;
        if (ist != null && ist.field_77994_a > this.func_70297_j_()) {
            ist.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        this.hasDisk = this.contents[i] != null;
        this.updateBlock();
    }

    public String func_145825_b() {
        return "tile.rpdiskdrive.name";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.func_145837_r() && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void writeFramePacket(NBTTagCompound tag) {
        tag.func_74774_a("rot", (byte)this.Rotation);
        tag.func_74774_a("fl", (byte)((this.hasDisk ? 1 : 0) | (this.Active ? 2 : 0)));
    }

    @Override
    public void readFramePacket(NBTTagCompound tag) {
        this.Rotation = tag.func_74771_c("rot");
        byte fl = tag.func_74771_c("fl");
        this.hasDisk = (fl & 1) > 0;
        this.Active = (fl & 2) > 0;
    }

    @Override
    public void onFrameRefresh(IBlockAccess iba) {
    }

    @Override
    public void onFramePickup(IBlockAccess iba) {
    }

    @Override
    public void onFrameDrop() {
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.Rotation = data.func_74771_c("rot");
        this.accessTime = data.func_74771_c("actime");
        this.sector = data.func_74765_d("sect");
        this.cmdreg = data.func_74771_c("cmd") & 0xFF;
        this.rbaddr = data.func_74771_c("rbaddr") & 0xFF;
        byte fl = data.func_74771_c("fl");
        this.hasDisk = (fl & 1) > 0;
        this.Active = (fl & 2) > 0;
        this.databuf = data.func_74770_j("dbuf");
        if (this.databuf.length != 128) {
            this.databuf = new byte[128];
        }
        NBTTagList items = data.func_150295_c("Items", 10);
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int j = item.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.contents.length) continue;
            this.contents[j] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.hasDisk = this.contents[0] != null;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("rot", (byte)this.Rotation);
        int fl = (this.hasDisk ? 1 : 0) | (this.Active ? 2 : 0);
        data.func_74774_a("fl", (byte)fl);
        data.func_74774_a("actime", (byte)this.accessTime);
        data.func_74773_a("dbuf", this.databuf);
        data.func_74777_a("sect", (short)this.sector);
        data.func_74774_a("cmd", (byte)this.cmdreg);
        data.func_74774_a("rbaddr", (byte)this.rbaddr);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.contents[i].func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        data.func_74782_a("Items", (NBTBase)items);
    }

    @Override
    protected void readFromPacket(NBTTagCompound tag) {
        this.Rotation = tag.func_74771_c("rot");
        byte fl = tag.func_74771_c("fl");
        this.hasDisk = (fl & 1) > 0;
        this.Active = (fl & 2) > 0;
    }

    @Override
    protected void writeToPacket(NBTTagCompound tag) {
        tag.func_74774_a("rot", (byte)this.Rotation);
        tag.func_74774_a("fl", (byte)((this.hasDisk ? 1 : 0) | (this.Active ? 2 : 0)));
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotID, ItemStack stack) {
        return slotID == 0 && stack.func_77973_b() instanceof ItemDisk;
    }
}

