/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.control;

import com.eloraam.redpower.RedPowerControl;
import com.eloraam.redpower.core.IFrameSupport;
import com.eloraam.redpower.core.IRedbusConnectable;
import com.eloraam.redpower.core.TileExtended;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileDisplay
extends TileExtended
implements IRedbusConnectable,
IFrameSupport {
    public byte[] screen = new byte[4000];
    public int Rotation = 0;
    public int memRow = 0;
    public int cursX = 0;
    public int cursY = 0;
    public int cursMode = 2;
    public int kbstart = 0;
    public int kbpos = 0;
    public int blitXS = 0;
    public int blitYS = 0;
    public int blitXD = 0;
    public int blitYD = 0;
    public int blitW = 0;
    public int blitH = 0;
    public int blitMode = 0;
    public byte[] kbbuf = new byte[16];
    private int rbaddr = 1;

    public TileDisplay() {
        Arrays.fill(this.screen, (byte)32);
    }

    @Override
    public int rbGetAddr() {
        return this.rbaddr;
    }

    @Override
    public void rbSetAddr(int addr) {
        this.rbaddr = addr;
    }

    @Override
    public int rbRead(int reg) {
        if (reg >= 16 && reg < 96) {
            return this.screen[this.memRow * 80 + reg - 16];
        }
        switch (reg) {
            case 0: {
                return this.memRow;
            }
            case 1: {
                return this.cursX;
            }
            case 2: {
                return this.cursY;
            }
            case 3: {
                return this.cursMode;
            }
            case 4: {
                return this.kbstart;
            }
            case 5: {
                return this.kbpos;
            }
            case 6: {
                return this.kbbuf[this.kbstart] & 0xFF;
            }
            case 7: {
                return this.blitMode;
            }
            case 8: {
                return this.blitXS;
            }
            case 9: {
                return this.blitYS;
            }
            case 10: {
                return this.blitXD;
            }
            case 11: {
                return this.blitYD;
            }
            case 12: {
                return this.blitW;
            }
            case 13: {
                return this.blitH;
            }
        }
        return 0;
    }

    @Override
    public void rbWrite(int reg, int dat) {
        this.func_70296_d();
        if (reg >= 16 && reg < 96) {
            this.screen[this.memRow * 80 + reg - 16] = (byte)dat;
        } else {
            switch (reg) {
                case 0: {
                    this.memRow = dat;
                    if (this.memRow > 49) {
                        this.memRow = 49;
                    }
                    return;
                }
                case 1: {
                    this.cursX = dat;
                    return;
                }
                case 2: {
                    this.cursY = dat;
                    return;
                }
                case 3: {
                    this.cursMode = dat;
                    return;
                }
                case 4: {
                    this.kbstart = dat & 0xF;
                    return;
                }
                case 5: {
                    this.kbpos = dat & 0xF;
                    return;
                }
                case 6: {
                    this.kbbuf[this.kbstart] = (byte)dat;
                    return;
                }
                case 7: {
                    this.blitMode = dat;
                    return;
                }
                case 8: {
                    this.blitXS = dat;
                    return;
                }
                case 9: {
                    this.blitYS = dat;
                    return;
                }
                case 10: {
                    this.blitXD = dat;
                    return;
                }
                case 11: {
                    this.blitYD = dat;
                    return;
                }
                case 12: {
                    this.blitW = dat;
                    return;
                }
                case 13: {
                    this.blitH = dat;
                    return;
                }
            }
        }
    }

    @Override
    public int getConnectableMask() {
        return 0xFFFFFF;
    }

    @Override
    public int getConnectClass(int side) {
        return 66;
    }

    @Override
    public int getCornerPowerMode() {
        return 0;
    }

    @Override
    public void onBlockPlaced(ItemStack ist, int side, EntityLivingBase ent) {
        this.Rotation = (int)Math.floor((double)(ent.field_70177_z * 4.0f / 360.0f) + 0.5) + 1 & 3;
        if (ent instanceof EntityPlayer) {
            this.Owner = ((EntityPlayer)ent).func_146103_bH();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)RedPowerControl.instance, 1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public Block func_145838_q() {
        return RedPowerControl.blockPeripheral;
    }

    @Override
    public int getExtendedID() {
        return 0;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return !this.func_145837_r() && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void pushKey(byte b) {
        int np = this.kbpos + 1 & 0xF;
        if (np != this.kbstart) {
            this.kbbuf[this.kbpos] = b;
            this.kbpos = np;
        }
    }

    @Override
    public void func_145845_h() {
        this.runblitter();
    }

    private void runblitter() {
        if (this.blitMode != 0) {
            this.func_70296_d();
            int w = this.blitW;
            int h = this.blitH;
            w = Math.min(w, 80 - this.blitXD);
            h = Math.min(h, 50 - this.blitYD);
            if (w >= 0 && h >= 0) {
                int doffs = this.blitYD * 80 + this.blitXD;
                switch (this.blitMode) {
                    case 1: {
                        for (int soffs = 0; soffs < h; ++soffs) {
                            for (int j = 0; j < w; ++j) {
                                this.screen[doffs + 80 * soffs + j] = (byte)this.blitXS;
                            }
                        }
                        this.blitMode = 0;
                        return;
                    }
                    case 2: {
                        for (int soffs = 0; soffs < h; ++soffs) {
                            for (int j = 0; j < w; ++j) {
                                this.screen[doffs + 80 * soffs + j] = (byte)(this.screen[doffs + 80 * soffs + j] ^ 0x80);
                            }
                        }
                        this.blitMode = 0;
                        return;
                    }
                }
                w = Math.min(w, 80 - this.blitXS);
                h = Math.min(h, 50 - this.blitYS);
                if (w >= 0 && h >= 0) {
                    int soffs = this.blitYS * 80 + this.blitXS;
                    switch (this.blitMode) {
                        case 3: {
                            for (int j = 0; j < h; ++j) {
                                for (int i = 0; i < w; ++i) {
                                    this.screen[doffs + 80 * j + i] = this.screen[soffs + 80 * j + i];
                                }
                            }
                            this.blitMode = 0;
                            return;
                        }
                    }
                } else {
                    this.blitMode = 0;
                }
            } else {
                this.blitMode = 0;
            }
        }
    }

    @Override
    public void writeFramePacket(NBTTagCompound tag) {
        tag.func_74768_a("rot", this.Rotation);
    }

    @Override
    public void readFramePacket(NBTTagCompound tag) {
        this.Rotation = tag.func_74762_e("rot");
    }

    @Override
    public void onFrameRefresh(IBlockAccess iba) {
    }

    @Override
    public void onFramePickup(IBlockAccess iba) {
    }

    @Override
    public void onFrameDrop() {
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.Rotation = data.func_74771_c("rot");
        this.screen = data.func_74770_j("fb");
        if (this.screen.length != 4000) {
            this.screen = new byte[4000];
        }
        this.memRow = data.func_74771_c("row") & 0xFF;
        this.cursX = data.func_74771_c("cx") & 0xFF;
        this.cursY = data.func_74771_c("cy") & 0xFF;
        this.cursMode = data.func_74771_c("cm") & 0xFF;
        this.kbstart = data.func_74771_c("kbs");
        this.kbpos = data.func_74771_c("kbp");
        this.kbbuf = data.func_74770_j("kbb");
        if (this.kbbuf.length != 16) {
            this.kbbuf = new byte[16];
        }
        this.blitXS = data.func_74771_c("blxs") & 0xFF;
        this.blitYS = data.func_74771_c("blys") & 0xFF;
        this.blitXD = data.func_74771_c("blxd") & 0xFF;
        this.blitYD = data.func_74771_c("blyd") & 0xFF;
        this.blitW = data.func_74771_c("blw") & 0xFF;
        this.blitH = data.func_74771_c("blh") & 0xFF;
        this.blitMode = data.func_74771_c("blmd");
        this.rbaddr = data.func_74771_c("rbaddr") & 0xFF;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("rot", (byte)this.Rotation);
        data.func_74773_a("fb", this.screen);
        data.func_74774_a("row", (byte)this.memRow);
        data.func_74774_a("cx", (byte)this.cursX);
        data.func_74774_a("cy", (byte)this.cursY);
        data.func_74774_a("cm", (byte)this.cursMode);
        data.func_74774_a("kbs", (byte)this.kbstart);
        data.func_74774_a("kbp", (byte)this.kbpos);
        data.func_74773_a("kbb", this.kbbuf);
        data.func_74774_a("blxs", (byte)this.blitXS);
        data.func_74774_a("blys", (byte)this.blitYS);
        data.func_74774_a("blxd", (byte)this.blitXD);
        data.func_74774_a("blyd", (byte)this.blitYD);
        data.func_74774_a("blw", (byte)this.blitW);
        data.func_74774_a("blh", (byte)this.blitH);
        data.func_74774_a("blmd", (byte)this.blitMode);
        data.func_74774_a("rbaddr", (byte)this.rbaddr);
    }

    @Override
    protected void readFromPacket(NBTTagCompound tag) {
        this.Rotation = tag.func_74762_e("rot");
    }

    @Override
    protected void writeToPacket(NBTTagCompound tag) {
        tag.func_74768_a("rot", this.Rotation);
    }
}

