/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.control;

import com.eloraam.redpower.RedPowerControl;
import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.IFrameSupport;
import com.eloraam.redpower.core.IRedPowerConnectable;
import com.eloraam.redpower.core.IRedbusConnectable;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.TileMultipart;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileIOExpander
extends TileMultipart
implements IRedbusConnectable,
IRedPowerConnectable,
IFrameSupport {
    public int Rotation = 0;
    public int WBuf = 0;
    public int WBufNew = 0;
    public int RBuf = 0;
    private int rbaddr = 3;

    @Override
    public int rbGetAddr() {
        return this.rbaddr;
    }

    @Override
    public void rbSetAddr(int addr) {
        this.rbaddr = addr;
    }

    @Override
    public int rbRead(int reg) {
        switch (reg) {
            case 0: {
                return this.RBuf & 0xFF;
            }
            case 1: {
                return this.RBuf >> 8;
            }
            case 2: {
                return this.WBufNew & 0xFF;
            }
            case 3: {
                return this.WBufNew >> 8;
            }
        }
        return 0;
    }

    @Override
    public void rbWrite(int reg, int dat) {
        this.func_70296_d();
        switch (reg) {
            case 0: 
            case 2: {
                this.WBufNew = this.WBufNew & 0xFF00 | dat;
                this.scheduleTick(2);
                break;
            }
            case 1: 
            case 3: {
                this.WBufNew = this.WBufNew & 0xFF | dat << 8;
                this.scheduleTick(2);
            }
        }
    }

    @Override
    public int getConnectableMask() {
        return 15;
    }

    @Override
    public int getConnectClass(int side) {
        return side == CoreLib.rotToSide(this.Rotation) ? 18 : 66;
    }

    @Override
    public int getCornerPowerMode() {
        return 0;
    }

    @Override
    public int getPoweringMask(int ch) {
        return ch == 0 ? 0 : ((this.WBuf & 1 << ch - 1) > 0 ? RedPowerLib.mapRotToCon(8, this.Rotation) : 0);
    }

    @Override
    public void onBlockPlaced(ItemStack ist, int side, EntityLivingBase ent) {
        this.Rotation = (int)Math.floor((double)(ent.field_70177_z * 4.0f / 360.0f) + 0.5) + 1 & 3;
        if (ent instanceof EntityPlayer) {
            this.Owner = ((EntityPlayer)ent).func_146103_bH();
        }
    }

    @Override
    public void onTileTick() {
        if (this.WBuf != this.WBufNew) {
            this.WBuf = this.WBufNew;
            this.onBlockNeighborChange(Blocks.field_150350_a);
            this.updateBlockChange();
        }
    }

    @Override
    public void onBlockNeighborChange(Block block) {
        boolean ch = false;
        for (int n = 0; n < 16; ++n) {
            int ps = RedPowerLib.getRotPowerState((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 8, this.Rotation, n + 1);
            if (ps == 0) {
                if ((this.RBuf & 1 << n) <= 0) continue;
                this.RBuf &= ~(1 << n);
                ch = true;
                continue;
            }
            if ((this.RBuf & 1 << n) != 0) continue;
            this.RBuf |= 1 << n;
            ch = true;
        }
        if (ch) {
            this.updateBlock();
        }
    }

    public Block func_145838_q() {
        return RedPowerControl.blockFlatPeripheral;
    }

    @Override
    public int getExtendedID() {
        return 0;
    }

    @Override
    public void addHarvestContents(List<ItemStack> ist) {
        ist.add(new ItemStack(this.func_145838_q(), 1, 0));
    }

    @Override
    public void onHarvestPart(EntityPlayer player, int part, boolean willHarvest) {
        this.breakBlock(willHarvest);
    }

    @Override
    public float getPartStrength(EntityPlayer player, int part) {
        return 0.1f;
    }

    @Override
    public boolean blockEmpty() {
        return false;
    }

    @Override
    public void setPartBounds(BlockMultipart block, int part) {
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    @Override
    public int getSolidPartsMask() {
        return 1;
    }

    @Override
    public int getPartsMask() {
        return 1;
    }

    @Override
    public void writeFramePacket(NBTTagCompound tag) {
        tag.func_74774_a("rot", (byte)this.Rotation);
        tag.func_74777_a("wb", (short)this.WBuf);
    }

    @Override
    public void readFramePacket(NBTTagCompound tag) {
        this.Rotation = tag.func_74771_c("rot");
        this.WBuf = tag.func_74765_d("wb");
    }

    @Override
    public void onFrameRefresh(IBlockAccess iba) {
    }

    @Override
    public void onFramePickup(IBlockAccess iba) {
    }

    @Override
    public void onFrameDrop() {
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.Rotation = data.func_74771_c("rot");
        this.WBuf = data.func_74765_d("wb");
        this.WBufNew = data.func_74765_d("wbn");
        this.RBuf = data.func_74765_d("rb");
        this.rbaddr = data.func_74771_c("rbaddr") & 0xFF;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("rot", (byte)this.Rotation);
        data.func_74777_a("wb", (short)this.WBuf);
        data.func_74777_a("wbn", (short)this.WBufNew);
        data.func_74777_a("rb", (short)this.RBuf);
        data.func_74774_a("rbaddr", (byte)this.rbaddr);
    }

    @Override
    protected void readFromPacket(NBTTagCompound tag) {
        this.Rotation = tag.func_74771_c("rot");
        this.WBuf = tag.func_74765_d("wb");
    }

    @Override
    protected void writeToPacket(NBTTagCompound tag) {
        tag.func_74774_a("rot", (byte)this.Rotation);
        tag.func_74777_a("wb", (short)this.WBuf);
    }
}

