/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.control;

import com.eloraam.redpower.RedPowerControl;
import com.eloraam.redpower.control.TileBackplane;
import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.CoreLib;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileRAM
extends TileBackplane {
    public byte[] memory = new byte[8192];

    @Override
    public int readBackplane(int addr) {
        return this.memory[addr] & 0xFF;
    }

    @Override
    public void writeBackplane(int addr, int val) {
        this.memory[addr] = (byte)val;
    }

    @Override
    public Block func_145838_q() {
        return RedPowerControl.blockBackplane;
    }

    @Override
    public int getExtendedID() {
        return 1;
    }

    @Override
    public void addHarvestContents(List<ItemStack> ist) {
        ist.add(new ItemStack((Block)RedPowerControl.blockBackplane, 1, 0));
        ist.add(new ItemStack((Block)RedPowerControl.blockBackplane, 1, 1));
    }

    @Override
    public void onHarvestPart(EntityPlayer player, int part, boolean willHarvest) {
        if (willHarvest) {
            CoreLib.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack((Block)RedPowerControl.blockBackplane, 1, 1));
        }
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)RedPowerControl.blockBackplane);
        TileBackplane tb = CoreLib.getTileEntity((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, TileBackplane.class);
        if (tb != null) {
            tb.Rotation = this.Rotation;
        }
        this.updateBlockChange();
    }

    @Override
    public void setPartBounds(BlockMultipart block, int part) {
        if (part == 0) {
            super.setPartBounds(block, part);
        } else {
            block.func_149676_a(0.0f, 0.125f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public int getSolidPartsMask() {
        return 3;
    }

    @Override
    public int getPartsMask() {
        return 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.memory = data.func_74770_j("ram");
        if (this.memory.length != 8192) {
            this.memory = new byte[8192];
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74773_a("ram", this.memory);
    }
}

