/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.TileCoverable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockCoverable
extends BlockMultipart {
    public BlockCoverable(Material material) {
        super(material);
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        TileCoverable tc = CoreLib.getTileEntity(world, i, j, k, TileCoverable.class);
        return tc != null && tc.isSideNormal(side.ordinal());
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double srcX, double srcY, double srcZ) {
        Vec3 org = Vec3.func_72443_a((double)srcX, (double)srcY, (double)srcZ);
        Vec3 end = Vec3.func_72443_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
        Block bl = world.func_147439_a(x, y, z);
        if (bl == null) {
            return 0.0f;
        }
        MovingObjectPosition mop = bl.func_149731_a(world, x, y, z, org, end);
        if (mop == null) {
            return bl.func_149638_a(exploder);
        }
        TileCoverable tl = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileCoverable.class);
        if (tl == null) {
            return bl.func_149638_a(exploder);
        }
        float er = tl.getExplosionResistance(mop.subHit, mop.field_72310_e, exploder);
        return er < 0.0f ? bl.func_149638_a(exploder) : er;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileCoverable tile = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileCoverable.class);
        return tile != null ? tile.getPickBlock(target, player) : null;
    }
}

