/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.BlockExtended;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.TileMultipart;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMultipart
extends BlockExtended {
    public BlockMultipart(Material material) {
        super(material);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileMultipart tl = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileMultipart.class);
        if (tl == null) {
            world.func_147468_f(x, y, z);
        } else {
            tl.onBlockNeighborChange(block);
        }
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileMultipart tl;
        MovingObjectPosition mop;
        if (!world.field_72995_K && (mop = CoreLib.retraceBlock(world, (EntityLivingBase)player, x, y, z)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (tl = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileMultipart.class)) != null) {
            tl.onHarvestPart(player, mop.subHit, willHarvest);
        }
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xp, float yp, float zp) {
        MovingObjectPosition pos = CoreLib.retraceBlock(world, (EntityLivingBase)player, x, y, z);
        if (pos == null) {
            return false;
        }
        if (pos.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        TileMultipart tl = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileMultipart.class);
        return tl != null && tl.onPartActivateSide(player, pos.subHit, pos.field_72310_e);
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        MovingObjectPosition pos = CoreLib.retraceBlock(world, (EntityLivingBase)player, x, y, z);
        if (pos == null) {
            return 0.0f;
        }
        if (pos.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return 0.0f;
        }
        TileMultipart tl = CoreLib.getTileEntity((IBlockAccess)player.field_70170_p, x, y, z, TileMultipart.class);
        return tl == null ? 0.0f : tl.getPartStrength(player, pos.subHit);
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        TileMultipart tl = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileMultipart.class);
        if (tl != null) {
            tl.breakBlock();
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB box, List list, Entity ent) {
        TileMultipart tl = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileMultipart.class);
        if (tl != null) {
            int pt;
            for (int pm = tl.getSolidPartsMask(); pm > 0; pm &= ~(1 << pt)) {
                pt = Integer.numberOfTrailingZeros(pm);
                tl.setPartBounds(this, pt);
                super.func_149743_a(world, x, y, z, box, list, ent);
            }
        }
    }

    @Override
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return super.func_149633_g(world, x, y, z);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        int pt;
        TileMultipart multipart = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileMultipart.class);
        if (multipart == null) {
            return null;
        }
        MovingObjectPosition result = null;
        int cpt = -1;
        double distance = 0.0;
        for (int pm = multipart.getPartsMask(); pm > 0; pm &= ~(1 << pt)) {
            pt = Integer.numberOfTrailingZeros(pm);
            multipart.setPartBounds(this, pt);
            MovingObjectPosition mop = super.func_149731_a(world, x, y, z, start, end);
            if (mop == null) continue;
            double max = mop.field_72307_f.func_72436_e(start);
            if (result != null && !(max < distance)) continue;
            distance = max;
            result = mop;
            cpt = pt;
        }
        if (result == null) {
            return null;
        }
        multipart.setPartBounds(this, cpt);
        result.subHit = cpt;
        return result;
    }

    protected MovingObjectPosition traceCurrentBlock(World world, int x, int y, int z, Vec3 src, Vec3 dest) {
        return super.func_149731_a(world, x, y, z, src, dest);
    }

    public void setPartBounds(World world, int x, int y, int z, int part) {
        TileMultipart tl = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileMultipart.class);
        if (tl == null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            tl.setPartBounds(this, part);
        }
    }

    public void computeCollidingBoxes(World world, int x, int y, int z, AxisAlignedBB box, List list, TileMultipart tl) {
        int pt;
        for (int pm = tl.getSolidPartsMask(); pm > 0; pm &= ~(1 << pt)) {
            pt = Integer.numberOfTrailingZeros(pm);
            tl.setPartBounds(this, pt);
            super.func_149743_a(world, x, y, z, box, list, null);
        }
    }
}

