/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.IBluePowerConnectable;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.WorldCoord;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BluePowerConductor {
    private static int[] dirmap = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 11, 14, 18, 23};
    int imask = 0;
    double[] currents;
    public double Vcap = 0.0;
    public double Icap = 0.0;
    public double Veff = 0.0;
    int lastTick = 0;
    public double It1 = 0.0;
    public double Itot = 0.0;

    public abstract TileEntity getParent();

    public abstract double getInvCap();

    public int getChargeScaled(int i) {
        return 0;
    }

    public int getFlowScaled(int i) {
        return 0;
    }

    public double getResistance() {
        return 0.01;
    }

    public double getIndScale() {
        return 0.07;
    }

    public double getCondParallel() {
        return 0.5;
    }

    public void recache(int conm, int econm) {
        int imo = 0;
        for (int c2 = 0; c2 < 3; ++c2) {
            if ((conm & RedPowerLib.getConDirMask(c2 * 2)) <= 0) continue;
            imo |= 1 << c2;
        }
        for (int var12 = 0; var12 < 12; ++var12) {
            if ((econm & 1 << dirmap[var12]) <= 0) continue;
            imo |= 8 << var12;
        }
        if (this.imask != imo) {
            double[] var11 = new double[Integer.bitCount(imo)];
            int s = 0;
            int d = 0;
            for (int a = 0; a < 15; ++a) {
                int m = 1 << a;
                double v = 0.0;
                if ((this.imask & m) > 0) {
                    v = this.currents[s++];
                }
                if ((imo & m) <= 0) continue;
                var11[d++] = v;
            }
            this.currents = var11;
            this.imask = imo;
        }
    }

    protected void computeVoltage() {
        this.Itot = 0.5 * this.It1;
        this.It1 = 0.0;
        this.Vcap += 0.05 * this.Icap * this.getInvCap();
        this.Icap = 0.0;
    }

    public double getVoltage() {
        long lt = this.getParent().func_145831_w().func_82737_E();
        if ((lt & 0xFFFFL) == (long)this.lastTick) {
            return this.Vcap;
        }
        this.lastTick = (int)(lt & 0xFFFFL);
        this.computeVoltage();
        return this.Vcap;
    }

    public void applyCurrent(double Iin) {
        this.getVoltage();
        this.Icap += Iin;
        this.It1 += Math.abs(Iin);
    }

    public void drawPower(double P) {
        double p1 = this.Vcap * this.Vcap - 0.1 * P * this.getInvCap();
        double t = p1 < 0.0 ? 0.0 : Math.sqrt(p1) - this.Vcap;
        this.applyDirect(20.0 * t / this.getInvCap());
    }

    public double getEnergy(double vthresh) {
        double d = this.getVoltage();
        double tr = 0.5 * (d * d - vthresh * vthresh) / this.getInvCap();
        return tr < 0.0 ? 0.0 : tr;
    }

    public void applyPower(double P) {
        double t = Math.sqrt(this.Vcap * this.Vcap + 0.1 * P * this.getInvCap()) - this.Vcap;
        this.applyDirect(20.0 * t / this.getInvCap());
    }

    public void applyDirect(double Iin) {
        this.applyCurrent(Iin);
    }

    public void iterate() {
        TileEntity parent = this.getParent();
        World world = parent.func_145831_w();
        this.getVoltage();
        int dm = this.imask;
        int s = 0;
        while (dm > 0) {
            int facing;
            int d = Integer.numberOfTrailingZeros(dm);
            dm &= ~(1 << d);
            WorldCoord wc = new WorldCoord(parent);
            if (d < 3) {
                facing = d * 2;
                wc.step(facing);
            } else {
                int ibc = dirmap[d - 3];
                wc.step(ibc >> 2);
                facing = WorldCoord.getIndStepDir(ibc >> 2, ibc & 3);
                wc.step(facing);
            }
            IBluePowerConnectable powerConnectable = CoreLib.getTileEntity((IBlockAccess)world, wc, IBluePowerConnectable.class);
            if (powerConnectable != null) {
                BluePowerConductor bpc = powerConnectable.getBlueConductor(facing ^ 1);
                double r = this.getResistance() + bpc.getResistance();
                double I = this.currents[s];
                double V = this.Vcap - bpc.getVoltage();
                int n = s;
                this.currents[n] = this.currents[n] + (V - I * r) * this.getIndScale();
                this.applyCurrent(-(I += V * this.getCondParallel()));
                bpc.applyCurrent(I);
            }
            ++s;
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.imask = tag.func_74762_e("bpim");
        int l = Integer.bitCount(this.imask);
        this.currents = new double[l];
        NBTTagList clist = tag.func_150295_c("bpil", 6);
        if (clist.func_74745_c() == l) {
            for (int i = 0; i < l; ++i) {
                this.currents[i] = clist.func_150309_d(i);
            }
            this.Vcap = tag.func_74769_h("vcap");
            this.Icap = tag.func_74769_h("icap");
            this.Veff = tag.func_74769_h("veff");
            this.It1 = tag.func_74769_h("it1");
            this.Itot = tag.func_74769_h("itot");
            this.lastTick = tag.func_74762_e("ltk");
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("bpim", this.imask);
        int l = Integer.bitCount(this.imask);
        NBTTagList clist = new NBTTagList();
        for (int i = 0; i < l; ++i) {
            NBTTagDouble val = new NBTTagDouble(this.currents[i]);
            clist.func_74742_a((NBTBase)val);
        }
        tag.func_74782_a("bpil", (NBTBase)clist);
        tag.func_74780_a("vcap", this.Vcap);
        tag.func_74780_a("icap", this.Icap);
        tag.func_74780_a("veff", this.Veff);
        tag.func_74780_a("it1", this.It1);
        tag.func_74780_a("itot", this.Itot);
        tag.func_74768_a("ltk", this.lastTick);
    }
}

