/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.TileExtended;
import com.eloraam.redpower.core.WorldCoord;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.oredict.OreDictionary;

public class CoreLib {
    private static TreeMap<ItemStack, String> oreMap = new TreeMap(CoreLib::compareItemStack);
    public static String[] rawColorNames = new String[]{"white", "orange", "magenta", "lightBlue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    public static String[] enColorNames = new String[]{"White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    public static int[] paintColors = new int[]{0xFFFFFF, 0xFF8000, 0xFF00FF, 7110911, 0xFFFF00, 65280, 16737408, 0x535353, 0x939393, 65535, 0x8000FF, 255, 5187328, 32768, 0xFF0000, 0x1F1F1F};
    public static final Material materialRedpower = new Material(MapColor.field_151663_o);
    public static final GameProfile REDPOWER_PROFILE = new GameProfile(UUID.fromString("d90e51a0-41af-4a37-9fd0-f2fdc15a181b"), "[RedPower]");

    public static FakePlayer getRedpowerPlayer(World world, int x, int y, int z, int rotation, GameProfile profile) {
        float yaw;
        float pitch;
        MinecraftServer server = ((WorldServer)world).func_73046_m();
        FakePlayer player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)profile);
        double dx = (double)x + 0.5;
        double dy = (double)y - 1.1;
        double dz = (double)z + 0.5;
        switch (rotation ^ 1) {
            case 0: {
                pitch = 90.0f;
                yaw = 0.0f;
                dy -= 0.51;
                break;
            }
            case 1: {
                pitch = -90.0f;
                yaw = 0.0f;
                dy += 0.51;
                break;
            }
            case 2: {
                pitch = 0.0f;
                yaw = 180.0f;
                dz -= 0.51;
                break;
            }
            case 3: {
                pitch = 0.0f;
                yaw = 0.0f;
                dz += 0.51;
                break;
            }
            case 4: {
                pitch = 0.0f;
                yaw = 90.0f;
                dx -= 0.51;
                break;
            }
            default: {
                pitch = 0.0f;
                yaw = 270.0f;
                dx += 0.51;
            }
        }
        player.func_70012_b(dx, dy, dz, yaw, pitch);
        return player;
    }

    public static boolean hasBreakPermission(EntityPlayerMP player, int x, int y, int z) {
        return CoreLib.hasEditPermission(player, x, y, z) && !ForgeHooks.onBlockBreakEvent((World)player.field_70170_p, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z).isCanceled();
    }

    public static boolean hasEditPermission(EntityPlayerMP player, int x, int y, int z) {
        return player.func_82247_a(x, y, z, player.field_70170_p.func_72805_g(x, y, z), null) && !MinecraftServer.func_71276_C().func_96290_a(player.field_70170_p, x, y, z, (EntityPlayer)player);
    }

    public static void updateAllLightTypes(World world, int x, int y, int z) {
        world.func_147463_c(EnumSkyBlock.Block, x, y, z);
        world.func_147463_c(EnumSkyBlock.Sky, x, y, z);
    }

    @Deprecated
    void initModule(String name) {
        Method mth;
        Class<?> cl;
        try {
            cl = Class.forName(name);
        }
        catch (ClassNotFoundException var7) {
            return;
        }
        try {
            mth = cl.getDeclaredMethod("initialize", new Class[0]);
        }
        catch (NoSuchMethodException var6) {
            return;
        }
        try {
            mth.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static <T> T getTileEntity(IBlockAccess iba, int x, int y, int z, Class<T> type) {
        TileEntity tile = iba.func_147438_o(x, y, z);
        return (T)(tile != null && type.isAssignableFrom(tile.getClass()) ? tile : null);
    }

    public static <T> T getTileEntity(IBlockAccess iba, WorldCoord wc, Class<T> type) {
        TileEntity tile = iba.func_147438_o(wc.x, wc.y, wc.z);
        return (T)(tile != null && type.isAssignableFrom(tile.getClass()) ? tile : null);
    }

    public static <T extends TileEntity> T getGuiTileEntity(World world, int x, int y, int z, Class<T> cl) {
        if (!world.field_72995_K) {
            TileEntity tr = world.func_147438_o(x, y, z);
            return (T)(!cl.isInstance(tr) ? null : tr);
        }
        try {
            TileEntity t = (TileEntity)cl.newInstance();
            t.func_145834_a(world);
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException var6) {
            return null;
        }
    }

    public static void markBlockDirty(World world, int i, int j, int k) {
        if (world.func_72899_e(i, j, k)) {
            world.func_72938_d(i, k).func_76630_e();
        }
    }

    public static int compareItemStack(ItemStack a, ItemStack b) {
        return Item.func_150891_b((Item)a.func_77973_b()) != Item.func_150891_b((Item)b.func_77973_b()) ? Item.func_150891_b((Item)a.func_77973_b()) - Item.func_150891_b((Item)b.func_77973_b()) : (a.func_77960_j() == b.func_77960_j() ? 0 : (a.func_77973_b().func_77614_k() ? a.func_77960_j() - b.func_77960_j() : 0));
    }

    static void registerOre(String name, ItemStack ore) {
        oreMap.put(ore, name);
    }

    public static void readOres() {
        for (String st : OreDictionary.getOreNames()) {
            for (ItemStack ist : OreDictionary.getOres((String)st)) {
                CoreLib.registerOre(st, ist);
            }
        }
    }

    public static String getOreClass(ItemStack ist) {
        String st = oreMap.get(ist);
        if (st != null) {
            return st;
        }
        ist = new ItemStack(ist.func_77973_b(), 1, -1);
        return oreMap.get(ist);
    }

    public static boolean matchItemStackOre(ItemStack a, ItemStack b) {
        String s1 = CoreLib.getOreClass(a);
        String s2 = CoreLib.getOreClass(b);
        return (ItemStack.func_77989_b((ItemStack)a, (ItemStack)b) || s1 != null && s2 != null && s1.equals(s2)) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static void dropItem(World world, int i, int j, int k, ItemStack ist) {
        if (!world.field_72995_K) {
            double d = 0.7;
            double x = (double)world.field_73012_v.nextFloat() * d + (1.0 - d) * 0.5;
            double y = (double)world.field_73012_v.nextFloat() * d + (1.0 - d) * 0.5;
            double z = (double)world.field_73012_v.nextFloat() * d + (1.0 - d) * 0.5;
            EntityItem item = new EntityItem(world, (double)i + x, (double)j + y, (double)k + z, ist);
            item.field_145804_b = 10;
            world.func_72838_d((Entity)item);
        }
    }

    public static ItemStack copyStack(ItemStack ist, int n) {
        return new ItemStack(ist.func_77973_b(), n, ist.func_77960_j());
    }

    public static int rotToSide(int r) {
        switch (r) {
            case 0: {
                return 5;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
        }
        return 2;
    }

    public static int getFacing(int side) {
        switch (side) {
            case 0: {
                return 2;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public static MovingObjectPosition retraceBlock(World world, EntityLivingBase ent, int x, int y, int z) {
        Vec3 org = Vec3.func_72443_a((double)ent.field_70165_t, (double)(ent.field_70163_u + 1.62 - (double)ent.field_70129_M), (double)ent.field_70161_v);
        Vec3 vec = ent.func_70676_i(1.0f);
        Vec3 end = org.func_72441_c(vec.field_72450_a * 5.0, vec.field_72448_b * 5.0, vec.field_72449_c * 5.0);
        Block bl = world.func_147439_a(x, y, z);
        return bl == null ? null : bl.func_149731_a(world, x, y, z, org, end);
    }

    public static MovingObjectPosition traceBlock(EntityPlayer player) {
        Vec3 org = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + 1.62 - (double)player.field_70129_M), (double)player.field_70161_v);
        Vec3 vec = player.func_70676_i(1.0f);
        Vec3 end = org.func_72441_c(vec.field_72450_a * 5.0, vec.field_72448_b * 5.0, vec.field_72449_c * 5.0);
        return player.field_70170_p.func_72933_a(org, end);
    }

    public static void placeNoise(World world, int i, int j, int k, Block block) {
        world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
    }

    public static int getBurnTime(ItemStack ist) {
        return TileEntityFurnace.func_145952_a((ItemStack)ist);
    }

    public static double getAverageEdgeLength(AxisAlignedBB aabb) {
        double d = aabb.field_72336_d - aabb.field_72340_a;
        double d1 = aabb.field_72337_e - aabb.field_72338_b;
        double d2 = aabb.field_72334_f - aabb.field_72339_c;
        return (d + d1 + d2) / 3.0;
    }

    public static void writeChat(EntityPlayer pl, String str) {
        if (pl instanceof EntityPlayerMP) {
            EntityPlayerMP emp = (EntityPlayerMP)pl;
            emp.func_146105_b((IChatComponent)new ChatComponentText(str));
        }
    }

    public static void updateBlock(World world, int x, int y, int z) {
        if (!(world.func_147438_o(x, y, z) instanceof TileExtended)) {
            world.func_147479_m(x, y, z);
        }
    }

    public static int[] toIntArray(List<Integer> integerList) {
        int[] intArray = new int[integerList.size()];
        for (int i = 0; i < integerList.size(); ++i) {
            intArray[i] = integerList.get(i);
        }
        return intArray;
    }

    public static <T, E> void setFinalValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        try {
            CoreLib.findField(classToAccess, fieldNames).set(instance, value);
        }
        catch (Exception var5) {
            throw new ReflectionHelper.UnableToAccessFieldException(fieldNames, var5);
        }
    }

    public static Field findField(Class<?> clazz, String ... fieldNames) {
        Exception failed = null;
        for (String fieldName : fieldNames) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                return field;
            }
            catch (Exception var9) {
                failed = var9;
            }
        }
        throw new ReflectionHelper.UnableToFindFieldException(fieldNames, failed);
    }
}

