/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverRenderer;
import com.eloraam.redpower.core.IBlockHardness;
import com.eloraam.redpower.core.ICoverable;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.TileCovered;
import com.eloraam.redpower.core.WorldCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CoverLib {
    public static final float selectBoxWidth = 0.25f;
    public static Block blockCoverPlate = null;
    public static ItemStack[] materials = new ItemStack[256];
    private static String[] names = new String[256];
    private static int[] hardness = new int[256];
    private static List<IMaterialHandler> materialHandlers = new ArrayList<IMaterialHandler>();
    private static boolean[] transparency = new boolean[256];
    private static float[] miningHardness = new float[256];
    private static Map<Item, List<Integer>> coverIndex = new LinkedHashMap<Item, List<Integer>>();

    public static void addMaterialHandler(IMaterialHandler handler) {
        for (int i = 0; i < 256; ++i) {
            if (materials[i] == null) continue;
            handler.addMaterial(i);
        }
        materialHandlers.add(handler);
    }

    public static Integer getMaterial(ItemStack ist) {
        List<Integer> cvr = coverIndex.get(ist.func_77973_b());
        int meta = ist.func_77960_j();
        if (cvr == null) {
            return null;
        }
        return meta >= cvr.size() ? null : cvr.get(meta);
    }

    public static void addMaterial(int n, int hard, Block bl, String name) {
        CoverLib.addMaterial(n, hard, false, bl, 0, name);
    }

    public static void addMaterial(int n, int hard, Block bl, int md, String name) {
        CoverLib.addMaterial(n, hard, false, bl, md, name);
    }

    public static void addMaterial(int n, int hard, boolean tpar, Block bl, String name) {
        CoverLib.addMaterial(n, hard, tpar, bl, 0, name);
    }

    public static void addMaterial(int n, int hard, boolean tpar, Block bl, int md, String name) {
        ItemStack ist = new ItemStack(bl, 1, md);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            CoverRenderer.coverIcons[n] = new IIcon[6];
            for (int i = 0; i < 6; ++i) {
                CoverRenderer.coverIcons[n][i] = bl.func_149691_a(i, md);
            }
        }
        CoverLib.miningHardness[n] = bl instanceof IBlockHardness ? ((IBlockHardness)bl).getPrototypicalHardness(md) : bl.func_149712_f(null, 0, 0, 0);
        CoverLib.materials[n] = ist;
        CoverLib.names[n] = name;
        CoverLib.hardness[n] = hard;
        CoverLib.transparency[n] = tpar;
        coverIndex.computeIfAbsent(ist.func_77973_b(), ix -> new ArrayList()).add(md, n);
        for (IMaterialHandler imh : materialHandlers) {
            imh.addMaterial(n);
        }
    }

    public static int damageToCoverData(int dmg) {
        int hd = dmg >> 8;
        int cn = dmg & 0xFF;
        switch (hd) {
            case 0: {
                cn |= 0x10000;
            }
            default: {
                break;
            }
            case 16: {
                cn |= 0x20100;
                break;
            }
            case 17: {
                cn |= 0x40200;
                break;
            }
            case 18: {
                cn |= 0x2010000;
                break;
            }
            case 19: {
                cn |= 0x2020100;
                break;
            }
            case 20: {
                cn |= 0x2040200;
                break;
            }
            case 21: {
                cn |= 0x1010000;
                break;
            }
            case 22: {
                cn |= 0x1020100;
                break;
            }
            case 23: {
                cn |= 0x1040200;
                break;
            }
            case 24: {
                cn |= 0x110300;
                break;
            }
            case 25: {
                cn |= 0x120400;
                break;
            }
            case 26: {
                cn |= 0x140500;
                break;
            }
            case 27: {
                cn |= 0x30600;
                break;
            }
            case 28: {
                cn |= 0x50700;
                break;
            }
            case 29: {
                cn |= 0x60800;
                break;
            }
            case 30: {
                cn |= 0x70900;
                break;
            }
            case 31: {
                cn |= 0x130A00;
                break;
            }
            case 32: {
                cn |= 0x150B00;
                break;
            }
            case 33: {
                cn |= 0x160C00;
                break;
            }
            case 34: {
                cn |= 0x170D00;
                break;
            }
            case 35: {
                cn |= 0x2030300;
                break;
            }
            case 36: {
                cn |= 0x2050400;
                break;
            }
            case 37: {
                cn |= 0x2060500;
                break;
            }
            case 38: {
                cn |= 0x2070600;
                break;
            }
            case 39: {
                cn |= 0x1030300;
                break;
            }
            case 40: {
                cn |= 0x1050400;
                break;
            }
            case 41: {
                cn |= 0x1060500;
                break;
            }
            case 42: {
                cn |= 0x1070600;
                break;
            }
            case 43: {
                cn |= 0x3020000;
                break;
            }
            case 44: {
                cn |= 0x3040100;
                break;
            }
            case 45: {
                cn |= 0x3060200;
            }
        }
        return cn;
    }

    public static int damageToCoverValue(int dmg) {
        return CoverLib.damageToCoverData(dmg) & 0xFFFF;
    }

    public static int coverValueToDamage(int side, int cov) {
        int hd = cov >> 8;
        int cn = cov & 0xFF;
        if (side < 6) {
            switch (hd) {
                case 1: {
                    cn |= 0x1000;
                    break;
                }
                case 2: {
                    cn |= 0x1100;
                    break;
                }
                case 3: {
                    cn |= 0x1800;
                    break;
                }
                case 4: {
                    cn |= 0x1900;
                    break;
                }
                case 5: {
                    cn |= 0x1A00;
                    break;
                }
                case 6: {
                    cn |= 0x1B00;
                    break;
                }
                case 7: {
                    cn |= 0x1C00;
                    break;
                }
                case 8: {
                    cn |= 0x1D00;
                    break;
                }
                case 9: {
                    cn |= 0x1E00;
                    break;
                }
                case 10: {
                    cn |= 0x1F00;
                    break;
                }
                case 11: {
                    cn |= 0x2000;
                    break;
                }
                case 12: {
                    cn |= 0x2100;
                    break;
                }
                case 13: {
                    cn |= 0x2200;
                }
            }
        } else if (side < 14) {
            switch (hd) {
                case 0: {
                    cn |= 0x1200;
                    break;
                }
                case 1: {
                    cn |= 0x1300;
                    break;
                }
                case 2: {
                    cn |= 0x1400;
                    break;
                }
                case 3: {
                    cn |= 0x2300;
                    break;
                }
                case 4: {
                    cn |= 0x2400;
                    break;
                }
                case 5: {
                    cn |= 0x2500;
                    break;
                }
                case 6: {
                    cn |= 0x2600;
                }
            }
        } else if (side < 26) {
            switch (hd) {
                case 0: {
                    cn |= 0x1500;
                    break;
                }
                case 1: {
                    cn |= 0x1600;
                    break;
                }
                case 2: {
                    cn |= 0x1700;
                    break;
                }
                case 3: {
                    cn |= 0x2700;
                    break;
                }
                case 4: {
                    cn |= 0x2800;
                    break;
                }
                case 5: {
                    cn |= 0x2900;
                    break;
                }
                case 6: {
                    cn |= 0x2A00;
                }
            }
        } else if (side < 29) {
            switch (hd) {
                case 0: {
                    cn |= 0x2B00;
                    break;
                }
                case 1: {
                    cn |= 0x2C00;
                    break;
                }
                case 2: {
                    cn |= 0x2D00;
                }
            }
        }
        return cn;
    }

    public static ItemStack convertCoverPlate(int side, int cov) {
        return blockCoverPlate == null ? null : new ItemStack(blockCoverPlate, 1, CoverLib.coverValueToDamage(side, cov));
    }

    public static int cornerToCoverMask(int cn) {
        switch (cn) {
            case 0: {
                return 21;
            }
            case 1: {
                return 25;
            }
            case 2: {
                return 37;
            }
            case 3: {
                return 41;
            }
            case 4: {
                return 22;
            }
            case 5: {
                return 26;
            }
            case 6: {
                return 38;
            }
        }
        return 42;
    }

    public static int coverToCornerMask(int cn) {
        switch (cn) {
            case 0: {
                return 15;
            }
            case 1: {
                return 240;
            }
            case 2: {
                return 85;
            }
            case 3: {
                return 170;
            }
            case 4: {
                return 51;
            }
        }
        return 204;
    }

    public static int coverToStripMask(int cn) {
        switch (cn) {
            case 0: {
                return 15;
            }
            case 1: {
                return 3840;
            }
            case 2: {
                return 337;
            }
            case 3: {
                return 674;
            }
            case 4: {
                return 1076;
            }
        }
        return 2248;
    }

    public static int stripToCornerMask(int sn) {
        switch (sn) {
            case 0: {
                return 5;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 17;
            }
            case 5: {
                return 34;
            }
            case 6: {
                return 68;
            }
            case 7: {
                return 136;
            }
            case 8: {
                return 80;
            }
            case 9: {
                return 160;
            }
            case 10: {
                return 48;
            }
        }
        return 192;
    }

    public static int stripToCoverMask(int sn) {
        switch (sn) {
            case 0: {
                return 5;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 17;
            }
            case 3: {
                return 33;
            }
            case 4: {
                return 20;
            }
            case 5: {
                return 24;
            }
            case 6: {
                return 36;
            }
            case 7: {
                return 40;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 18;
            }
        }
        return 34;
    }

    public static float getThickness(int side, int cov) {
        if (side < 6) {
            switch (cov >> 8) {
                case 0: {
                    return 0.125f;
                }
                case 1: {
                    return 0.25f;
                }
                case 2: {
                    return 0.5f;
                }
                case 3: {
                    return 0.125f;
                }
                case 4: {
                    return 0.25f;
                }
                case 5: {
                    return 0.5f;
                }
                case 6: {
                    return 0.375f;
                }
                case 7: {
                    return 0.625f;
                }
                case 8: {
                    return 0.75f;
                }
                case 9: {
                    return 0.875f;
                }
                case 10: {
                    return 0.375f;
                }
                case 11: {
                    return 0.625f;
                }
                case 12: {
                    return 0.75f;
                }
                case 13: {
                    return 0.875f;
                }
            }
            return 1.0f;
        }
        if (side >= 26 && side < 29) {
            switch (cov >> 8) {
                case 0: {
                    return 0.125f;
                }
                case 1: {
                    return 0.25f;
                }
                case 2: {
                    return 0.375f;
                }
            }
        }
        switch (cov >> 8) {
            case 0: {
                return 0.125f;
            }
            case 1: {
                return 0.25f;
            }
            case 2: {
                return 0.5f;
            }
            case 3: {
                return 0.375f;
            }
            case 4: {
                return 0.625f;
            }
            case 5: {
                return 0.75f;
            }
            case 6: {
                return 0.875f;
            }
        }
        return 1.0f;
    }

    public static int getThicknessQuanta(int side, int cov) {
        if (side < 6) {
            switch (cov >> 8) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 3;
                }
                case 7: {
                    return 5;
                }
                case 8: {
                    return 6;
                }
                case 9: {
                    return 7;
                }
                case 10: {
                    return 3;
                }
                case 11: {
                    return 5;
                }
                case 12: {
                    return 6;
                }
                case 13: {
                    return 7;
                }
            }
            return 0;
        }
        if (side >= 26 && side < 29) {
            switch (cov >> 8) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
        }
        switch (cov >> 8) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
        }
        return 0;
    }

    public static boolean checkPlacement(int covm, short[] covs, int cons, boolean jacket) {
        PlacementValidator pv = new PlacementValidator(covm, covs);
        return pv.checkPlacement(cons, jacket);
    }

    private static boolean canAddCover(World world, MovingObjectPosition mop, int item) {
        if (world.func_147472_a(blockCoverPlate, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false, mop.field_72310_e, null, null)) {
            return true;
        }
        ICoverable icv = CoreLib.getTileEntity((IBlockAccess)world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, ICoverable.class);
        return icv != null && icv.canAddCover(mop.subHit, item);
    }

    public static int extractCoverSide(MovingObjectPosition src) {
        int tr = 0;
        double rpx = src.field_72307_f.field_72450_a - (double)src.field_72311_b - 0.5;
        double rpy = src.field_72307_f.field_72448_b - (double)src.field_72312_c - 0.5;
        double rpz = src.field_72307_f.field_72449_c - (double)src.field_72309_d - 0.5;
        float sbw = 0.25f;
        switch (src.field_72310_e) {
            case 0: 
            case 1: {
                if (rpz > (double)(-sbw) && rpz < (double)sbw && rpx > (double)(-sbw) && rpx < (double)sbw) {
                    return src.field_72310_e;
                }
                if (rpz > rpx) {
                    if (rpz > -rpx) {
                        return 3;
                    }
                    return 4;
                }
                if (rpz > -rpx) {
                    return 5;
                }
                return 2;
            }
            case 2: 
            case 3: {
                if (rpy > (double)(-sbw) && rpy < (double)sbw && rpx > (double)(-sbw) && rpx < (double)sbw) {
                    return src.field_72310_e;
                }
                if (rpy > rpx) {
                    if (rpy > -rpx) {
                        return 1;
                    }
                    return 4;
                }
                if (rpy > -rpx) {
                    return 5;
                }
                return 0;
            }
            case 4: 
            case 5: {
                if (rpy > (double)(-sbw) && rpy < (double)sbw && rpz > (double)(-sbw) && rpz < (double)sbw) {
                    return src.field_72310_e;
                }
                if (rpy > rpz) {
                    if (rpy > -rpz) {
                        return 1;
                    }
                    return 2;
                }
                if (rpy > -rpz) {
                    return 3;
                }
                return 0;
            }
        }
        return tr;
    }

    public static int extractCoverAxis(MovingObjectPosition src) {
        switch (src.field_72310_e) {
            case 0: {
                return 0;
            }
            case 1: {
                return src.field_72307_f.field_72448_b - (double)src.field_72312_c > 0.5 ? 1 : 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return src.field_72307_f.field_72449_c - (double)src.field_72309_d > 0.5 ? 1 : 0;
            }
        }
        return src.field_72307_f.field_72450_a - (double)src.field_72311_b > 0.5 ? 1 : 0;
    }

    private static void stepDir(MovingObjectPosition mop) {
        switch (mop.field_72310_e) {
            case 0: {
                --mop.field_72312_c;
                break;
            }
            case 1: {
                ++mop.field_72312_c;
                break;
            }
            case 2: {
                --mop.field_72309_d;
                break;
            }
            case 3: {
                ++mop.field_72309_d;
                break;
            }
            case 4: {
                --mop.field_72311_b;
                break;
            }
            default: {
                ++mop.field_72311_b;
            }
        }
    }

    private static boolean isClickOutside(MovingObjectPosition mop) {
        if (mop.subHit < 0) {
            return true;
        }
        if (mop.subHit < 6) {
            return mop.field_72310_e != (mop.subHit ^ 1);
        }
        if (mop.subHit < 14) {
            int fc = mop.subHit - 6;
            return ((mop.field_72310_e ^ (fc = fc >> 2 | (fc & 3) << 1) >> (mop.field_72310_e >> 1)) & 1) == 0;
        }
        if (mop.subHit < 26) {
            int fc = mop.subHit - 14;
            return ((fc = CoverLib.stripToCoverMask(fc)) & 1 << (mop.field_72310_e ^ 1)) <= 0;
        }
        return mop.subHit < 29 || mop.subHit == 29;
    }

    public static MovingObjectPosition getPlacement(World world, MovingObjectPosition src, int item) {
        MovingObjectPosition tr = new MovingObjectPosition(src.field_72311_b, src.field_72312_c, src.field_72309_d, src.field_72310_e, src.field_72307_f);
        int cval = CoverLib.damageToCoverValue(item);
        switch (item >> 8) {
            case 0: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                int dir = CoverLib.extractCoverSide(src);
                if (dir != tr.field_72310_e) {
                    tr.subHit = dir;
                    if (!CoverLib.isClickOutside(src) && CoverLib.canAddCover(world, tr, cval)) {
                        return tr;
                    }
                    CoverLib.stepDir(tr);
                    if (CoverLib.canAddCover(world, tr, cval)) {
                        return tr;
                    }
                    return null;
                }
                if (!CoverLib.isClickOutside(src)) {
                    tr.subHit = dir ^ 1;
                    if (CoverLib.canAddCover(world, tr, cval)) {
                        return tr;
                    }
                }
                tr.subHit = dir;
                if (CoverLib.canAddCover(world, tr, cval)) {
                    return tr;
                }
                if (!CoverLib.isClickOutside(src)) {
                    return null;
                }
                CoverLib.stepDir(tr);
                tr.subHit = dir ^ 1;
                if (CoverLib.canAddCover(world, tr, cval)) {
                    return tr;
                }
                return null;
            }
            default: {
                return null;
            }
            case 18: 
            case 19: 
            case 20: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                int dir2;
                double rpx = src.field_72307_f.field_72450_a - (double)src.field_72311_b;
                double rpy = src.field_72307_f.field_72448_b - (double)src.field_72312_c;
                double rpz = src.field_72307_f.field_72449_c - (double)src.field_72309_d;
                int dir = 0;
                if (rpz > 0.5) {
                    ++dir;
                }
                if (rpx > 0.5) {
                    dir += 2;
                }
                if (rpy > 0.5) {
                    dir += 4;
                }
                switch (src.field_72310_e) {
                    case 0: {
                        dir &= 3;
                        break;
                    }
                    case 1: {
                        dir |= 4;
                        break;
                    }
                    case 2: {
                        dir &= 6;
                        break;
                    }
                    case 3: {
                        dir |= 1;
                        break;
                    }
                    case 4: {
                        dir &= 5;
                        break;
                    }
                    default: {
                        dir |= 2;
                    }
                }
                switch (src.field_72310_e) {
                    case 0: 
                    case 1: {
                        dir2 = dir ^ 4;
                        break;
                    }
                    case 2: 
                    case 3: {
                        dir2 = dir ^ 1;
                        break;
                    }
                    default: {
                        dir2 = dir ^ 2;
                    }
                }
                if (CoverLib.isClickOutside(src)) {
                    tr.subHit = dir2 + 6;
                    CoverLib.stepDir(tr);
                    if (CoverLib.canAddCover(world, tr, cval)) {
                        return tr;
                    }
                    return null;
                }
                tr.subHit = dir2 + 6;
                if (CoverLib.canAddCover(world, tr, cval)) {
                    return tr;
                }
                tr.subHit = dir + 6;
                if (CoverLib.canAddCover(world, tr, cval)) {
                    return tr;
                }
                return null;
            }
            case 21: 
            case 22: 
            case 23: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                int dir = CoverLib.extractCoverSide(src);
                if (dir == tr.field_72310_e) {
                    return null;
                }
                int csm = CoverLib.coverToStripMask(dir);
                if (!CoverLib.isClickOutside(src)) {
                    int csm2 = csm & CoverLib.coverToStripMask(tr.field_72310_e ^ 1);
                    tr.subHit = 14 + Integer.numberOfTrailingZeros(csm2);
                    if (CoverLib.canAddCover(world, tr, cval)) {
                        return tr;
                    }
                    csm2 = csm & CoverLib.coverToStripMask(tr.field_72310_e);
                    tr.subHit = 14 + Integer.numberOfTrailingZeros(csm2);
                    if (CoverLib.canAddCover(world, tr, cval)) {
                        return tr;
                    }
                    return null;
                }
                CoverLib.stepDir(tr);
                int csm2 = csm & CoverLib.coverToStripMask(tr.field_72310_e ^ 1);
                tr.subHit = 14 + Integer.numberOfTrailingZeros(csm2);
                if (CoverLib.canAddCover(world, tr, cval)) {
                    return tr;
                }
                return null;
            }
            case 43: 
            case 44: 
            case 45: 
        }
        int dir = CoverLib.extractCoverSide(src);
        if (dir != tr.field_72310_e && dir != (tr.field_72310_e ^ 1)) {
            return null;
        }
        if (CoverLib.isClickOutside(src)) {
            CoverLib.stepDir(tr);
        }
        tr.subHit = (dir >> 1) + 26;
        return CoverLib.canAddCover(world, tr, cval) ? tr : null;
    }

    public static void replaceWithCovers(World world, int x, int y, int z, int sides, short[] covers) {
        if (blockCoverPlate != null && sides != 0) {
            world.func_147465_d(x, y, z, blockCoverPlate, 0, 3);
            TileCovered tc = CoreLib.getTileEntity((IBlockAccess)world, x, y, z, TileCovered.class);
            if (tc != null) {
                tc.CoverSides = sides;
                tc.Covers = covers;
                RedPowerLib.updateIndirectNeighbors(world, x, y, z, blockCoverPlate);
                tc.updateBlock();
            }
        }
    }

    public static boolean tryMakeCompatible(World world, WorldCoord wc, Block bid, int dmg) {
        TileCovered tc = CoreLib.getTileEntity((IBlockAccess)world, wc, TileCovered.class);
        if (tc == null) {
            return false;
        }
        int hb = dmg >> 8;
        int lb = dmg & 0xFF;
        int xid = tc.getExtendedID();
        if (xid == hb) {
            return tc.getExtendedMetadata() == lb;
        }
        if (xid != 0) {
            return false;
        }
        short[] covs = tc.Covers;
        int cs = tc.CoverSides;
        if (!world.func_147465_d(wc.x, wc.y, wc.z, bid, hb, 3)) {
            return false;
        }
        tc = CoreLib.getTileEntity((IBlockAccess)world, wc, TileCovered.class);
        if (tc == null) {
            return true;
        }
        tc.Covers = covs;
        tc.CoverSides = cs;
        tc.setExtendedMetadata(lb);
        return true;
    }

    public static ItemStack getItemStack(int n) {
        return materials[n];
    }

    public static Block getBlock(int n) {
        ItemStack ist = materials[n];
        return Block.func_149634_a((Item)ist.func_77973_b());
    }

    public static int getMeta(int n) {
        ItemStack ist = materials[n];
        return ist.func_77960_j();
    }

    public static String getName(int n) {
        return names[n];
    }

    public static int getHardness(int n) {
        return hardness[n];
    }

    public static float getMiningHardness(int n) {
        return miningHardness[n];
    }

    public static boolean isTransparent(int n) {
        return transparency[n];
    }

    private static class PlacementValidator {
        public int sidemask = 0;
        public int cornermask = 0;
        public int fillcornermask = 0;
        public int hollowcornermask = 0;
        public int thickfaces = 0;
        public int covm;
        public short[] covs;
        public int[] quanta = new int[29];

        public PlacementValidator(int cm, short[] cs) {
            this.covm = cm;
            this.covs = cs;
        }

        public boolean checkThickFace(int type) {
            for (int i = 0; i < 6; ++i) {
                if ((this.covm & 1 << i) == 0 || this.covs[i] >> 8 != type) continue;
                int t = CoverLib.coverToCornerMask(i);
                if ((this.fillcornermask & t) > 0) {
                    return false;
                }
                this.fillcornermask |= t;
                this.sidemask |= CoverLib.coverToStripMask(i);
            }
            return true;
        }

        public boolean checkThickSide(int type) {
            for (int i = 0; i < 12; ++i) {
                if ((this.covm & 1 << i + 14) == 0 || this.covs[i + 14] >> 8 != type) continue;
                int t = CoverLib.stripToCornerMask(i);
                if ((this.fillcornermask & t) > 0) {
                    return false;
                }
                this.fillcornermask |= t;
                this.sidemask |= 1 << i;
            }
            return true;
        }

        public boolean checkThickCorner(int type) {
            for (int i = 0; i < 8; ++i) {
                if ((this.covm & 1 << i + 6) == 0 || this.covs[i + 6] >> 8 != type) continue;
                int t = 1 << i;
                if ((this.fillcornermask & t) == t) {
                    return false;
                }
                this.fillcornermask |= t;
            }
            return true;
        }

        public boolean checkFace(int type) {
            for (int i = 0; i < 6; ++i) {
                if ((this.covm & 1 << i) == 0 || this.covs[i] >> 8 != type) continue;
                int t = CoverLib.coverToCornerMask(i);
                if ((this.fillcornermask & t) == t) {
                    return false;
                }
                this.cornermask |= t;
                this.sidemask |= CoverLib.coverToStripMask(i);
            }
            return true;
        }

        public boolean checkSide(int type) {
            for (int i = 0; i < 12; ++i) {
                if ((this.covm & 1 << i + 14) == 0 || this.covs[i + 14] >> 8 != type) continue;
                int t = CoverLib.stripToCornerMask(i);
                if ((this.fillcornermask & t) == t) {
                    return false;
                }
                if ((this.sidemask & 1 << i) > 0) {
                    return false;
                }
                this.cornermask |= t;
                this.sidemask |= 1 << i;
            }
            return true;
        }

        public boolean checkCorner(int type) {
            for (int i = 0; i < 8; ++i) {
                if ((this.covm & 1 << i + 6) == 0 || this.covs[i + 6] >> 8 != type) continue;
                int t = 1 << i;
                if ((this.cornermask & t) == t) {
                    return false;
                }
                this.cornermask |= t;
            }
            return true;
        }

        public boolean checkHollow(int type) {
            for (int i = 0; i < 6; ++i) {
                if ((this.covm & 1 << i) == 0 || this.covs[i] >> 8 != type) continue;
                int t = CoverLib.coverToCornerMask(i);
                if ((this.cornermask & t) > 0) {
                    return false;
                }
                this.cornermask |= t;
                this.hollowcornermask |= t;
                t = CoverLib.coverToStripMask(i);
                if ((this.sidemask & t) > 0) {
                    return false;
                }
                this.sidemask |= t;
            }
            return true;
        }

        public boolean checkHollowCover(int type) {
            int ocm = 0;
            int osm = 0;
            for (int i = 0; i < 6; ++i) {
                if ((this.covm & 1 << i) == 0 || this.covs[i] >> 8 != type) continue;
                int t = CoverLib.coverToCornerMask(i);
                if ((this.cornermask & t) > 0) {
                    return false;
                }
                ocm |= t;
                t = CoverLib.coverToStripMask(i);
                if ((this.sidemask & t) > 0) {
                    return false;
                }
                osm |= t;
            }
            this.cornermask |= ocm;
            this.sidemask |= osm;
            return true;
        }

        public void calcQuanta() {
            for (int i = 0; i < 29; ++i) {
                this.quanta[i] = (this.covm & 1 << i) == 0 ? 0 : CoverLib.getThicknessQuanta(i, this.covs[i]);
            }
        }

        private boolean checkOverlap(int a, int b, int c, int d) {
            a = this.quanta[a];
            b = this.quanta[b];
            c = this.quanta[c];
            d = this.quanta[d];
            return a + b > 8 || a + c > 8 || a + d > 8 || b + c > 8 || b + d > 8 || c + d > 8;
        }

        public boolean checkImpingement() {
            int q21;
            int q2;
            int j;
            int q1;
            for (int i = 0; i < 6; i += 2) {
                if (this.quanta[i] + this.quanta[i + 1] <= 8) continue;
                return false;
            }
            if (this.checkOverlap(14, 15, 22, 23)) {
                return false;
            }
            if (this.checkOverlap(16, 17, 24, 25)) {
                return false;
            }
            if (this.checkOverlap(18, 19, 20, 22)) {
                return false;
            }
            if (this.checkOverlap(6, 7, 8, 9)) {
                return false;
            }
            if (this.checkOverlap(10, 11, 12, 13)) {
                return false;
            }
            if (this.checkOverlap(6, 8, 10, 12)) {
                return false;
            }
            if (this.checkOverlap(7, 9, 11, 13)) {
                return false;
            }
            if (this.checkOverlap(6, 7, 10, 11)) {
                return false;
            }
            if (this.checkOverlap(8, 9, 12, 13)) {
                return false;
            }
            for (int var8 = 0; var8 < 6; ++var8) {
                int q22;
                q1 = this.quanta[var8];
                if (q1 == 0) continue;
                j = CoverLib.coverToCornerMask(var8);
                q2 = CoverLib.coverToStripMask(var8);
                q21 = CoverLib.coverToStripMask(var8 ^ 1);
                for (int j1 = 0; j1 < 8; ++j1) {
                    q22 = this.quanta[6 + j1];
                    if (!((j & 1 << j1) == 0 ? q1 + q22 > 8 : q22 > 0 && q22 < q1)) continue;
                    return false;
                }
                for (int var21 = 0; var21 < 12; ++var21) {
                    q22 = this.quanta[14 + var21];
                    if (!((q21 & 1 << var21) > 0 ? q1 + q22 > 8 : (q2 & 1 << var21) > 0 && q22 > 0 && q22 < q1)) continue;
                    return false;
                }
            }
            for (int var9 = 0; var9 < 12; ++var9) {
                q1 = this.quanta[14 + var9];
                if (q1 == 0) continue;
                j = CoverLib.stripToCornerMask(var9);
                for (q2 = 0; q2 < 8; ++q2) {
                    q21 = this.quanta[6 + q2];
                    if (!((j & 1 << q2) == 0 ? q1 + q21 > 8 : q21 > 0 && q21 < q1)) continue;
                    return false;
                }
            }
            for (int var10 = 0; var10 < 3; ++var10) {
                q1 = this.quanta[26 + var10];
                if (q1 == 0) continue;
                for (j = 0; j < 8; ++j) {
                    q2 = this.quanta[6 + j];
                    if (q1 + q2 <= 4) continue;
                    return false;
                }
                for (int var15 = 0; var15 < 12; ++var15) {
                    q2 = this.quanta[14 + var15];
                    if (q1 + q2 <= 4) continue;
                    return false;
                }
                for (int var16 = 0; var16 < 6; ++var16) {
                    if (var16 >> 1 == var10 || this.quanta[var16] + q1 <= 4) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean checkPlacement(int cons, boolean jacket) {
            this.calcQuanta();
            if (!this.checkImpingement()) {
                return false;
            }
            if (!this.checkThickFace(9)) {
                return false;
            }
            if (!this.checkThickSide(6)) {
                return false;
            }
            if (!this.checkThickCorner(6)) {
                return false;
            }
            if (!this.checkThickFace(8)) {
                return false;
            }
            if (!this.checkThickSide(5)) {
                return false;
            }
            if (!this.checkThickCorner(5)) {
                return false;
            }
            if (!this.checkThickFace(7)) {
                return false;
            }
            if (!this.checkThickSide(4)) {
                return false;
            }
            if (!this.checkThickCorner(4)) {
                return false;
            }
            if (this.cornermask > 0 && cons > 0) {
                return false;
            }
            if (!this.checkThickFace(2)) {
                return false;
            }
            if (!this.checkThickSide(2)) {
                return false;
            }
            if (!this.checkThickCorner(2)) {
                return false;
            }
            this.cornermask = this.fillcornermask;
            if (!this.checkFace(6)) {
                return false;
            }
            if (!this.checkSide(3)) {
                return false;
            }
            if (!this.checkCorner(3)) {
                return false;
            }
            if ((this.covm & 0x1C000000) > 0) {
                if (jacket) {
                    return false;
                }
                if (cons > 0) {
                    return false;
                }
            }
            for (int i = 0; i < 6; ++i) {
                if ((cons & 1 << i) == 0 || (this.cornermask & CoverLib.coverToCornerMask(i)) <= 0) continue;
                return false;
            }
            if (!this.checkFace(1)) {
                return false;
            }
            if (!this.checkSide(1)) {
                return false;
            }
            if (!this.checkCorner(1)) {
                return false;
            }
            if (!jacket || this.cornermask <= 0 && this.sidemask <= 0) {
                if (!this.checkHollow(13)) {
                    return false;
                }
                if (!this.checkHollow(12)) {
                    return false;
                }
                if (!this.checkHollow(11)) {
                    return false;
                }
                if (!this.checkHollow(10)) {
                    return false;
                }
                if (!this.checkHollow(5)) {
                    return false;
                }
                for (int var5 = 0; var5 < 6; ++var5) {
                    if ((cons & 1 << var5) == 0 || (this.hollowcornermask & CoverLib.coverToCornerMask(var5)) <= 0) continue;
                    return false;
                }
                if (!this.checkHollow(4)) {
                    return false;
                }
                if (!this.checkHollowCover(3)) {
                    return false;
                }
                if (!this.checkFace(0)) {
                    return false;
                }
                if (!this.checkSide(0)) {
                    return false;
                }
                if (!this.checkCorner(0)) {
                    return false;
                }
                for (int var6 = 0; var6 < 12; ++var6) {
                    int t;
                    if ((this.covm & 1 << var6 + 14) == 0 || (cons & (t = CoverLib.stripToCoverMask(var6))) != t) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static interface IMaterialHandler {
        public void addMaterial(int var1);
    }
}

