/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class FluidBuffer {
    public Fluid Type;
    public int Level;
    public int Delta;
    private int lastTick;

    public abstract TileEntity getParent();

    public abstract void onChange();

    public int getMaxLevel() {
        return 1000;
    }

    public int getLevel() {
        long lt = this.getParent().func_145831_w().func_82737_E();
        if ((lt & 0xFFFFL) == (long)this.lastTick) {
            return this.Level;
        }
        this.lastTick = (int)(lt & 0xFFFFL);
        this.Level += this.Delta;
        this.Delta = 0;
        if (this.Level == 0) {
            this.Type = null;
        }
        return this.Level;
    }

    public void addLevel(Fluid type, int lvl) {
        if (type != null) {
            this.Type = type;
            this.Delta += lvl;
            this.onChange();
        }
    }

    public Fluid getFluidClass() {
        return this.Type;
    }

    public void readFromNBT(NBTTagCompound tag, String name) {
        NBTTagCompound t2 = tag.func_74775_l(name);
        this.Type = FluidRegistry.getFluid((String)t2.func_74779_i("type"));
        this.Level = t2.func_74765_d("lvl");
        this.Delta = t2.func_74765_d("del");
        this.lastTick = t2.func_74765_d("ltk");
    }

    public void writeToNBT(NBTTagCompound tag, String name) {
        NBTTagCompound t2 = new NBTTagCompound();
        String n = FluidRegistry.getFluidName((Fluid)this.Type);
        t2.func_74778_a("type", n != null && !n.isEmpty() ? n : "null");
        t2.func_74777_a("lvl", (short)this.Level);
        t2.func_74777_a("del", (short)this.Delta);
        t2.func_74777_a("ltk", (short)this.lastTick);
        tag.func_74782_a(name, (NBTBase)t2);
    }

    public void writeToPacket(NBTTagCompound tag) {
        tag.func_74768_a("type", this.Type == null ? -1 : FluidRegistry.getFluidID((Fluid)this.Type));
        tag.func_74768_a("lvl", this.Level);
    }

    public void readFromPacket(NBTTagCompound buffer) {
        this.Type = FluidRegistry.getFluid((int)buffer.func_74762_e("type"));
        this.Level = buffer.func_74762_e("lvl");
    }
}

