/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.IFrameLink;
import com.eloraam.redpower.core.WorldCoord;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FrameLib {

    public static class FrameSolver {
        private HashSet<WorldCoord> scanmap = new HashSet();
        private LinkedList<WorldCoord> scanpos = new LinkedList();
        private HashSet<WorldCoord> framemap = new HashSet();
        private LinkedList<WorldCoord> frameset = new LinkedList();
        private LinkedList<WorldCoord> clearset = new LinkedList();
        private int movedir;
        private WorldCoord motorpos;
        private boolean valid = true;
        private World world;

        public FrameSolver(World world, WorldCoord wc, WorldCoord motorp, int movdir) {
            this.movedir = movdir;
            this.motorpos = motorp;
            this.world = world;
            this.scanmap.add(motorp);
            this.scanmap.add(wc);
            this.scanpos.addLast(wc);
        }

        private boolean step() {
            WorldCoord wc = this.scanpos.removeFirst();
            if (wc.y >= 0 && wc.y < this.world.func_72800_K() - 1) {
                Block block = this.world.func_147439_a(wc.x, wc.y, wc.z);
                if (this.movedir >= 0 && !this.world.func_72899_e(wc.x, wc.y, wc.z)) {
                    this.valid = false;
                    return false;
                }
                if (this.world.func_147437_c(wc.x, wc.y, wc.z)) {
                    return false;
                }
                if (this.movedir >= 0 && block.func_149712_f(this.world, wc.x, wc.y, wc.z) < 0.0f) {
                    this.valid = false;
                    return false;
                }
                this.framemap.add(wc);
                this.frameset.addLast(wc);
                IFrameLink ifl = CoreLib.getTileEntity((IBlockAccess)this.world, wc, IFrameLink.class);
                if (ifl == null) {
                    return true;
                }
                if (ifl.isFrameMoving() && this.movedir >= 0) {
                    this.valid = false;
                    return true;
                }
                for (int i = 0; i < 6; ++i) {
                    WorldCoord wcls;
                    IFrameLink if2;
                    WorldCoord sp;
                    if (!ifl.canFrameConnectOut(i) || this.scanmap.contains(sp = wc.coordStep(i)) || (if2 = CoreLib.getTileEntity((IBlockAccess)this.world, sp, IFrameLink.class)) != null && (!if2.canFrameConnectIn((i ^ 1) & 0xFF) || this.movedir < 0 && ((wcls = if2.getFrameLinkset()) == null || !wcls.equals(this.motorpos)))) continue;
                    this.scanmap.add(sp);
                    this.scanpos.addLast(sp);
                }
                return true;
            }
            return false;
        }

        public boolean solve() {
            while (this.valid && this.scanpos.size() > 0) {
                this.step();
            }
            return this.valid;
        }

        public boolean solveLimit(int limit) {
            while (this.valid && this.scanpos.size() > 0) {
                if (this.step()) {
                    --limit;
                }
                if (limit != 0) continue;
                return false;
            }
            return this.valid;
        }

        public boolean addMoved() {
            for (WorldCoord wc : (LinkedList)this.frameset.clone()) {
                WorldCoord sp = wc.coordStep(this.movedir);
                if (!this.world.func_72899_e(sp.x, sp.y, sp.z)) {
                    this.valid = false;
                    return false;
                }
                if (this.framemap.contains(sp)) continue;
                if (!this.world.func_147437_c(wc.x, wc.y, wc.z)) {
                    if (!this.world.func_147472_a(Blocks.field_150348_b, sp.x, sp.y, sp.z, true, 0, null, null)) {
                        this.valid = false;
                        return false;
                    }
                    this.clearset.add(sp);
                }
                this.framemap.add(sp);
                this.frameset.addLast(sp);
            }
            return this.valid;
        }

        public void sort(int dir) {
            this.frameset.sort(WorldCoord.getCompareDir(dir));
        }

        public LinkedList<WorldCoord> getFrameSet() {
            return this.frameset;
        }

        public LinkedList<WorldCoord> getClearSet() {
            return this.clearset;
        }
    }
}

