/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.ITubeConnectable;
import com.eloraam.redpower.core.TubeItem;
import com.eloraam.redpower.core.TubeLib;
import com.eloraam.redpower.core.WorldCoord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MachineLib {
    public static IInventory getInventory(World world, WorldCoord wc) {
        IInventory inv = CoreLib.getTileEntity((IBlockAccess)world, wc, IInventory.class);
        if (!(inv instanceof TileEntityChest)) {
            return inv;
        }
        TileEntityChest tec = CoreLib.getTileEntity((IBlockAccess)world, wc.x - 1, wc.y, wc.z, TileEntityChest.class);
        if (tec != null) {
            return new InventoryLargeChest("Large chest", (IInventory)tec, inv);
        }
        tec = CoreLib.getTileEntity((IBlockAccess)world, wc.x + 1, wc.y, wc.z, TileEntityChest.class);
        if (tec != null) {
            return new InventoryLargeChest("Large chest", inv, (IInventory)tec);
        }
        tec = CoreLib.getTileEntity((IBlockAccess)world, wc.x, wc.y, wc.z - 1, TileEntityChest.class);
        if (tec != null) {
            return new InventoryLargeChest("Large chest", (IInventory)tec, inv);
        }
        tec = CoreLib.getTileEntity((IBlockAccess)world, wc.x, wc.y, wc.z + 1, TileEntityChest.class);
        return tec != null ? new InventoryLargeChest("Large chest", inv, (IInventory)tec) : inv;
    }

    public static IInventory getSideInventory(World world, WorldCoord wc, int side, boolean push) {
        IInventory inv = MachineLib.getInventory(world, wc);
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            ISidedInventory isi = (ISidedInventory)inv;
            int[] slots = isi.func_94128_d(side);
            return new SubInventory(inv, slots);
        }
        return inv;
    }

    public static boolean addToInventoryCore(World world, ItemStack ist, WorldCoord wc, int side, boolean act) {
        int[] slots;
        IInventory inv = MachineLib.getInventory(world, wc);
        if (inv == null) {
            return false;
        }
        if (inv instanceof ISidedInventory) {
            ISidedInventory isi = (ISidedInventory)inv;
            slots = isi.func_94128_d(side);
            if (slots == null || slots.length == 0) {
                return false;
            }
            int[] var8 = slots;
            int var9 = slots.length;
            int var10 = 0;
            while (true) {
                if (var10 >= var9) {
                    return false;
                }
                int n = var8[var10];
                if (!isi.func_102007_a(n, ist, side)) {
                    ++var10;
                    continue;
                }
                break;
            }
        } else {
            slots = IntStream.range(0, inv.func_70302_i_()).toArray();
        }
        return MachineLib.addToInventoryCore(inv, ist, slots, act);
    }

    public static boolean addToInventoryCore(IInventory inv, ItemStack ist, int[] slots, boolean act) {
        ItemStack invst;
        for (int n : slots) {
            invst = inv.func_70301_a(n);
            if (invst != null) {
                if (!ist.func_77969_a(invst) || !ItemStack.func_77970_a((ItemStack)ist, (ItemStack)invst)) continue;
                int dfs = Math.min(invst.func_77976_d(), inv.func_70297_j_());
                if ((dfs -= invst.field_77994_a) <= 0) continue;
                int si = Math.min(dfs, ist.field_77994_a);
                if (!act) {
                    return true;
                }
                invst.field_77994_a += si;
                inv.func_70299_a(n, invst);
                ist.field_77994_a -= si;
                if (ist.field_77994_a != 0) continue;
                return true;
            }
            if (act) continue;
            return true;
        }
        if (!act) {
            return false;
        }
        for (int n : slots) {
            invst = inv.func_70301_a(n);
            if (invst != null) continue;
            if (inv.func_70297_j_() >= ist.field_77994_a) {
                inv.func_70299_a(n, ist);
                return true;
            }
            inv.func_70299_a(n, ist.func_77979_a(inv.func_70297_j_()));
        }
        return false;
    }

    public static boolean addToInventory(World world, ItemStack ist, WorldCoord wc, int side) {
        return MachineLib.addToInventoryCore(world, ist, wc, side, true);
    }

    public static boolean canAddToInventory(World world, ItemStack ist, WorldCoord wc, int side) {
        return MachineLib.addToInventoryCore(world, ist, wc, side, false);
    }

    public static void ejectItem(World world, WorldCoord wc, ItemStack ist, int dir) {
        wc = wc.copy();
        wc.step(dir);
        EntityItem item = new EntityItem(world, (double)wc.x + 0.5, (double)wc.y + 0.5, (double)wc.z + 0.5, ist);
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0;
        item.field_70179_y = 0.0;
        switch (dir) {
            case 0: {
                item.field_70181_x = -0.3;
                break;
            }
            case 1: {
                item.field_70181_x = 0.3;
                break;
            }
            case 2: {
                item.field_70179_y = -0.3;
                break;
            }
            case 3: {
                item.field_70179_y = 0.3;
                break;
            }
            case 4: {
                item.field_70159_w = -0.3;
                break;
            }
            default: {
                item.field_70159_w = 0.3;
            }
        }
        item.field_145804_b = 10;
        world.func_72838_d((Entity)item);
    }

    public static boolean handleItem(World world, ItemStack ist, WorldCoord wc, int side) {
        WorldCoord dest = wc.copy();
        dest.step(side);
        if (ist.field_77994_a == 0) {
            return true;
        }
        if (TubeLib.addToTubeRoute(world, ist, wc, dest, side ^ 1)) {
            return true;
        }
        if (MachineLib.addToInventory(world, ist, dest, (side ^ 1) & 0x3F)) {
            return true;
        }
        TileEntity te = CoreLib.getTileEntity((IBlockAccess)world, dest, TileEntity.class);
        if (!(te instanceof IInventory) && !(te instanceof ITubeConnectable)) {
            if (world.func_147439_a(dest.x, dest.y, dest.z).isSideSolid((IBlockAccess)world, dest.x, dest.y, dest.z, ForgeDirection.getOrientation((int)(side ^ 1)))) {
                return false;
            }
            MachineLib.ejectItem(world, wc, ist, side);
            return true;
        }
        return false;
    }

    public static boolean handleItem(World world, TubeItem ti, WorldCoord wc, int side) {
        WorldCoord dest = wc.copy();
        dest.step(side);
        if (ti.item.field_77994_a == 0) {
            return true;
        }
        if (TubeLib.addToTubeRoute(world, ti, wc, dest, side ^ 1)) {
            return true;
        }
        if (MachineLib.addToInventory(world, ti.item, dest, (side ^ 1) & 0x3F)) {
            return true;
        }
        TileEntity te = CoreLib.getTileEntity((IBlockAccess)world, dest, TileEntity.class);
        if (!(te instanceof IInventory) && !(te instanceof ITubeConnectable)) {
            if (world.func_147439_a(dest.x, dest.y, dest.z).isSideSolid((IBlockAccess)world, dest.x, dest.y, dest.z, ForgeDirection.getOrientation((int)(side ^ 1)))) {
                return false;
            }
            MachineLib.ejectItem(world, wc, ti.item, side);
            return true;
        }
        return false;
    }

    public static int compareItem(ItemStack a, ItemStack b) {
        int d1;
        if (Item.func_150891_b((Item)a.func_77973_b()) != Item.func_150891_b((Item)b.func_77973_b())) {
            return Item.func_150891_b((Item)a.func_77973_b()) - Item.func_150891_b((Item)b.func_77973_b());
        }
        if (a.func_77960_j() == b.func_77960_j()) {
            return 0;
        }
        if (a.func_77973_b().func_77614_k()) {
            return a.func_77960_j() - b.func_77960_j();
        }
        int n = a.func_77960_j() <= 1 ? -1 : (d1 = a.func_77960_j() == a.func_77958_k() - 1 ? 1 : 0);
        int d2 = b.func_77960_j() <= 1 ? -1 : (b.func_77960_j() == b.func_77958_k() - 1 ? 1 : 0);
        return d1 - d2;
    }

    public static FilterMap makeFilterMap(ItemStack[] ist) {
        return new FilterMap(ist);
    }

    public static FilterMap makeFilterMap(ItemStack[] ist, int st, int ln) {
        ItemStack[] it = new ItemStack[ln];
        System.arraycopy(ist, st, it, 0, ln);
        return new FilterMap(it);
    }

    public static int[] genMatchCounts(FilterMap map) {
        int[] tr = new int[map.filter.length];
        for (int n = 0; n < map.filter.length; ++n) {
            List arl;
            ItemStack ist = map.filter[n];
            if (ist == null || ist.field_77994_a == 0 || (arl = (List)map.map.get(ist)) == null || (Integer)arl.get(0) != n) continue;
            Iterator iterator = arl.iterator();
            while (iterator.hasNext()) {
                int m = (Integer)iterator.next();
                int n2 = n;
                tr[n2] = tr[n2] + map.filter[m].field_77994_a;
            }
        }
        return tr;
    }

    public static int decMatchCount(FilterMap map, int[] mc, ItemStack ist) {
        List arl = map.map.get(ist);
        if (arl == null) {
            return 0;
        }
        int n = (Integer)arl.get(0);
        int tr = Math.min(mc[n], ist.field_77994_a);
        int n2 = n;
        mc[n2] = mc[n2] - tr;
        return tr;
    }

    public static int getMatchCount(FilterMap map, int[] mc, ItemStack ist) {
        List arl = map.map.get(ist);
        if (arl == null) {
            return 0;
        }
        int n = (Integer)arl.get(0);
        return Math.min(mc[n], ist.field_77994_a);
    }

    public static boolean isMatchEmpty(int[] mc) {
        for (int i : mc) {
            if (i <= 0) continue;
            return false;
        }
        return true;
    }

    public static void decMatchCounts(FilterMap map, int[] mc, IInventory inv, int[] slots) {
        for (int n : slots) {
            ItemStack ist = inv.func_70301_a(n);
            if (ist == null || ist.field_77994_a == 0) continue;
            MachineLib.decMatchCount(map, mc, ist);
        }
    }

    public static boolean matchOneStack(FilterMap map, IInventory inv, int[] slots, int pos) {
        ItemStack match = map.filter[pos];
        int fc = match == null ? 1 : match.field_77994_a;
        for (int n : slots) {
            int m;
            ItemStack ist = inv.func_70301_a(n);
            if (ist == null || ist.field_77994_a == 0) continue;
            if (match == null) {
                return true;
            }
            if (MachineLib.compareItem(match, ist) != 0 || (fc -= (m = Math.min(ist.field_77994_a, fc))) > 0) continue;
            return true;
        }
        return false;
    }

    public static int matchAnyStack(FilterMap map, IInventory inv, int[] slots) {
        int[] mc = new int[map.filter.length];
        for (int n : slots) {
            List arl;
            ItemStack ist = inv.func_70301_a(n);
            if (ist == null || ist.field_77994_a == 0 || (arl = (List)map.map.get(ist)) == null) continue;
            Iterator iterator = arl.iterator();
            while (iterator.hasNext()) {
                int m;
                int n2 = m = ((Integer)iterator.next()).intValue();
                mc[n2] = mc[n2] + ist.field_77994_a;
                if (mc[m] < map.filter[m].field_77994_a) continue;
                return m;
            }
        }
        return -1;
    }

    public static int matchAnyStackCol(FilterMap map, IInventory inv, int[] slots, int col) {
        int[] mc = new int[5];
        for (int n : slots) {
            List arl;
            ItemStack ist = inv.func_70301_a(n);
            if (ist == null || ist.field_77994_a == 0 || (arl = (List)map.map.get(ist)) == null) continue;
            for (Integer m : arl) {
                int s;
                if ((m & 7) != col) continue;
                int n2 = s = m >> 3;
                mc[n2] = mc[n2] + ist.field_77994_a;
                if (mc[s] < map.filter[m.intValue()].field_77994_a) continue;
                return m;
            }
        }
        return -1;
    }

    public static boolean matchAllCol(FilterMap map, IInventory inv, int[] slots, int col) {
        int[] mc = new int[5];
        block0: for (int any : slots) {
            ArrayList<Integer> ct;
            ItemStack n = inv.func_70301_a(any);
            if (n == null || n.field_77994_a == 0 || (ct = map.map.get(n)) == null) continue;
            int ss = n.field_77994_a;
            for (Integer m : ct) {
                if ((m & 7) != col) continue;
                int c = m >> 3;
                int s1 = Math.min(ss, map.filter[m.intValue()].field_77994_a - mc[c]);
                int n2 = c;
                mc[n2] = mc[n2] + s1;
                if ((ss -= s1) != 0) continue;
                continue block0;
            }
        }
        boolean match = false;
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = map.filter[i * 8 + col];
            if (stack == null || stack.field_77994_a == 0) continue;
            match = true;
            if (stack.field_77994_a <= mc[i]) continue;
            return false;
        }
        return match;
    }

    public static boolean emptyInventory(IInventory inv, int[] slots) {
        for (int n : slots) {
            ItemStack ist = inv.func_70301_a(n);
            if (ist == null || ist.field_77994_a == 0) continue;
            return false;
        }
        return true;
    }

    public static ItemStack collectOneStack(IInventory inv, int[] slots, ItemStack match) {
        ItemStack tr = null;
        int fc = match == null ? 1 : match.field_77994_a;
        for (int n : slots) {
            ItemStack ist = inv.func_70301_a(n);
            if (ist == null || ist.field_77994_a == 0) continue;
            if (match == null) {
                inv.func_70299_a(n, null);
                return ist;
            }
            if (MachineLib.compareItem(match, ist) != 0) continue;
            int m = Math.min(ist.field_77994_a, fc);
            if (tr == null) {
                tr = inv.func_70298_a(n, m);
            } else {
                inv.func_70298_a(n, m);
                tr.field_77994_a += m;
            }
            if ((fc -= m) <= 0) break;
        }
        return tr;
    }

    public static ItemStack collectOneStackFuzzy(IInventory inv, int[] slots, ItemStack match) {
        ItemStack tr = null;
        int fc = match == null ? 1 : match.func_77976_d();
        for (int n : slots) {
            ItemStack ist = inv.func_70301_a(n);
            if (ist == null || ist.field_77994_a == 0) continue;
            if (match == null) {
                inv.func_70299_a(n, null);
                return ist;
            }
            if (MachineLib.compareItem(match, ist) != 0) continue;
            int m = Math.min(ist.field_77994_a, fc);
            if (tr == null) {
                tr = inv.func_70298_a(n, m);
            } else {
                inv.func_70298_a(n, m);
                tr.field_77994_a += m;
            }
            if ((fc -= m) <= 0) break;
        }
        return tr;
    }

    public static class SubInventory
    implements IInventory {
        IInventory parent;
        int[] slots;

        SubInventory(IInventory par, int[] sl) {
            this.parent = par;
            this.slots = sl;
        }

        public int func_70302_i_() {
            return this.slots.length;
        }

        public ItemStack func_70301_a(int idx) {
            return ArrayUtils.contains((int[])this.slots, (int)idx) ? this.parent.func_70301_a(idx) : null;
        }

        public ItemStack func_70298_a(int idx, int num) {
            return ArrayUtils.contains((int[])this.slots, (int)idx) ? this.parent.func_70298_a(idx, num) : null;
        }

        public ItemStack func_70304_b(int idx) {
            return ArrayUtils.contains((int[])this.slots, (int)idx) ? this.parent.func_70304_b(idx) : null;
        }

        public void func_70299_a(int idx, ItemStack ist) {
            if (ArrayUtils.contains((int[])this.slots, (int)idx)) {
                this.parent.func_70299_a(idx, ist);
            }
        }

        public String func_145825_b() {
            return this.parent.func_145825_b();
        }

        public int func_70297_j_() {
            return this.parent.func_70297_j_();
        }

        public void func_70296_d() {
            this.parent.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.parent.func_70300_a(player);
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_145818_k_() {
            return this.parent.func_145818_k_();
        }

        public boolean func_94041_b(int slotID, ItemStack stack) {
            return this.parent.func_94041_b(slotID, stack);
        }
    }

    public static class FilterMap {
        protected TreeMap<ItemStack, ArrayList<Integer>> map;
        protected ItemStack[] filter;

        public FilterMap(ItemStack[] filt) {
            this.filter = filt;
            this.map = new TreeMap(MachineLib::compareItem);
            for (int i = 0; i < filt.length; ++i) {
                if (filt[i] == null || filt[i].field_77994_a == 0) continue;
                this.map.computeIfAbsent(filt[i], k -> new ArrayList()).add(i);
            }
        }

        public int size() {
            return this.map.size();
        }

        public boolean containsKey(ItemStack ist) {
            return this.map.containsKey(ist);
        }

        public int firstMatch(ItemStack ist) {
            ArrayList<Integer> arl = this.map.get(ist);
            return arl == null ? -1 : arl.get(0);
        }
    }
}

