/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.FluidBuffer;
import com.eloraam.redpower.core.IPipeConnectable;
import com.eloraam.redpower.core.WorldCoord;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeLib {
    private static boolean isConSide(IBlockAccess iba, int x, int y, int z, int side) {
        IFluidHandler itc;
        FluidTankInfo[] info;
        TileEntity te = iba.func_147438_o(x, y, z);
        if (te instanceof IPipeConnectable) {
            IPipeConnectable itc1 = (IPipeConnectable)te;
            int ilt1 = itc1.getPipeConnectableSides();
            return (ilt1 & 1 << side) > 0;
        }
        if (te instanceof IFluidHandler && (info = (itc = (IFluidHandler)te).getTankInfo(ForgeDirection.getOrientation((int)side))) != null) {
            for (FluidTankInfo i : info) {
                if (i == null || i.capacity <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getConnections(IBlockAccess iba, int x, int y, int z) {
        IPipeConnectable itc = CoreLib.getTileEntity(iba, x, y, z, IPipeConnectable.class);
        if (itc == null) {
            return 0;
        }
        int trs = 0;
        int sides = itc.getPipeConnectableSides();
        if ((sides & 1) > 0 && PipeLib.isConSide(iba, x, y - 1, z, 1)) {
            trs |= 1;
        }
        if ((sides & 2) > 0 && PipeLib.isConSide(iba, x, y + 1, z, 0)) {
            trs |= 2;
        }
        if ((sides & 4) > 0 && PipeLib.isConSide(iba, x, y, z - 1, 3)) {
            trs |= 4;
        }
        if ((sides & 8) > 0 && PipeLib.isConSide(iba, x, y, z + 1, 2)) {
            trs |= 8;
        }
        if ((sides & 0x10) > 0 && PipeLib.isConSide(iba, x - 1, y, z, 5)) {
            trs |= 0x10;
        }
        if ((sides & 0x20) > 0 && PipeLib.isConSide(iba, x + 1, y, z, 4)) {
            trs |= 0x20;
        }
        return trs;
    }

    public static int getFlanges(IBlockAccess iba, WorldCoord wci, int sides) {
        int tr = 0;
        block0: for (int i = 0; i < 6; ++i) {
            FluidTankInfo[] info;
            IPipeConnectable itc;
            if ((sides & 1 << i) == 0) continue;
            WorldCoord wc = wci.copy();
            wc.step(i);
            TileEntity te = iba.func_147438_o(wc.x, wc.y, wc.z);
            if (te == null) continue;
            if (te instanceof IPipeConnectable) {
                itc = (IPipeConnectable)te;
                if ((itc.getPipeFlangeSides() & 1 << (i ^ 1)) <= 0) continue;
                tr |= 1 << i;
                continue;
            }
            if (!(te instanceof IFluidHandler) || (info = (itc = (IFluidHandler)te).getTankInfo(ForgeDirection.getOrientation((int)(i ^ 1)))) == null) continue;
            for (FluidTankInfo inf : info) {
                if (inf == null || inf.capacity <= 0) continue;
                tr |= 1 << i;
                continue block0;
            }
        }
        return tr;
    }

    public static Integer getPressure(World world, WorldCoord wc, int side) {
        TileEntity te = world.func_147438_o(wc.x, wc.y, wc.z);
        if (te != null) {
            IFluidHandler ifh;
            FluidTankInfo[] info;
            if (te instanceof IPipeConnectable) {
                IPipeConnectable itc = (IPipeConnectable)te;
                return itc.getPipePressure(side);
            }
            if (te instanceof IFluidHandler && (info = (ifh = (IFluidHandler)te).getTankInfo(ForgeDirection.getOrientation((int)side))) != null) {
                for (FluidTankInfo i : info) {
                    if (i.fluid == null) continue;
                    return (int)((double)i.fluid.amount / (double)i.capacity * 100.0);
                }
                for (FluidTankInfo i : info) {
                    if (i.capacity <= 0) continue;
                    return -100;
                }
            }
        }
        return null;
    }

    public static Fluid getFluid(World world, WorldCoord wc) {
        Block bl = world.func_147439_a(wc.x, wc.y, wc.z);
        if (bl instanceof IFluidBlock) {
            IFluidBlock fcl = (IFluidBlock)bl;
            return fcl.getFluid();
        }
        if (bl instanceof BlockLiquid) {
            BlockLiquid blq = (BlockLiquid)bl;
            if (blq.func_149688_o() == Material.field_151586_h) {
                return FluidRegistry.WATER;
            }
            if (blq.func_149688_o() == Material.field_151587_i) {
                return FluidRegistry.LAVA;
            }
        }
        return null;
    }

    public static int getFluidAmount(World world, WorldCoord wc) {
        BlockLiquid blq;
        Block bl = world.func_147439_a(wc.x, wc.y, wc.z);
        if (bl instanceof IFluidBlock) {
            IFluidBlock fcl = (IFluidBlock)bl;
            float fp = fcl.getFilledPercentage(world, wc.x, wc.y, wc.z);
            return (int)((float)fcl.getFluid().getDensity() * fp);
        }
        if (bl instanceof BlockLiquid && ((blq = (BlockLiquid)bl).func_149688_o() == Material.field_151586_h || blq.func_149688_o() == Material.field_151587_i)) {
            return 1000;
        }
        return 0;
    }

    public static void movePipeLiquid(World world, IPipeConnectable src, WorldCoord wsrc, int sides) {
        for (int side = 0; side < 6; ++side) {
            FluidTankInfo[] info;
            if ((sides & 1 << side) == 0) continue;
            WorldCoord wc = wsrc.coordStep(side);
            TileEntity te = world.func_147438_o(wc.x, wc.y, wc.z);
            if (te == null) continue;
            if (te instanceof IPipeConnectable) {
                FluidBuffer dstBuffer;
                FluidBuffer srcBuffer;
                int dstPressure;
                IPipeConnectable itc = (IPipeConnectable)te;
                int srcPressure = src.getPipePressure(side);
                if (srcPressure < (dstPressure = itc.getPipePressure(side ^ 1)) || (srcBuffer = src.getPipeBuffer(side)) == null) continue;
                Fluid srcType = srcBuffer.Type;
                int srcLevel = srcBuffer.getLevel() + srcBuffer.Delta;
                if (srcType == null || srcLevel <= 0 || (dstBuffer = itc.getPipeBuffer(side ^ 1)) == null) continue;
                Fluid dstType = dstBuffer.Type;
                int dstLevel = dstBuffer.getLevel();
                if (dstType != null && dstType != srcType) continue;
                int ls = Math.max(srcPressure > dstPressure ? 25 : 0, (srcLevel - dstLevel) / 2);
                if ((ls = Math.min(Math.min(ls, dstBuffer.getMaxLevel() - dstLevel), srcLevel)) <= 0) continue;
                srcBuffer.addLevel(srcType, -ls);
                dstBuffer.addLevel(srcType, ls);
                continue;
            }
            if (!(te instanceof IFluidHandler)) continue;
            IFluidHandler ifh = (IFluidHandler)te;
            FluidBuffer srcBuffer = src.getPipeBuffer(side);
            if (srcBuffer == null || (info = ifh.getTankInfo(ForgeDirection.getOrientation((int)(side ^ 1)))) == null) continue;
            for (FluidTankInfo i : info) {
                int qty;
                int dstPressure;
                Fluid bType = srcBuffer.Type;
                int srcLevel = srcBuffer.getLevel() + srcBuffer.Delta;
                int srcPressure = src.getPipePressure(side);
                if (i.capacity <= 0 || (i.fluid == null ? bType == null : i.fluid.getFluid() != bType && bType != null)) continue;
                int dstLevel = i.fluid == null ? 0 : i.fluid.amount;
                int n = dstPressure = dstLevel <= 0 ? -100 : (int)((double)dstLevel / (double)i.capacity * 100.0);
                if (srcPressure < dstPressure && dstLevel > 0) {
                    FluidStack drStack;
                    qty = Math.min(Math.min(Math.max(25, (dstLevel - srcLevel) / 2), srcBuffer.getMaxLevel() - srcLevel), dstLevel);
                    if (qty <= 0 || (drStack = ifh.drain(ForgeDirection.getOrientation((int)(side ^ 1)), qty, true)) == null) continue;
                    srcBuffer.addLevel(drStack.getFluid(), drStack.amount);
                    continue;
                }
                if (srcPressure <= dstPressure || srcLevel <= 0 || (qty = Math.min(Math.min(Math.max(25, (srcLevel - dstLevel) / 2), i.capacity - dstLevel), srcLevel)) <= 0) continue;
                qty = ifh.fill(ForgeDirection.getOrientation((int)(side ^ 1)), new FluidStack(bType, qty), true);
                srcBuffer.addLevel(bType, -qty);
            }
        }
    }
}

