/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.RedPowerCore;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.IConnectable;
import com.eloraam.redpower.core.ICoverable;
import com.eloraam.redpower.core.IMultipart;
import com.eloraam.redpower.core.IRedPowerConnectableAdaptor;
import com.eloraam.redpower.core.IRedPowerWiring;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RedPowerLib {
    private static Set<PowerClassCompat> powerClassMapping = new HashSet<PowerClassCompat>();
    private static Set<ChunkCoordinates> blockUpdates = new HashSet<ChunkCoordinates>();
    private static Deque<ChunkCoordinates> powerSearch = new LinkedList<ChunkCoordinates>();
    private static Set<ChunkCoordinates> powerSearchTest = new HashSet<ChunkCoordinates>();
    private static boolean searching = false;

    public static void notifyBlock(World world, int x, int y, int z, Block block) {
        if (block != null) {
            world.func_147439_a(x, y, z).func_149695_a(world, x, y, z, block);
        }
    }

    public static void updateIndirectNeighbors(World w, int x, int y, int z, Block block) {
        if (!w.field_72995_K) {
            for (int a = -3; a <= 3; ++a) {
                for (int b = -3; b <= 3; ++b) {
                    for (int c = -3; c <= 3; ++c) {
                        int md = a < 0 ? -a : a;
                        md += b < 0 ? -b : b;
                        if ((md += c < 0 ? -c : c) > 3) continue;
                        RedPowerLib.notifyBlock(w, x + a, y + b, z + c, block);
                    }
                }
            }
        }
    }

    public static boolean isBlockRedstone(IBlockAccess iba, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        return iba.func_147439_a(x, y, z) instanceof BlockRedstoneWire;
    }

    public static boolean isSideNormal(IBlockAccess iba, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        side ^= 1;
        if (iba.func_147439_a(x, y, z).func_149721_r()) {
            return true;
        }
        iba.func_147439_a(x, y, z);
        IMultipart im = CoreLib.getTileEntity(iba, x, y, z, IMultipart.class);
        return im != null && im.isSideNormal(side);
    }

    public static boolean canSupportWire(IBlockAccess iba, int i, int j, int k, int side) {
        switch (side) {
            case 0: {
                --j;
                break;
            }
            case 1: {
                ++j;
                break;
            }
            case 2: {
                --k;
                break;
            }
            case 3: {
                ++k;
                break;
            }
            case 4: {
                --i;
                break;
            }
            case 5: {
                ++i;
            }
        }
        side ^= 1;
        if (iba instanceof World) {
            World bid = (World)iba;
            if (!bid.func_72899_e(i, j, k)) {
                return true;
            }
            if (bid.func_147439_a(i, j, k).isSideSolid((IBlockAccess)bid, i, j, k, ForgeDirection.getOrientation((int)side))) {
                return true;
            }
        }
        if (iba.func_147439_a(i, j, k).func_149721_r()) {
            return true;
        }
        Block block = iba.func_147439_a(i, j, k);
        if (block == Blocks.field_150326_M) {
            return true;
        }
        if (block != Blocks.field_150320_F && block != Blocks.field_150331_J) {
            IMultipart mpart = CoreLib.getTileEntity(iba, i, j, k, IMultipart.class);
            return mpart != null && mpart.isSideNormal(side);
        }
        int im = iba.func_72805_g(i, j, k) & 7;
        return i != im && im != 7;
    }

    public static boolean isStrongPoweringTo(IBlockAccess iba, int x, int y, int z, int side) {
        Block block = iba.func_147439_a(x, y, z);
        if (iba.func_147437_c(x, y, z)) {
            return false;
        }
        if (searching && block == Blocks.field_150488_af) {
            return false;
        }
        if (!(iba instanceof World)) {
            return false;
        }
        World world = (World)iba;
        return block.func_149748_c((IBlockAccess)world, x, y, z, side) > 0;
    }

    public static boolean isStrongPowered(IBlockAccess iba, int x, int y, int z, int side) {
        return side != 1 && RedPowerLib.isStrongPoweringTo(iba, x, y - 1, z, 0) || side != 0 && RedPowerLib.isStrongPoweringTo(iba, x, y + 1, z, 1) || side != 3 && RedPowerLib.isStrongPoweringTo(iba, x, y, z - 1, 2) || side != 2 && RedPowerLib.isStrongPoweringTo(iba, x, y, z + 1, 3) || side != 5 && RedPowerLib.isStrongPoweringTo(iba, x - 1, y, z, 4) || side != 4 && RedPowerLib.isStrongPoweringTo(iba, x + 1, y, z, 5);
    }

    public static boolean isWeakPoweringTo(IBlockAccess iba, int x, int y, int z, int side) {
        Block block = iba.func_147439_a(x, y, z);
        return block != Blocks.field_150350_a && (!searching || block != Blocks.field_150488_af) && (block.func_149709_b(iba, x, y, z, side) > 0 || side > 1 && block == Blocks.field_150488_af && block.func_149709_b(iba, x, y, z, 1) > 0);
    }

    public static boolean isPoweringTo(IBlockAccess iba, int x, int y, int z, int side) {
        Block block = iba.func_147439_a(x, y, z);
        if (block == Blocks.field_150350_a) {
            return false;
        }
        if (block.func_149709_b(iba, x, y, z, side) > 0) {
            return true;
        }
        if (block.func_149721_r() && RedPowerLib.isStrongPowered(iba, x, y, z, side)) {
            return true;
        }
        return side > 1 && block == Blocks.field_150488_af && !searching && block.func_149709_b(iba, x, y, z, 1) > 0;
    }

    public static boolean isPowered(IBlockAccess iba, int x, int y, int z, int cons, int inside) {
        return (cons & 0x1111100) > 0 && RedPowerLib.isWeakPoweringTo(iba, x, y - 1, z, 0) || (cons & 0x2222200) > 0 && RedPowerLib.isWeakPoweringTo(iba, x, y + 1, z, 1) || (cons & 0x4440011) > 0 && RedPowerLib.isWeakPoweringTo(iba, x, y, z - 1, 2) || (cons & 0x8880022) > 0 && RedPowerLib.isWeakPoweringTo(iba, x, y, z + 1, 3) || (cons & 0x10004444) > 0 && RedPowerLib.isWeakPoweringTo(iba, x - 1, y, z, 4) || (cons & 0x20008888) > 0 && RedPowerLib.isWeakPoweringTo(iba, x + 1, y, z, 5) || (inside & 1) > 0 && RedPowerLib.isPoweringTo(iba, x, y - 1, z, 0) || (inside & 2) > 0 && RedPowerLib.isPoweringTo(iba, x, y + 1, z, 1) || (inside & 4) > 0 && RedPowerLib.isPoweringTo(iba, x, y, z - 1, 2) || (inside & 8) > 0 && RedPowerLib.isPoweringTo(iba, x, y, z + 1, 3) || (inside & 0x10) > 0 && RedPowerLib.isPoweringTo(iba, x - 1, y, z, 4) || (inside & 0x20) > 0 && RedPowerLib.isPoweringTo(iba, x + 1, y, z, 5);
    }

    private static int getSidePowerMask(IBlockAccess iba, int x, int y, int z, int ch, int side) {
        TileEntity tile = CoreLib.getTileEntity(iba, x, y, z, TileEntity.class);
        int mask = RedPowerLib.getConDirMask(side);
        for (IRedPowerConnectableAdaptor adp : RedPowerCore.redPowerAdaptors) {
            if (!adp.canHandle(tile)) continue;
            int m = adp.getPoweringMask(ch, tile);
            m = (m & 0x55555555) << 1 | (m & 0x2AAAAAAA) >> 1;
            return m & mask;
        }
        if (ch != 0) {
            return 0;
        }
        return RedPowerLib.isWeakPoweringTo(iba, x, y, z, side) ? mask & 0xFFFFFF : (RedPowerLib.isPoweringTo(iba, x, y, z, side) ? mask : 0);
    }

    public static int getPowerState(IBlockAccess iba, int i, int j, int k, int cons, int ch) {
        int trs = 0;
        if ((cons & 0x1111100) > 0) {
            trs |= RedPowerLib.getSidePowerMask(iba, i, j - 1, k, ch, 0);
        }
        if ((cons & 0x2222200) > 0) {
            trs |= RedPowerLib.getSidePowerMask(iba, i, j + 1, k, ch, 1);
        }
        if ((cons & 0x4440011) > 0) {
            trs |= RedPowerLib.getSidePowerMask(iba, i, j, k - 1, ch, 2);
        }
        if ((cons & 0x8880022) > 0) {
            trs |= RedPowerLib.getSidePowerMask(iba, i, j, k + 1, ch, 3);
        }
        if ((cons & 0x10004444) > 0) {
            trs |= RedPowerLib.getSidePowerMask(iba, i - 1, j, k, ch, 4);
        }
        if ((cons & 0x20008888) > 0) {
            trs |= RedPowerLib.getSidePowerMask(iba, i + 1, j, k, ch, 5);
        }
        return trs & cons;
    }

    public static int getRotPowerState(IBlockAccess iba, int i, int j, int k, int rcon, int rot, int ch) {
        int c1 = RedPowerLib.mapRotToCon(rcon, rot);
        int ps = RedPowerLib.getPowerState(iba, i, j, k, c1, ch);
        return RedPowerLib.mapConToRot(ps, rot);
    }

    public static int getConDirMask(int dir) {
        switch (dir) {
            case 0: {
                return 0x1111100;
            }
            case 1: {
                return 0x2222200;
            }
            case 2: {
                return 0x4440011;
            }
            case 3: {
                return 0x8880022;
            }
            case 4: {
                return 0x10004444;
            }
        }
        return 0x20008888;
    }

    public static int mapConToLocal(int cons, int face) {
        cons >>= face * 4;
        cons &= 0xF;
        switch (face) {
            case 0: {
                return cons;
            }
            case 1: {
                return cons ^ ((cons ^ cons >> 1) & 1) * 3;
            }
            default: {
                return cons ^ ((cons ^ cons >> 2) & 3) * 5;
            }
            case 3: 
            case 4: 
        }
        cons ^= ((cons ^ cons >> 2) & 3) * 5;
        return cons ^ ((cons ^ cons >> 1) & 1) * 3;
    }

    public static int mapLocalToCon(int loc, int face) {
        switch (face) {
            case 0: {
                break;
            }
            case 1: {
                loc ^= ((loc ^ loc >> 1) & 1) * 3;
                break;
            }
            default: {
                loc ^= ((loc ^ loc >> 2) & 3) * 5;
                break;
            }
            case 3: 
            case 4: {
                loc ^= ((loc ^ loc >> 1) & 1) * 3;
                loc ^= ((loc ^ loc >> 2) & 3) * 5;
            }
        }
        return loc << face * 4;
    }

    public static int mapRotToLocal(int rm, int rot) {
        rm = rm << rot | rm >> 4 - rot;
        return (rm &= 0xF) & 8 | (rm & 3) << 1 | rm >> 2 & 1;
    }

    public static int mapLocalToRot(int rm, int rot) {
        rm = rm & 8 | (rm & 6) >> 1 | rm << 2 & 4;
        rm = rm << 4 - rot | rm >> rot;
        return rm & 0xF;
    }

    public static int mapConToRot(int con, int rot) {
        return RedPowerLib.mapLocalToRot(RedPowerLib.mapConToLocal(con, rot >> 2), rot & 3);
    }

    public static int mapRotToCon(int con, int rot) {
        return RedPowerLib.mapLocalToCon(RedPowerLib.mapRotToLocal(con, rot & 3), rot >> 2);
    }

    public static int getDirToRedstone(int rsd) {
        switch (rsd) {
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public static int getConSides(IBlockAccess iba, int i, int j, int k, int side, int pcl) {
        Block block = iba.func_147439_a(i, j, k);
        if (iba.func_147437_c(i, j, k)) {
            return 0;
        }
        TileEntity tile = CoreLib.getTileEntity(iba, i, j, k, TileEntity.class);
        if (RedPowerLib.isConnectable(tile)) {
            int md = RedPowerLib.getConnectClass(side, tile);
            return RedPowerLib.isCompatible(md, pcl) ? RedPowerLib.getConnectableMask(tile) : 0;
        }
        if (!RedPowerLib.isCompatible(0, pcl)) {
            return 0;
        }
        if (block == Blocks.field_150331_J || block == Blocks.field_150320_F) {
            int md = iba.func_72805_g(i, j, k) & 7;
            return md == 7 ? 0 : 0x3FFFFFFF ^ RedPowerLib.getConDirMask(md);
        }
        if (block == Blocks.field_150326_M) {
            TileEntity md2 = iba.func_147438_o(i, j, k);
            if (!(md2 instanceof TileEntityPiston)) {
                return 0;
            }
            TileEntityPiston tep = (TileEntityPiston)md2;
            Block sid = tep.func_145861_a();
            if (sid != Blocks.field_150331_J && sid != Blocks.field_150320_F) {
                return 0;
            }
            int md1 = tep.func_145832_p() & 7;
            return md1 == 7 ? 0 : 0x3FFFFFFF ^ RedPowerLib.getConDirMask(md1);
        }
        if (block == Blocks.field_150367_z || block instanceof BlockButton || block == Blocks.field_150442_at) {
            return 0x3FFFFFFF;
        }
        if (block == Blocks.field_150429_aA || block == Blocks.field_150437_az) {
            return 0x3FFFFFFF;
        }
        if (block != Blocks.field_150413_aR && block != Blocks.field_150416_aS) {
            return block.canConnectRedstone(iba, i, j, k, RedPowerLib.getDirToRedstone(side)) ? RedPowerLib.getConDirMask(side) : 0;
        }
        int md = iba.func_72805_g(i, j, k) & 1;
        return md > 0 ? 12 : 3;
    }

    private static int getES1(IBlockAccess iba, int i, int j, int k, int side, int pcl, int cc) {
        if (iba.func_147437_c(i, j, k)) {
            return 0;
        }
        TileEntity tile = CoreLib.getTileEntity(iba, i, j, k, TileEntity.class);
        if (RedPowerLib.isConnectable(tile)) {
            int cc2 = RedPowerLib.getCornerPowerMode(tile);
            if (cc == 0 || cc2 == 0) {
                return 0;
            }
            if (cc == 2 && cc2 == 2) {
                return 0;
            }
            if (cc == 3 && cc2 == 1) {
                return 0;
            }
            int pc = RedPowerLib.getConnectClass(side, tile);
            return RedPowerLib.isCompatible(pc, pcl) ? RedPowerLib.getConnectableMask(tile) : 0;
        }
        return 0;
    }

    public static int getExtConSides(IBlockAccess iba, IConnectable irp, int i, int j, int k, int dir, int cc) {
        int isv;
        int cons = irp.getConnectableMask();
        if ((cons &= RedPowerLib.getConDirMask(dir) & 0xFFFFFF) == 0) {
            return 0;
        }
        Block block = iba.func_147439_a(i, j, k);
        if (CoverLib.blockCoverPlate != null && block == CoverLib.blockCoverPlate) {
            if (iba.func_72805_g(i, j, k) != 0) {
                return 0;
            }
            ICoverable pcl = CoreLib.getTileEntity(iba, i, j, k, ICoverable.class);
            if (pcl == null) {
                return 0;
            }
            isv = pcl.getCoverMask();
            if ((isv & 1 << (dir ^ 1)) > 0) {
                return 0;
            }
            isv |= isv << 12;
            isv |= isv << 6;
            isv &= 0x30303;
            isv |= isv << 3;
            isv &= 0x111111;
            isv |= isv << 2;
            isv |= isv << 1;
            cons &= ~isv;
        } else if (!iba.func_147437_c(i, j, k) && block != Blocks.field_150358_i && block != Blocks.field_150355_j) {
            return 0;
        }
        int pcl1 = irp.getConnectClass(dir);
        isv = 0;
        if ((cons & 0xF) > 0) {
            isv |= RedPowerLib.getES1(iba, i, j - 1, k, 1, pcl1, cc) & 0x222200;
        }
        if ((cons & 0xF0) > 0) {
            isv |= RedPowerLib.getES1(iba, i, j + 1, k, 0, pcl1, cc) & 0x111100;
        }
        if ((cons & 0xF00) > 0) {
            isv |= RedPowerLib.getES1(iba, i, j, k - 1, 3, pcl1, cc) & 0x880022;
        }
        if ((cons & 0xF000) > 0) {
            isv |= RedPowerLib.getES1(iba, i, j, k + 1, 2, pcl1, cc) & 0x440011;
        }
        if ((cons & 0xF0000) > 0) {
            isv |= RedPowerLib.getES1(iba, i - 1, j, k, 5, pcl1, cc) & 0x8888;
        }
        if ((cons & 0xF00000) > 0) {
            isv |= RedPowerLib.getES1(iba, i + 1, j, k, 4, pcl1, cc) & 0x4444;
        }
        isv >>= (dir ^ 1) << 2;
        isv = (isv & 0xA) >> 1 | (isv & 5) << 1;
        isv |= isv << 6;
        isv |= isv << 3;
        isv &= 0x1111;
        isv <<= dir & 1;
        switch (dir) {
            case 0: 
            case 1: {
                return isv << 8;
            }
            case 2: 
            case 3: {
                return isv << 10 & 0xFF0000 | isv & 0xFF;
            }
        }
        return isv << 2;
    }

    public static int getConnections(IBlockAccess iba, IConnectable irp, int x, int y, int z) {
        int pcl;
        int cons = irp.getConnectableMask();
        int cs = 0;
        if ((cons & 0x1111100) > 0) {
            pcl = irp.getConnectClass(0);
            cs |= RedPowerLib.getConSides(iba, x, y - 1, z, 1, pcl) & 0x2222200;
        }
        if ((cons & 0x2222200) > 0) {
            pcl = irp.getConnectClass(1);
            cs |= RedPowerLib.getConSides(iba, x, y + 1, z, 0, pcl) & 0x1111100;
        }
        if ((cons & 0x4440011) > 0) {
            pcl = irp.getConnectClass(2);
            cs |= RedPowerLib.getConSides(iba, x, y, z - 1, 3, pcl) & 0x8880022;
        }
        if ((cons & 0x8880022) > 0) {
            pcl = irp.getConnectClass(3);
            cs |= RedPowerLib.getConSides(iba, x, y, z + 1, 2, pcl) & 0x4440011;
        }
        if ((cons & 0x10004444) > 0) {
            pcl = irp.getConnectClass(4);
            cs |= RedPowerLib.getConSides(iba, x - 1, y, z, 5, pcl) & 0x20008888;
        }
        if ((cons & 0x20008888) > 0) {
            pcl = irp.getConnectClass(5);
            cs |= RedPowerLib.getConSides(iba, x + 1, y, z, 4, pcl) & 0x10004444;
        }
        cs = cs << 1 & 0x2AAAAAAA | cs >> 1 & 0x15555555;
        return cs & cons;
    }

    public static int getExtConnections(IBlockAccess iba, IConnectable irp, int i, int j, int k) {
        int cs = 0;
        int cc = irp.getCornerPowerMode();
        int cs1 = cs | RedPowerLib.getExtConSides(iba, irp, i, j - 1, k, 0, cc);
        cs1 |= RedPowerLib.getExtConSides(iba, irp, i, j + 1, k, 1, cc);
        cs1 |= RedPowerLib.getExtConSides(iba, irp, i, j, k - 1, 2, cc);
        cs1 |= RedPowerLib.getExtConSides(iba, irp, i, j, k + 1, 3, cc);
        return (cs1 |= RedPowerLib.getExtConSides(iba, irp, i - 1, j, k, 4, cc)) | RedPowerLib.getExtConSides(iba, irp, i + 1, j, k, 5, cc);
    }

    public static int getExtConnectionExtras(IBlockAccess iba, IConnectable irp, int i, int j, int k) {
        int cs = 0;
        int cs1 = cs | RedPowerLib.getExtConSides(iba, irp, i, j - 1, k, 0, 3);
        cs1 |= RedPowerLib.getExtConSides(iba, irp, i, j + 1, k, 1, 3);
        cs1 |= RedPowerLib.getExtConSides(iba, irp, i, j, k - 1, 2, 3);
        cs1 |= RedPowerLib.getExtConSides(iba, irp, i, j, k + 1, 3, 3);
        return (cs1 |= RedPowerLib.getExtConSides(iba, irp, i - 1, j, k, 4, 3)) | RedPowerLib.getExtConSides(iba, irp, i + 1, j, k, 5, 3);
    }

    public static int getTileCurrentStrength(World world, int i, int j, int k, int cons, int ch) {
        TileEntity tile = CoreLib.getTileEntity((IBlockAccess)world, i, j, k, TileEntity.class);
        if (tile == null) {
            return -1;
        }
        if (tile instanceof IRedPowerWiring) {
            IRedPowerWiring irw = (IRedPowerWiring)tile;
            return irw.getCurrentStrength(cons, ch);
        }
        for (IRedPowerConnectableAdaptor adp : RedPowerCore.redPowerAdaptors) {
            if (!adp.canHandle(tile)) continue;
            return (adp.getPoweringMask(ch, tile) & cons) > 0 ? 255 : -1;
        }
        return -1;
    }

    public static int getTileOrRedstoneCurrentStrength(World world, int i, int j, int k, int cons, int ch) {
        Block block = world.func_147439_a(i, j, k);
        if (world.func_147437_c(i, j, k)) {
            return -1;
        }
        if (block == Blocks.field_150488_af) {
            int irp1 = world.func_72805_g(i, j, k);
            return irp1 > 0 ? irp1 : -1;
        }
        TileEntity tile = CoreLib.getTileEntity((IBlockAccess)world, i, j, k, TileEntity.class);
        if (tile == null) {
            return -1;
        }
        if (tile instanceof IRedPowerWiring) {
            IRedPowerWiring irw = (IRedPowerWiring)tile;
            return irw.getCurrentStrength(cons, ch);
        }
        for (IRedPowerConnectableAdaptor adp : RedPowerCore.redPowerAdaptors) {
            if (!adp.canHandle(tile)) continue;
            return (adp.getPoweringMask(ch, tile) & cons) > 0 ? 255 : -1;
        }
        return -1;
    }

    private static int getIndCur(World world, int i, int j, int k, int d1, int d2, int ch) {
        int d4;
        int d3;
        switch (d1) {
            case 0: {
                --j;
                d3 = d2 + 2;
                break;
            }
            case 1: {
                ++j;
                d3 = d2 + 2;
                break;
            }
            case 2: {
                --k;
                d3 = d2 + (d2 & 2);
                break;
            }
            case 3: {
                ++k;
                d3 = d2 + (d2 & 2);
                break;
            }
            case 4: {
                --i;
                d3 = d2;
                break;
            }
            default: {
                ++i;
                d3 = d2;
            }
        }
        switch (d3) {
            case 0: {
                --j;
                d4 = d1 - 2;
                break;
            }
            case 1: {
                ++j;
                d4 = d1 - 2;
                break;
            }
            case 2: {
                --k;
                d4 = d1 & 1 | (d1 & 4) >> 1;
                break;
            }
            case 3: {
                ++k;
                d4 = d1 & 1 | (d1 & 4) >> 1;
                break;
            }
            case 4: {
                --i;
                d4 = d1;
                break;
            }
            default: {
                ++i;
                d4 = d1;
            }
        }
        return RedPowerLib.getTileCurrentStrength(world, i, j, k, 1 << (d4 ^ 1) << ((d3 ^ 1) << 2), ch);
    }

    public static int getMaxCurrentStrength(World world, int i, int j, int k, int cons, int indcon, int ch) {
        int mcs = -1;
        int ocon = cons << 1 & 0x2AAAAAAA | cons >> 1 & 0x15555555;
        if ((cons & 0x1111100) > 0) {
            mcs = Math.max(mcs, RedPowerLib.getTileOrRedstoneCurrentStrength(world, i, j - 1, k, ocon & 0x2222200, ch));
        }
        if ((cons & 0x2222200) > 0) {
            mcs = Math.max(mcs, RedPowerLib.getTileOrRedstoneCurrentStrength(world, i, j + 1, k, ocon & 0x1111100, ch));
        }
        if ((cons & 0x4440011) > 0) {
            mcs = Math.max(mcs, RedPowerLib.getTileOrRedstoneCurrentStrength(world, i, j, k - 1, ocon & 0x8880022, ch));
        }
        if ((cons & 0x8880022) > 0) {
            mcs = Math.max(mcs, RedPowerLib.getTileOrRedstoneCurrentStrength(world, i, j, k + 1, ocon & 0x4440011, ch));
        }
        if ((cons & 0x10004444) > 0) {
            mcs = Math.max(mcs, RedPowerLib.getTileOrRedstoneCurrentStrength(world, i - 1, j, k, ocon & 0x20008888, ch));
        }
        if ((cons & 0x20008888) > 0) {
            mcs = Math.max(mcs, RedPowerLib.getTileOrRedstoneCurrentStrength(world, i + 1, j, k, ocon & 0x10004444, ch));
        }
        for (int a = 0; a < 6; ++a) {
            for (int b = 0; b < 4; ++b) {
                if ((indcon & 1 << a * 4 + b) <= 0) continue;
                mcs = Math.max(mcs, RedPowerLib.getIndCur(world, i, j, k, a, b, ch));
            }
        }
        return mcs;
    }

    public static void addUpdateBlock(int i, int j, int k) {
        for (int a = -3; a <= 3; ++a) {
            for (int b = -3; b <= 3; ++b) {
                for (int c = -3; c <= 3; ++c) {
                    int md = a < 0 ? -a : a;
                    md += b < 0 ? -b : b;
                    if ((md += c < 0 ? -c : c) > 3) continue;
                    blockUpdates.add(new ChunkCoordinates(i + a, j + b, k + c));
                }
            }
        }
    }

    public static void addStartSearchBlock(int x, int y, int z) {
        ChunkCoordinates sb = new ChunkCoordinates(x, y, z);
        if (!powerSearchTest.contains(sb)) {
            powerSearch.addLast(sb);
            powerSearchTest.add(sb);
        }
    }

    public static void addSearchBlock(int x, int y, int z) {
        RedPowerLib.addStartSearchBlock(x, y, z);
        blockUpdates.add(new ChunkCoordinates(x, y, z));
    }

    private static void addIndBl(int x, int y, int z, int d1, int d2) {
        int d3;
        switch (d1) {
            case 0: {
                --y;
                d3 = d2 + 2;
                break;
            }
            case 1: {
                ++y;
                d3 = d2 + 2;
                break;
            }
            case 2: {
                --z;
                d3 = d2 + (d2 & 2);
                break;
            }
            case 3: {
                ++z;
                d3 = d2 + (d2 & 2);
                break;
            }
            case 4: {
                --x;
                d3 = d2;
                break;
            }
            default: {
                ++x;
                d3 = d2;
            }
        }
        switch (d3) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        RedPowerLib.addSearchBlock(x, y, z);
    }

    public static void addSearchBlocks(int i, int j, int k, int cons, int indcon) {
        int ocon = cons << 1 & 0xAAAAAA | cons >> 1 & 0x555555;
        if ((cons & 0x1111100) > 0) {
            RedPowerLib.addSearchBlock(i, j - 1, k);
        }
        if ((cons & 0x2222200) > 0) {
            RedPowerLib.addSearchBlock(i, j + 1, k);
        }
        if ((cons & 0x4440011) > 0) {
            RedPowerLib.addSearchBlock(i, j, k - 1);
        }
        if ((cons & 0x8880022) > 0) {
            RedPowerLib.addSearchBlock(i, j, k + 1);
        }
        if ((cons & 0x10004444) > 0) {
            RedPowerLib.addSearchBlock(i - 1, j, k);
        }
        if ((cons & 0x20008888) > 0) {
            RedPowerLib.addSearchBlock(i + 1, j, k);
        }
        for (int a = 0; a < 6; ++a) {
            for (int b = 0; b < 4; ++b) {
                if ((indcon & 1 << a * 4 + b) <= 0) continue;
                RedPowerLib.addIndBl(i, j, k, a, b);
            }
        }
    }

    public static void updateCurrent(World world, int x, int y, int z) {
        RedPowerLib.addStartSearchBlock(x, y, z);
        if (!searching) {
            searching = true;
            while (powerSearch.size() > 0) {
                ChunkCoordinates c = powerSearch.removeFirst();
                powerSearchTest.remove(c);
                IRedPowerWiring sp = CoreLib.getTileEntity((IBlockAccess)world, c.field_71574_a, c.field_71572_b, c.field_71573_c, IRedPowerWiring.class);
                if (sp == null) continue;
                sp.updateCurrentStrength();
            }
            searching = false;
            ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>(blockUpdates);
            blockUpdates.clear();
            for (ChunkCoordinates c : coords) {
                RedPowerLib.notifyBlock(world, c.field_71574_a, c.field_71572_b, c.field_71573_c, (Block)Blocks.field_150488_af);
                world.func_147471_g(c.field_71574_a, c.field_71572_b, c.field_71573_c);
            }
        }
    }

    public static int updateBlockCurrentStrength(World world, IRedPowerWiring irp, int x, int y, int z, int conm, int chm) {
        int ch;
        int cons = irp.getConnectionMask() & conm;
        int indcon = irp.getExtConnectionMask() & conm;
        int mx = -1;
        int ps = 0;
        int cs = 0;
        for (int chm2 = chm; chm2 > 0; chm2 &= ~(1 << ch)) {
            ch = Integer.numberOfTrailingZeros(chm2);
            cs = Math.max(cs, irp.getCurrentStrength(conm, ch));
            mx = Math.max(mx, RedPowerLib.getMaxCurrentStrength(world, x, y, z, cons, indcon, ch));
            ps = Math.max(ps, irp.scanPoweringStrength(cons | indcon, ch));
        }
        if (ps > cs || mx != cs + 1 && (cs != 0 || mx != 0)) {
            if (ps == cs && mx <= cs) {
                return cs;
            }
            if ((cs = Math.max(ps, cs)) >= mx) {
                if (cs > ps) {
                    cs = 0;
                }
            } else {
                cs = Math.max(0, mx - 1);
            }
            if ((chm & 1) > 0) {
                RedPowerLib.addUpdateBlock(x, y, z);
            }
            RedPowerLib.addSearchBlocks(x, y, z, cons, indcon);
            return cs;
        }
        return cs;
    }

    public static boolean isSearching() {
        return searching;
    }

    public static void addCompatibleMapping(int a, int b) {
        powerClassMapping.add(new PowerClassCompat(a, b));
        powerClassMapping.add(new PowerClassCompat(b, a));
    }

    public static boolean isCompatible(int a, int b) {
        return a == b || powerClassMapping.contains(new PowerClassCompat(a, b));
    }

    public static boolean isConnectable(TileEntity tile) {
        for (IRedPowerConnectableAdaptor adp : RedPowerCore.redPowerAdaptors) {
            if (!adp.canHandle(tile)) continue;
            return true;
        }
        return tile instanceof IConnectable;
    }

    public static int getConnectableMask(TileEntity tile) {
        for (IRedPowerConnectableAdaptor adp : RedPowerCore.redPowerAdaptors) {
            if (!adp.canHandle(tile)) continue;
            return adp.getConnectableMask(tile);
        }
        return ((IConnectable)tile).getConnectableMask();
    }

    public static int getConnectClass(int var1, TileEntity tile) {
        for (IRedPowerConnectableAdaptor adp : RedPowerCore.redPowerAdaptors) {
            if (!adp.canHandle(tile)) continue;
            return adp.getConnectClass(var1, tile);
        }
        return ((IConnectable)tile).getConnectClass(var1);
    }

    public static int getCornerPowerMode(TileEntity tile) {
        for (IRedPowerConnectableAdaptor adp : RedPowerCore.redPowerAdaptors) {
            if (!adp.canHandle(tile)) continue;
            return adp.getCornerPowerMode(tile);
        }
        return ((IConnectable)tile).getCornerPowerMode();
    }

    public static class PowerClassCompat {
        private final int a;
        private final int b;

        public PowerClassCompat(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                PowerClassCompat that = (PowerClassCompat)o;
                return this.a == that.a && this.b == that.b;
            }
            return false;
        }

        public int hashCode() {
            int result = this.a;
            return 31 * result + this.b;
        }
    }
}

