/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.EntityCustomDiggingFX;
import com.eloraam.redpower.core.TileCoverable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

@SideOnly(value=Side.CLIENT)
public abstract class RenderCustomBlock
extends TileEntitySpecialRenderer
implements IItemRenderer {
    protected Block block;

    public RenderCustomBlock(Block block) {
        this.block = block;
    }

    protected int getMixedBrightness(TileEntity tile) {
        return tile.func_145838_q().func_149677_c((IBlockAccess)tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
    }

    public boolean renderHit(EffectRenderer effectRenderer, World world, MovingObjectPosition target, int x, int y, int z, int side, int meta) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileCoverable) {
            TileCoverable coverable = (TileCoverable)tile;
            Block block = coverable.func_145838_q();
            int cvr = coverable.getCover(target.subHit);
            if (cvr >= 0) {
                Block bl = CoverLib.getBlock(cvr & 0xFF);
                int m = CoverLib.getMeta(cvr & 0xFF);
                if (bl != null && bl != Blocks.field_150350_a) {
                    float f = 0.1f;
                    double dx = (double)x + world.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
                    double dy = (double)y + world.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
                    double dz = (double)z + world.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
                    switch (side) {
                        case 0: {
                            dy = (double)y + block.func_149665_z() - (double)f;
                            break;
                        }
                        case 1: {
                            dy = (double)y + block.func_149669_A() + (double)f;
                            break;
                        }
                        case 2: {
                            dz = (double)z + block.func_149706_B() - (double)f;
                            break;
                        }
                        case 3: {
                            dz = (double)z + block.func_149693_C() + (double)f;
                            break;
                        }
                        case 4: {
                            dx = (double)x + block.func_149704_x() - (double)f;
                            break;
                        }
                        case 5: {
                            dx = (double)x + block.func_149753_y() + (double)f;
                        }
                    }
                    effectRenderer.func_78873_a(new EntityDiggingFX(world, dx, dy, dz, 0.0, 0.0, 0.0, bl, m, target.field_72310_e).func_70543_e(0.2f).func_70541_f(0.6f));
                }
                return true;
            }
        }
        if (tile != null) {
            float f = 0.1f;
            double dx = (double)x + world.field_73012_v.nextDouble() * (this.block.func_149753_y() - this.block.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.block.func_149704_x();
            double dy = (double)y + world.field_73012_v.nextDouble() * (this.block.func_149669_A() - this.block.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.block.func_149665_z();
            double dz = (double)z + world.field_73012_v.nextDouble() * (this.block.func_149693_C() - this.block.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.block.func_149706_B();
            switch (side) {
                case 0: {
                    dy = (double)y + this.block.func_149665_z() - (double)f;
                    break;
                }
                case 1: {
                    dy = (double)y + this.block.func_149669_A() + (double)f;
                    break;
                }
                case 2: {
                    dz = (double)z + this.block.func_149706_B() - (double)f;
                    break;
                }
                case 3: {
                    dz = (double)z + this.block.func_149693_C() + (double)f;
                    break;
                }
                case 4: {
                    dx = (double)x + this.block.func_149704_x() - (double)f;
                    break;
                }
                case 5: {
                    dx = (double)x + this.block.func_149753_y() + (double)f;
                }
            }
            int color = this.getParticleColorForSide(world, x, y, z, tile, side, meta);
            IIcon icon = this.getParticleIconForSide(world, x, y, z, tile, side, meta);
            if (icon != null) {
                effectRenderer.func_78873_a(new EntityCustomDiggingFX(world, dx, dy, dz, 0.0, 0.0, 0.0, icon, color).func_70543_e(0.2f).func_70541_f(0.6f));
            }
            return true;
        }
        return false;
    }

    public boolean renderDestroy(EffectRenderer effectRenderer, World world, int x, int y, int z, int meta) {
        TileCoverable coverable;
        int cvr;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        TileEntity tile = world.func_147438_o(x, y, z);
        MovingObjectPosition target = Minecraft.func_71410_x().field_71439_g.func_70614_a(5.0, 1.0f);
        if (tile != null && tile instanceof TileCoverable && target != null && target.field_72311_b == x && target.field_72312_c == y && target.field_72309_d == z && (cvr = (coverable = (TileCoverable)tile).getCover(target.subHit)) >= 0) {
            Block bl = CoverLib.getBlock(cvr & 0xFF);
            int m = CoverLib.getMeta(cvr & 0xFF);
            if (bl != null && bl != Blocks.field_150350_a) {
                int offset = 4;
                for (int xoff = 0; xoff < offset; ++xoff) {
                    for (int yoff = 0; yoff < offset; ++yoff) {
                        for (int zoff = 0; zoff < offset; ++zoff) {
                            double xc = (double)x + ((double)xoff + 0.5) / (double)offset;
                            double yc = (double)y + ((double)yoff + 0.5) / (double)offset;
                            double zc = (double)z + ((double)zoff + 0.5) / (double)offset;
                            effectRenderer.func_78873_a((EntityFX)new EntityDiggingFX(world, xc, yc, zc, xc - (double)x - 0.5, yc - (double)y - 0.5, zc - (double)z - 0.5, bl, m, target.field_72310_e));
                        }
                    }
                }
            }
            return true;
        }
        if (tile == null) {
            return false;
        }
        int offset = 4;
        for (int xoff = 0; xoff < offset; ++xoff) {
            for (int yoff = 0; yoff < offset; ++yoff) {
                for (int zoff = 0; zoff < offset; ++zoff) {
                    double xc = (double)x + ((double)xoff + 0.5) / (double)offset;
                    double yc = (double)y + ((double)yoff + 0.5) / (double)offset;
                    double zc = (double)z + ((double)zoff + 0.5) / (double)offset;
                    int side = world.field_73012_v.nextInt(6);
                    int color = this.getParticleColorForSide(world, x, y, z, tile, side, meta);
                    IIcon icon = this.getParticleIconForSide(world, x, y, z, tile, side, meta);
                    if (icon == null) continue;
                    effectRenderer.func_78873_a((EntityFX)new EntityCustomDiggingFX(world, xc, yc, zc, xc - (double)x - 0.5, yc - (double)y - 0.5, zc - (double)z - 0.5, icon, color));
                }
            }
        }
        return true;
    }

    protected IIcon getParticleIconForSide(World world, int x, int y, int z, TileEntity tile, int side, int meta) {
        return null;
    }

    protected int getParticleColorForSide(World world, int x, int y, int z, TileEntity tile, int side, int meta) {
        return 0xFFFFFF;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
    }
}

