/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.BlockExtended;
import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.CoverRenderer;
import com.eloraam.redpower.core.RenderContext;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHighlight {
    private RenderContext context = new RenderContext();
    private CoverRenderer coverRenderer = new CoverRenderer(this.context);
    private IIcon[] destroyIcons;

    @SubscribeEvent
    public void onTextureStitchEventPost(TextureStitchEvent.Post evt) {
        if (evt.map.func_130086_a() == 0) {
            CoverRenderer.reInitIcons();
        }
        this.destroyIcons = (IIcon[])ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)Minecraft.func_71410_x().field_71438_f, (String[])new String[]{"destroyBlockIcons", "field_94141_F"});
    }

    @SubscribeEvent
    public void highlightEvent(DrawBlockHighlightEvent evt) {
        this.onBlockHighlight(evt.context, evt.player, evt.target, evt.subID, evt.currentItem, evt.partialTicks);
    }

    public boolean onBlockHighlight(RenderGlobal render, EntityPlayer pl, MovingObjectPosition mop, int subID, ItemStack ist, float partialTicks) {
        World world = pl.field_70170_p;
        Block bl = world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        Map damagedBlocks = (Map)ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)render, (String[])new String[]{"damagedBlocks", "field_72738_E"});
        if (bl instanceof BlockMultipart) {
            BlockMultipart bm = (BlockMultipart)bl;
            bm.setPartBounds(pl.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.subHit);
        }
        if (!damagedBlocks.isEmpty()) {
            for (DestroyBlockProgress dbp : damagedBlocks.values()) {
                if (dbp.func_73110_b() != mop.field_72311_b || dbp.func_73109_c() != mop.field_72312_c || dbp.func_73108_d() != mop.field_72309_d) continue;
                if (!(bl instanceof BlockExtended)) break;
                this.drawBreaking(pl.field_70170_p, render, (BlockExtended)bl, pl, mop, partialTicks, dbp.func_73106_e());
                return true;
            }
        }
        if (ist == null || CoverLib.blockCoverPlate == null || ist.func_77973_b() != Item.func_150898_a((Block)CoverLib.blockCoverPlate)) {
            return false;
        }
        if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return false;
        }
        switch (ist.func_77960_j() >> 8) {
            case 0: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.drawSideBox(world, pl, mop, partialTicks);
                MovingObjectPosition placement = CoverLib.getPlacement(world, mop, ist.func_77960_j());
                if (placement == null) break;
                this.drawPreview(pl, placement, partialTicks, ist.func_77960_j());
                break;
            }
            default: {
                return false;
            }
            case 18: 
            case 19: 
            case 20: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                this.drawCornerBox(world, pl, mop, partialTicks);
                MovingObjectPosition placement = CoverLib.getPlacement(world, mop, ist.func_77960_j());
                if (placement == null) break;
                this.drawPreview(pl, placement, partialTicks, ist.func_77960_j());
            }
        }
        return true;
    }

    private void setRawPos(EntityPlayer player, MovingObjectPosition mop, float partialTicks) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        this.context.setPos((double)mop.field_72311_b - dx, (double)mop.field_72312_c - dy, (double)mop.field_72309_d - dz);
    }

    private void setCollPos(EntityPlayer player, MovingObjectPosition mop, float partialTicks) {
        this.setRawPos(player, mop, partialTicks);
        switch (mop.field_72310_e) {
            case 0: {
                this.context.setRelPos(0.0, mop.field_72307_f.field_72448_b - (double)mop.field_72312_c, 0.0);
                break;
            }
            case 1: {
                this.context.setRelPos(0.0, (double)mop.field_72312_c - mop.field_72307_f.field_72448_b + 1.0, 0.0);
                break;
            }
            case 2: {
                this.context.setRelPos(0.0, mop.field_72307_f.field_72449_c - (double)mop.field_72309_d, 0.0);
                break;
            }
            case 3: {
                this.context.setRelPos(0.0, (double)mop.field_72309_d - mop.field_72307_f.field_72449_c + 1.0, 0.0);
                break;
            }
            case 4: {
                this.context.setRelPos(0.0, mop.field_72307_f.field_72450_a - (double)mop.field_72311_b, 0.0);
                break;
            }
            default: {
                this.context.setRelPos(0.0, (double)mop.field_72311_b - mop.field_72307_f.field_72450_a + 1.0, 0.0);
            }
        }
    }

    public void drawCornerBox(World world, EntityPlayer player, MovingObjectPosition mop, float partialTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.9f);
        GL11.glLineWidth((float)3.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        float var5 = 0.002f;
        float var6 = 0.25f;
        Block bl = world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        if (bl != Blocks.field_150350_a) {
            this.context.setSize(0.0, -var5, 0.0, 1.0, -var5, 1.0);
            this.context.setupBox();
            this.context.vertices[4].set(0.0, -var5, 0.5);
            this.context.vertices[5].set(1.0, -var5, 0.5);
            this.context.vertices[6].set(0.5, -var5, 0.0);
            this.context.vertices[7].set(0.5, -var5, 1.0);
            this.context.setOrientation(mop.field_72310_e, 0);
            this.setCollPos(player, mop, partialTicks);
            this.context.transformRotate();
            Tessellator.field_78398_a.func_78371_b(3);
            this.context.drawPoints(0, 1, 2, 3, 0);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78371_b(1);
            this.context.drawPoints(4, 5, 6, 7);
            Tessellator.field_78398_a.func_78381_a();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        this.context.setRelPos(0.0, 0.0, 0.0);
    }

    public void drawSideBox(World world, EntityPlayer player, MovingObjectPosition mop, float partialTicks) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.9f);
        GL11.glLineWidth((float)3.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        float var5 = 0.002f;
        float var6 = 0.25f;
        Block bl = world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
        if (bl != Blocks.field_150350_a) {
            this.context.setSize(0.0, -var5, 0.0, 1.0, -var5, 1.0);
            this.context.setupBox();
            this.context.vertices[4].set(1.0f - var6, -var5, var6);
            this.context.vertices[5].set(var6, -var5, var6);
            this.context.vertices[6].set(var6, -var5, 1.0f - var6);
            this.context.vertices[7].set(1.0f - var6, -var5, 1.0f - var6);
            this.context.setOrientation(mop.field_72310_e, 0);
            this.setCollPos(player, mop, partialTicks);
            this.context.transformRotate();
            Tessellator.field_78398_a.func_78371_b(3);
            this.context.drawPoints(0, 1, 2, 3, 0);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78371_b(3);
            this.context.drawPoints(4, 5, 6, 7, 4);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78371_b(1);
            this.context.drawPoints(0, 4, 1, 5, 2, 6, 3, 7);
            Tessellator.field_78398_a.func_78381_a();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        this.context.setRelPos(0.0, 0.0, 0.0);
    }

    public void drawBreaking(World world, RenderGlobal render, BlockExtended bl, EntityPlayer pl, MovingObjectPosition mop, float partialTicks, int destroyStage) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)774, (int)768);
        this.context.bindBlockTexture();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
        GL11.glEnable((int)32823);
        double dx = pl.field_70142_S + (pl.field_70165_t - pl.field_70142_S) * (double)partialTicks;
        double dy = pl.field_70137_T + (pl.field_70163_u - pl.field_70137_T) * (double)partialTicks;
        double dz = pl.field_70136_U + (pl.field_70161_v - pl.field_70136_U) * (double)partialTicks;
        GL11.glEnable((int)3008);
        this.context.setPos((double)mop.field_72311_b - dx, (double)mop.field_72312_c - dy, (double)mop.field_72309_d - dz);
        this.context.setIcon(this.destroyIcons[destroyStage]);
        Tessellator.field_78398_a.func_78382_b();
        this.context.setSize(bl.func_149704_x(), bl.func_149665_z(), bl.func_149706_B(), bl.func_149753_y(), bl.func_149669_A(), bl.func_149693_C());
        this.context.setupBox();
        this.context.transform();
        this.context.renderFaces(63);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
        GL11.glDisable((int)32823);
    }

    public void drawPreview(EntityPlayer pl, MovingObjectPosition mop, float partialTicks, int md) {
        this.setRawPos(pl, mop, partialTicks);
        this.context.bindBlockTexture();
        this.coverRenderer.start();
        this.coverRenderer.setupCorners();
        this.coverRenderer.setSize(mop.subHit, CoverLib.getThickness(mop.subHit, CoverLib.damageToCoverValue(md)));
        this.context.setIcon(CoverRenderer.coverIcons[md & 0xFF]);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
        GL11.glEnable((int)32823);
        Tessellator.field_78398_a.func_78382_b();
        this.context.setupBox();
        this.context.transform();
        this.context.doMappingBox(63);
        this.context.doLightLocal(63);
        this.context.renderAlpha(63, 0.8f);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glDisable((int)32823);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
    }
}

