/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.ItemExtended;
import com.eloraam.redpower.core.Quat;
import com.eloraam.redpower.core.RenderCustomBlock;
import com.eloraam.redpower.core.Vector3;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderLib {
    private static RenderListEntry[] renderers = new RenderListEntry[4096];

    public static void renderSpecialLever(Vector3 pos, Quat rot, IIcon foundation, IIcon lever) {
        Vector3[] pl = new Vector3[8];
        float f8 = 0.0625f;
        float f9 = 0.0625f;
        float f10 = 0.375f;
        pl[0] = new Vector3(-f8, 0.0, -f9);
        pl[1] = new Vector3(f8, 0.0, -f9);
        pl[2] = new Vector3(f8, 0.0, f9);
        pl[3] = new Vector3(-f8, 0.0, f9);
        pl[4] = new Vector3(-f8, f10, -f9);
        pl[5] = new Vector3(f8, f10, -f9);
        pl[6] = new Vector3(f8, f10, f9);
        pl[7] = new Vector3(-f8, f10, f9);
        for (int i = 0; i < 8; ++i) {
            rot.rotate(pl[i]);
            pl[i].add(pos.x + 0.5, pos.y + 0.5, pos.z + 0.5);
        }
        float uMin = foundation.func_94209_e();
        float uMax = foundation.func_94212_f();
        float vMin = foundation.func_94206_g();
        float vMax = foundation.func_94210_h();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderLib.addVectWithUV(pl[0], uMin, vMax);
        RenderLib.addVectWithUV(pl[1], uMax, vMax);
        RenderLib.addVectWithUV(pl[2], uMax, vMin);
        RenderLib.addVectWithUV(pl[3], uMin, vMin);
        RenderLib.addVectWithUV(pl[7], uMin, vMax);
        RenderLib.addVectWithUV(pl[6], uMax, vMax);
        RenderLib.addVectWithUV(pl[5], uMax, vMin);
        RenderLib.addVectWithUV(pl[4], uMin, vMin);
        uMin = lever.func_94209_e();
        uMax = lever.func_94212_f();
        vMin = lever.func_94206_g();
        vMax = lever.func_94210_h();
        RenderLib.addVectWithUV(pl[1], uMin, vMax);
        RenderLib.addVectWithUV(pl[0], uMax, vMax);
        RenderLib.addVectWithUV(pl[4], uMax, vMin);
        RenderLib.addVectWithUV(pl[5], uMin, vMin);
        RenderLib.addVectWithUV(pl[2], uMin, vMax);
        RenderLib.addVectWithUV(pl[1], uMax, vMax);
        RenderLib.addVectWithUV(pl[5], uMax, vMin);
        RenderLib.addVectWithUV(pl[6], uMin, vMin);
        RenderLib.addVectWithUV(pl[3], uMin, vMax);
        RenderLib.addVectWithUV(pl[2], uMax, vMax);
        RenderLib.addVectWithUV(pl[6], uMax, vMin);
        RenderLib.addVectWithUV(pl[7], uMin, vMin);
        RenderLib.addVectWithUV(pl[0], uMin, vMax);
        RenderLib.addVectWithUV(pl[3], uMax, vMax);
        RenderLib.addVectWithUV(pl[7], uMax, vMin);
        RenderLib.addVectWithUV(pl[4], uMin, vMin);
    }

    public static void addVectWithUV(Vector3 vect, double u, double v) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78374_a(vect.x, vect.y, vect.z, u, v);
    }

    public static void renderPointer(Vector3 pos, Quat rot) {
        Tessellator tess = Tessellator.field_78398_a;
        IIcon icon = Blocks.field_150348_b.func_149691_a(0, 0);
        double uMin = icon.func_94209_e();
        double vMin = icon.func_94206_g();
        double uMax = (double)icon.func_94214_a(7.9) - uMin;
        double vMax = (double)icon.func_94207_b(0.12432) - vMin;
        tess.func_78386_a(0.9f, 0.9f, 0.9f);
        Vector3[] vecs = new Vector3[]{new Vector3(0.4, 0.0, 0.0), new Vector3(0.0, 0.0, 0.2), new Vector3(-0.2, 0.0, 0.0), new Vector3(0.0, 0.0, -0.2), new Vector3(0.4, 0.1, 0.0), new Vector3(0.0, 0.1, 0.2), new Vector3(-0.2, 0.1, 0.0), new Vector3(0.0, 0.1, -0.2)};
        for (int i = 0; i < 8; ++i) {
            rot.rotate(vecs[i]);
            vecs[i].add(pos);
        }
        RenderLib.addVectWithUV(vecs[0], uMin, vMin);
        RenderLib.addVectWithUV(vecs[1], uMin + uMax, vMin);
        RenderLib.addVectWithUV(vecs[2], uMin + uMax, vMin + uMax);
        RenderLib.addVectWithUV(vecs[3], uMin, vMin + uMax);
        RenderLib.addVectWithUV(vecs[4], uMin, vMin);
        RenderLib.addVectWithUV(vecs[7], uMin, vMin + uMax);
        RenderLib.addVectWithUV(vecs[6], uMin + uMax, vMin + uMax);
        RenderLib.addVectWithUV(vecs[5], uMin + uMax, vMin);
        tess.func_78386_a(0.6f, 0.6f, 0.6f);
        RenderLib.addVectWithUV(vecs[0], uMin + vMax, vMin);
        RenderLib.addVectWithUV(vecs[4], uMin, vMin);
        RenderLib.addVectWithUV(vecs[5], uMin, vMin + uMax);
        RenderLib.addVectWithUV(vecs[1], uMin + vMax, vMin + uMax);
        RenderLib.addVectWithUV(vecs[0], uMin, vMin + vMax);
        RenderLib.addVectWithUV(vecs[3], uMin + uMax, vMin + vMax);
        RenderLib.addVectWithUV(vecs[7], uMin + uMax, vMin);
        RenderLib.addVectWithUV(vecs[4], uMin, vMin);
        RenderLib.addVectWithUV(vecs[2], uMin + uMax, vMin + uMax - vMax);
        RenderLib.addVectWithUV(vecs[6], uMin + uMax, vMin + uMax);
        RenderLib.addVectWithUV(vecs[7], uMin, vMin + uMax);
        RenderLib.addVectWithUV(vecs[3], uMin, vMin + uMax - vMax);
        RenderLib.addVectWithUV(vecs[2], uMin + uMax, vMin + uMax - vMax);
        RenderLib.addVectWithUV(vecs[1], uMin, vMin + uMax - vMax);
        RenderLib.addVectWithUV(vecs[5], uMin, vMin + uMax);
        RenderLib.addVectWithUV(vecs[6], uMin + uMax, vMin + uMax);
    }

    public static RenderCustomBlock getRenderer(Block bid, int md) {
        RenderListEntry rle = renderers[Block.func_149682_b((Block)bid)];
        return rle == null ? null : rle.metaRenders[md];
    }

    public static RenderCustomBlock getInvRenderer(Block bid, int md) {
        RenderListEntry rle = renderers[Block.func_149682_b((Block)bid)];
        if (rle == null) {
            return null;
        }
        int mdv = rle.mapDamageValue(md);
        return mdv > 15 ? rle.defaultRender : rle.metaRenders[mdv];
    }

    private static <B extends Block> RenderCustomBlock makeRenderer(B bl, Function<B, ? extends RenderCustomBlock> rcl) {
        return rcl.apply(bl);
    }

    public static <B extends Block> void setRenderer(B bl, Function<B, ? extends RenderCustomBlock> rcl) {
        RenderCustomBlock rnd = RenderLib.makeRenderer(bl, rcl);
        int bid = Block.func_149682_b(bl);
        if (renderers[bid] == null) {
            RenderLib.renderers[bid] = new RenderListEntry();
            MinecraftForgeClient.registerItemRenderer((Item)ItemExtended.func_150898_a(bl), (IItemRenderer)renderers[bid]);
        }
        for (int i = 0; i < 16; ++i) {
            RenderLib.renderers[bid].metaRenders[i] = rnd;
        }
    }

    public static <B extends Block> void setRenderer(B bl, int md, Function<B, ? extends RenderCustomBlock> rcl) {
        RenderCustomBlock rnd = RenderLib.makeRenderer(bl, rcl);
        int bid = Block.func_149682_b(bl);
        if (renderers[bid] == null) {
            RenderLib.renderers[bid] = new RenderListEntry();
            MinecraftForgeClient.registerItemRenderer((Item)ItemExtended.func_150898_a(bl), (IItemRenderer)renderers[bid]);
        }
        RenderLib.renderers[bid].metaRenders[md] = rnd;
    }

    public static <B extends Block> void setHighRenderer(B bl, int md, Function<B, ? extends RenderCustomBlock> rcl) {
        RenderCustomBlock rnd = RenderLib.makeRenderer(bl, rcl);
        int bid = Block.func_149682_b(bl);
        if (renderers[bid] == null) {
            RenderLib.renderers[bid] = new RenderShiftedEntry(8);
            MinecraftForgeClient.registerItemRenderer((Item)ItemExtended.func_150898_a(bl), (IItemRenderer)renderers[bid]);
        }
        RenderLib.renderers[bid].metaRenders[md] = rnd;
    }

    public static <B extends Block> void setDefaultRenderer(B bl, int shift, Function<B, ? extends RenderCustomBlock> rcl) {
        RenderCustomBlock rnd = RenderLib.makeRenderer(bl, rcl);
        int bid = Block.func_149682_b(bl);
        if (renderers[bid] == null) {
            RenderLib.renderers[bid] = new RenderShiftedEntry(shift);
            MinecraftForgeClient.registerItemRenderer((Item)ItemExtended.func_150898_a(bl), (IItemRenderer)renderers[bid]);
        }
        for (int i = 0; i < 16; ++i) {
            if (RenderLib.renderers[bid].metaRenders[i] != null) continue;
            RenderLib.renderers[bid].metaRenders[i] = rnd;
        }
        RenderLib.renderers[Block.func_149682_b(bl)].defaultRender = rnd;
    }

    public static <B extends Block> void setShiftedRenderer(B bl, int md, int shift, Function<B, ? extends RenderCustomBlock> rcl) {
        RenderCustomBlock rnd = RenderLib.makeRenderer(bl, rcl);
        int bid = Block.func_149682_b(bl);
        if (renderers[bid] == null) {
            RenderLib.renderers[bid] = new RenderShiftedEntry(shift);
            MinecraftForgeClient.registerItemRenderer((Item)ItemExtended.func_150898_a(bl), (IItemRenderer)renderers[bid]);
        }
        RenderLib.renderers[bid].metaRenders[md] = rnd;
    }

    private static class RenderShiftedEntry
    extends RenderListEntry {
        public int shift;

        public RenderShiftedEntry(int sh) {
            this.shift = sh;
        }

        @Override
        public int mapDamageValue(int dmg) {
            return dmg >> this.shift;
        }
    }

    private static class RenderListEntry
    implements IItemRenderer {
        public RenderCustomBlock[] metaRenders = new RenderCustomBlock[16];
        RenderCustomBlock defaultRender;

        private RenderListEntry() {
        }

        public int mapDamageValue(int dmg) {
            return dmg;
        }

        public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
            int meta = item.func_77960_j();
            int mdv = this.mapDamageValue(meta);
            RenderCustomBlock renderer = mdv > 15 ? this.defaultRender : this.metaRenders[mdv];
            return renderer != null && renderer.handleRenderType(item, type);
        }

        public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
            int meta = item.func_77960_j();
            int mdv = this.mapDamageValue(meta);
            RenderCustomBlock renderer = mdv > 15 ? this.defaultRender : this.metaRenders[mdv];
            return renderer != null && renderer.shouldUseRenderHelper(type, item, helper);
        }

        public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
            RenderCustomBlock renderer;
            int meta = item.func_77960_j();
            int mdv = this.mapDamageValue(meta);
            RenderCustomBlock renderCustomBlock = renderer = mdv > 15 ? this.defaultRender : this.metaRenders[mdv];
            if (renderer != null) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3008);
                renderer.renderItem(type, item, data);
            }
        }
    }
}

