/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.TexVertex;
import com.eloraam.redpower.core.Vector3;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class RenderModel {
    public Vector3[] vertices;
    public TexVertex[][] texs;
    int[][][] groups;

    public static RenderModel loadModel(String location) {
        try {
            int lgsn;
            int lgmn;
            int lgs;
            int i;
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(location));
            InputStream is = resource.func_110527_b();
            ModelReader ml = new ModelReader();
            ml.readModel(is);
            ArrayList<TexVertex[]> vtl = new ArrayList<TexVertex[]>();
            for (i = 0; i < ml.faceno.size(); ++i) {
                TexVertex[] tr = new TexVertex[4];
                for (lgs = 0; lgs < 4; ++lgs) {
                    lgmn = ml.faceno.get(i);
                    ++i;
                    if (lgmn < 0) {
                        throw new IllegalArgumentException("Non-Quad Face");
                    }
                    lgsn = ml.faceno.get(i);
                    ++i;
                    TexVertex t = ml.texvert.get(lgsn - 1).copy();
                    t.vtx = lgmn - 1;
                    t.v = 1.0 - t.v;
                    tr[lgs] = t;
                }
                int var15 = ml.faceno.get(i);
                if (var15 >= 0) {
                    throw new IllegalArgumentException("Non-Quad Face");
                }
                vtl.add(tr);
            }
            RenderModel model = new RenderModel();
            model.vertices = ml.vertex.toArray(new Vector3[0]);
            model.texs = (TexVertex[][])vtl.toArray((T[])new TexVertex[0][]);
            model.groups = new int[ml.grcnt.size()][][];
            for (int var13 = 0; var13 < ml.grcnt.size(); ++var13) {
                int lgs2 = ml.grcnt.get(var13);
                model.groups[var13] = new int[lgs2][];
                for (int lgmn2 = 0; lgmn2 < ml.grcnt.get(var13); ++lgmn2) {
                    model.groups[var13][lgmn2] = new int[2];
                }
            }
            lgs = -1;
            lgmn = -1;
            lgsn = -1;
            for (i = 0; i < ml.groups.size(); i += 3) {
                if (lgs >= 0) {
                    model.groups[lgmn][lgsn][0] = lgs;
                    model.groups[lgmn][lgsn][1] = ml.groups.get(i + 2);
                }
                lgmn = ml.groups.get(i);
                lgsn = ml.groups.get(i + 1);
                lgs = ml.groups.get(i + 2);
            }
            if (lgs >= 0) {
                model.groups[lgmn][lgsn][0] = lgs;
                model.groups[lgmn][lgsn][1] = ml.fno;
            }
            return model;
        }
        catch (IOException var11) {
            var11.printStackTrace();
            return null;
        }
    }

    public RenderModel scale(double factor) {
        for (Vector3 vertex : this.vertices) {
            vertex.multiply(factor);
        }
        return this;
    }

    public static class ModelReader {
        public List<Vector3> vertex = new ArrayList<Vector3>();
        public List<Integer> faceno = new ArrayList<Integer>();
        public List<TexVertex> texvert = new ArrayList<TexVertex>();
        public List<Integer> groups = new ArrayList<Integer>();
        public List<Integer> grcnt = new ArrayList<Integer>();
        int fno = 0;

        private void eatLine(StreamTokenizer tok) throws IOException {
            while (tok.nextToken() != -1) {
                if (tok.ttype != 10) continue;
                return;
            }
        }

        private void endLine(StreamTokenizer tok) throws IOException {
            if (tok.nextToken() != 10) {
                throw new IllegalArgumentException("Parse error");
            }
        }

        private double getFloat(StreamTokenizer tok) throws IOException {
            if (tok.nextToken() != -2) {
                throw new IllegalArgumentException("Parse error");
            }
            return tok.nval;
        }

        private int getInt(StreamTokenizer tok) throws IOException {
            if (tok.nextToken() != -2) {
                throw new IllegalArgumentException("Parse error");
            }
            return (int)tok.nval;
        }

        private void parseFace(StreamTokenizer tok) throws IOException {
            while (true) {
                tok.nextToken();
                if (tok.ttype == -1 || tok.ttype == 10) {
                    this.faceno.add(-1);
                    ++this.fno;
                    return;
                }
                if (tok.ttype != -2) {
                    throw new IllegalArgumentException("Parse error");
                }
                int n1 = (int)tok.nval;
                if (tok.nextToken() != 47) {
                    throw new IllegalArgumentException("Parse error");
                }
                int n2 = this.getInt(tok);
                this.faceno.add(n1);
                this.faceno.add(n2);
            }
        }

        private void setGroup(int gr, int sub) {
            this.groups.add(gr);
            this.groups.add(sub);
            this.groups.add(this.fno);
            if (this.grcnt.size() < gr) {
                throw new IllegalArgumentException("Parse error");
            }
            if (this.grcnt.size() == gr) {
                this.grcnt.add(0);
            }
            this.grcnt.set(gr, Math.max(this.grcnt.get(gr), sub + 1));
        }

        private void parseGroup(StreamTokenizer tok) throws IOException {
            int n1 = this.getInt(tok);
            int n2 = 0;
            tok.nextToken();
            if (tok.ttype == 95) {
                n2 = this.getInt(tok);
                tok.nextToken();
            }
            this.setGroup(n1, n2);
            if (tok.ttype != 10) {
                throw new IllegalArgumentException("Parse error");
            }
        }

        public void readModel(InputStream fis) throws IOException {
            BufferedReader r = new BufferedReader(new InputStreamReader(fis));
            StreamTokenizer tok = new StreamTokenizer(r);
            tok.commentChar(35);
            tok.eolIsSignificant(true);
            tok.lowerCaseMode(false);
            tok.parseNumbers();
            tok.quoteChar(34);
            tok.ordinaryChar(47);
            block14: while (tok.nextToken() != -1) {
                String var4;
                if (tok.ttype == 10) continue;
                if (tok.ttype != -3) {
                    throw new IllegalArgumentException("Parse error");
                }
                switch (var4 = tok.sval) {
                    case "v": {
                        Vector3 f1 = new Vector3();
                        f1.x = this.getFloat(tok);
                        f1.y = this.getFloat(tok);
                        f1.z = this.getFloat(tok);
                        this.vertex.add(f1);
                        this.endLine(tok);
                        continue block14;
                    }
                    case "vt": {
                        double f11 = this.getFloat(tok);
                        double f2 = this.getFloat(tok);
                        this.texvert.add(new TexVertex(0, f11, f2));
                        this.endLine(tok);
                        continue block14;
                    }
                    case "vtc": {
                        double f11 = this.getFloat(tok);
                        double f2 = this.getFloat(tok);
                        TexVertex tv = new TexVertex(0, f11, f2);
                        tv.r = (float)this.getFloat(tok);
                        tv.g = (float)this.getFloat(tok);
                        tv.b = (float)this.getFloat(tok);
                        this.texvert.add(tv);
                        this.endLine(tok);
                        continue block14;
                    }
                    case "f": {
                        this.parseFace(tok);
                        continue block14;
                    }
                    case "g": {
                        this.parseGroup(tok);
                        continue block14;
                    }
                }
                this.eatLine(tok);
            }
            fis.close();
        }
    }
}

