/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class TagFile {
    private TreeMap<String, Object> contents = new TreeMap();
    private TreeMap<String, String> comments = new TreeMap();
    private String filecomment = "";

    public void addTag(String name, Object tag) {
        int idx = 0;
        TreeMap<String, Object> sub = this.contents;
        while (true) {
            String p;
            int nid;
            if ((nid = name.indexOf(46, idx)) < 0) {
                p = name.substring(idx);
                if (p.equals("")) {
                    throw new IllegalArgumentException("Empty key name");
                }
                sub.put(p, tag);
                return;
            }
            p = name.substring(idx, nid);
            idx = nid + 1;
            if (p.equals("")) {
                throw new IllegalArgumentException("Empty key name");
            }
            Object ob = sub.get(p);
            if (ob == null) {
                TreeMap<String, Object> tmp = new TreeMap<String, Object>();
                sub.put(p, tmp);
                sub = tmp;
                continue;
            }
            if (!(ob instanceof TreeMap)) {
                throw new IllegalArgumentException("Key not a dictionary");
            }
            sub = (TreeMap<String, Object>)ob;
        }
    }

    public Object getTag(String name) {
        int idx = 0;
        TreeMap sub = this.contents;
        while (true) {
            String p;
            int nid;
            if ((nid = name.indexOf(46, idx)) < 0) {
                p = name.substring(idx);
                return sub.get(p);
            }
            p = name.substring(idx, nid);
            idx = nid + 1;
            Object ob = sub.get(p);
            if (!(ob instanceof TreeMap)) {
                return null;
            }
            sub = (TreeMap)ob;
        }
    }

    public Object removeTag(String name) {
        int idx = 0;
        TreeMap sub = this.contents;
        while (true) {
            String p;
            int nid;
            if ((nid = name.indexOf(46, idx)) < 0) {
                p = name.substring(idx);
                return sub.remove(p);
            }
            p = name.substring(idx, nid);
            idx = nid + 1;
            Object ob = sub.get(p);
            if (!(ob instanceof TreeMap)) {
                return null;
            }
            sub = (TreeMap)ob;
        }
    }

    public void commentTag(String k, String v) {
        this.comments.put(k, v);
    }

    public void commentFile(String cmt) {
        this.filecomment = cmt;
    }

    public void addString(String name, String value) {
        this.addTag(name, value);
    }

    public void addInt(String name, int value) {
        this.addTag(name, value);
    }

    public String getString(String name) {
        Object ob = this.getTag(name);
        return !(ob instanceof String) ? null : (String)ob;
    }

    public String getString(String name, String _default) {
        Object ob = this.getTag(name);
        if (ob == null) {
            this.addTag(name, _default);
            return _default;
        }
        return !(ob instanceof String) ? _default : (String)ob;
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int _default) {
        Object ob = this.getTag(name);
        if (ob == null) {
            this.addTag(name, _default);
            return _default;
        }
        return !(ob instanceof Integer) ? 0 : (Integer)ob;
    }

    private void writeComment(PrintStream ps, String indent, String cmt) {
        if (cmt != null) {
            for (String s : cmt.split("\n")) {
                ps.printf("%s# %s\n", indent, s);
            }
        }
    }

    private String collapsedTag(TreeMap<String, Object> tag, String key, String ft) {
        String cn = key;
        Object ob = tag.get(key);
        while (this.comments.get(ft) == null) {
            if (ob instanceof String) {
                return cn + "=\"" + ((String)ob).replace("\"", "\\\"") + "\"";
            }
            if (ob instanceof Integer) {
                return cn + "=" + ob;
            }
            tag = (TreeMap)ob;
            if (tag.size() != 1) {
                return null;
            }
            String k = (String)tag.firstKey();
            cn = cn + "." + k;
            ob = tag.get(k);
            ft = ft + "." + k;
        }
        return null;
    }

    private void saveTag(PrintStream ps, TreeMap<String, Object> tag, String name, String indent) throws IOException {
        for (String k : tag.keySet()) {
            String ft = name != null ? name + "." + k : k;
            this.writeComment(ps, indent, this.comments.get(ft));
            Object ob = tag.get(k);
            if (ob instanceof String) {
                ps.printf("%s%s=\"%s\"\n", indent, k, ((String)ob).replace("\"", "\\\""));
                continue;
            }
            if (ob instanceof Integer) {
                ps.printf("%s%s=%d\n", indent, k, ob);
                continue;
            }
            if (!(ob instanceof TreeMap)) continue;
            String ct = this.collapsedTag(tag, k, ft);
            if (ct != null) {
                ps.printf("%s%s\n", indent, ct);
                continue;
            }
            ps.printf("%s%s {\n", indent, k);
            this.saveTag(ps, (TreeMap)ob, ft, indent + "    ");
            ps.printf("%s}\n\n", indent);
        }
    }

    public void saveFile(File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            PrintStream ps = new PrintStream(os);
            this.writeComment(ps, "", this.filecomment);
            this.saveTag(ps, this.contents, null, "");
            ps.close();
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
    }

    private static void readTag(TreeMap<String, Object> tag, StreamTokenizer tok) throws IOException {
        block5: while (tok.nextToken() != -1 && tok.ttype != 125) {
            if (tok.ttype == 10) continue;
            if (tok.ttype != -3) {
                throw new IllegalArgumentException("Parse error");
            }
            String key = tok.sval;
            TreeMap<String, Integer> ltag = tag;
            block6: while (true) {
                switch (tok.nextToken()) {
                    case 46: {
                        TreeMap<String, Integer> ttag;
                        Object obtag = ltag.get(key);
                        if (!(obtag instanceof TreeMap)) {
                            ttag = new TreeMap<String, Integer>();
                            ltag.put(key, (Integer)((Object)ttag));
                            ltag = ttag;
                        } else {
                            ltag = (TreeMap<String, Integer>)obtag;
                        }
                        tok.nextToken();
                        if (tok.ttype != -3) {
                            throw new IllegalArgumentException("Parse error");
                        }
                        key = tok.sval;
                        continue block6;
                    }
                    case 61: {
                        tok.nextToken();
                        if (tok.ttype == -2) {
                            ltag.put(key, (int)tok.nval);
                        } else {
                            if (tok.ttype != 34) {
                                throw new IllegalArgumentException("Parse error");
                            }
                            ltag.put(key, (Integer)((Object)tok.sval));
                        }
                        tok.nextToken();
                        if (tok.ttype == 10) continue block5;
                        throw new IllegalArgumentException("Parse error");
                    }
                    case 123: {
                        TreeMap<String, Integer> ttag;
                        Object obtag = ltag.get(key);
                        if (!(obtag instanceof TreeMap)) {
                            ttag = new TreeMap();
                            ltag.put(key, (Integer)((Object)ttag));
                            ltag = ttag;
                        } else {
                            ltag = (TreeMap)obtag;
                        }
                        TagFile.readTag((TreeMap<String, Object>)ltag, tok);
                        tok.nextToken();
                        if (tok.ttype == 10) continue block5;
                        throw new IllegalArgumentException("Parse error");
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Parse error");
        }
    }

    public static TagFile loadFile(File file) {
        TagFile tagFile = new TagFile();
        try {
            FileInputStream stream = new FileInputStream(file);
            tagFile.readStream(stream);
        }
        catch (IOException var3) {
            var3.printStackTrace();
        }
        return tagFile;
    }

    public void readFile(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            this.readStream(stream);
        }
        catch (IOException var3) {
            var3.printStackTrace();
        }
    }

    public void readStream(InputStream stream) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StreamTokenizer tokenizer = new StreamTokenizer(reader);
            tokenizer.commentChar(35);
            tokenizer.eolIsSignificant(true);
            tokenizer.lowerCaseMode(false);
            tokenizer.parseNumbers();
            tokenizer.quoteChar(34);
            tokenizer.ordinaryChar(61);
            tokenizer.ordinaryChar(123);
            tokenizer.ordinaryChar(125);
            tokenizer.ordinaryChar(46);
            TagFile.readTag(this.contents, tokenizer);
            stream.close();
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
    }

    Query query(String pattern) {
        return new Query(pattern);
    }

    private static class QueryEntry {
        public TreeMap<String, Object> tag;
        public Iterator<String> iter;
        public String path;
        int lvl;

        private QueryEntry() {
        }
    }

    public class Query
    implements Iterable<Object> {
        String[] pattern;

        private Query(String pat) {
            this.pattern = pat.split("\\.");
        }

        @Override
        public Iterator<Object> iterator() {
            return new QueryIterator();
        }

        public class QueryIterator
        implements Iterator<Object> {
            ArrayList<QueryEntry> path = new ArrayList();
            String lastentry;

            private QueryIterator() {
                if (!this.step0(0, TagFile.this.contents, "")) {
                    this.step();
                }
            }

            private void step() {
                while (this.path != null) {
                    if (!this.step1()) continue;
                    return;
                }
            }

            private boolean step1() {
                String sp;
                QueryEntry qe = this.path.get(this.path.size() - 1);
                if (!qe.iter.hasNext()) {
                    this.path.remove(this.path.size() - 1);
                    if (this.path.size() == 0) {
                        this.path = null;
                    }
                    return false;
                }
                String str = qe.iter.next();
                String string = sp = qe.path.equals("") ? str : qe.path + "." + str;
                if (qe.lvl == Query.this.pattern.length - 1) {
                    this.lastentry = sp;
                    return true;
                }
                Object ob = qe.tag.get(str);
                return ob instanceof TreeMap && this.step0(qe.lvl + 1, (TreeMap)ob, sp);
            }

            private boolean step0(int lvl0, TreeMap<String, Object> p, String sp) {
                for (int lvl = lvl0; lvl < Query.this.pattern.length; ++lvl) {
                    if (Query.this.pattern[lvl].equals("%")) {
                        QueryEntry var6 = new QueryEntry();
                        var6.path = sp;
                        var6.tag = p;
                        var6.lvl = lvl;
                        var6.iter = p.keySet().iterator();
                        this.path.add(var6);
                        return false;
                    }
                    Object ob = p.get(Query.this.pattern[lvl]);
                    sp = sp.equals("") ? Query.this.pattern[lvl] : sp + "." + Query.this.pattern[lvl];
                    if (!(ob instanceof TreeMap)) {
                        if (lvl != Query.this.pattern.length - 1) break;
                        this.lastentry = sp;
                        return true;
                    }
                    p = (TreeMap)ob;
                }
                this.path.remove(this.path.size() - 1);
                if (this.path.size() == 0) {
                    this.path = null;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                return this.path != null;
            }

            @Override
            public String next() {
                String tr = this.lastentry;
                this.step();
                return tr;
            }

            @Override
            public void remove() {
            }
        }
    }
}

