/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.BlockMultipart;
import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.ICoverable;
import com.eloraam.redpower.core.IMultipart;
import com.eloraam.redpower.core.TileMultipart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeHooks;

public abstract class TileCoverable
extends TileMultipart
implements ICoverable,
IMultipart {
    @Override
    public abstract boolean canAddCover(int var1, int var2);

    @Override
    public abstract boolean tryAddCover(int var1, int var2);

    @Override
    public abstract int tryRemoveCover(int var1);

    @Override
    public abstract int getCover(int var1);

    @Override
    public abstract int getCoverMask();

    @Override
    public boolean isSideSolid(int side) {
        int cm = this.getCoverMask();
        return (cm & 1 << side) > 0;
    }

    @Override
    public boolean isSideNormal(int side) {
        int cm = this.getCoverMask();
        if ((cm & 1 << side) == 0) {
            return false;
        }
        int c = this.getCover(side);
        int n = c >> 8;
        return !CoverLib.isTransparent(c & 0xFF) && (n < 3 || n >= 6 && n <= 9);
    }

    public void addCoverableHarvestContents(List<ItemStack> drops) {
        if (CoverLib.blockCoverPlate != null) {
            for (int i = 0; i < 29; ++i) {
                int j = this.getCover(i);
                if (j < 0) continue;
                drops.add(CoverLib.convertCoverPlate(i, j));
            }
        }
    }

    @Override
    public void addHarvestContents(List<ItemStack> ist) {
        this.addCoverableHarvestContents(ist);
    }

    @Override
    public void onHarvestPart(EntityPlayer player, int part, boolean willHarvest) {
        int i = this.tryRemoveCover(part);
        if (i >= 0) {
            if (willHarvest) {
                this.dropCover(part, i);
            }
            if (this.blockEmpty()) {
                this.deleteBlock();
            }
        }
        this.updateBlock();
    }

    @Override
    public float getPartStrength(EntityPlayer player, int part) {
        int md;
        int i = this.getCover(part);
        if (i < 0) {
            return 0.0f;
        }
        float hv = CoverLib.getMiningHardness(i &= 0xFF);
        if (hv < 0.0f) {
            return 0.0f;
        }
        ItemStack ist = CoverLib.getItemStack(i);
        Block bl = Block.func_149634_a((Item)ist.func_77973_b());
        return !ForgeHooks.canHarvestBlock((Block)bl, (EntityPlayer)player, (int)(md = ist.func_77960_j())) ? 1.0f / hv / 100.0f : player.getBreakSpeed(bl, false, md) / hv / 30.0f;
    }

    @Override
    public void setPartBounds(BlockMultipart block, int part) {
        int i = this.getCover(part);
        float th = CoverLib.getThickness(part, i);
        switch (part) {
            case 0: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, th, 1.0f);
                break;
            }
            case 1: {
                block.func_149676_a(0.0f, 1.0f - th, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 2: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, th);
                break;
            }
            case 3: {
                block.func_149676_a(0.0f, 0.0f, 1.0f - th, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 4: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, th, 1.0f, 1.0f);
                break;
            }
            case 5: {
                block.func_149676_a(1.0f - th, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 6: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, th, th, th);
                break;
            }
            case 7: {
                block.func_149676_a(0.0f, 0.0f, 1.0f - th, th, th, 1.0f);
                break;
            }
            case 8: {
                block.func_149676_a(1.0f - th, 0.0f, 0.0f, 1.0f, th, th);
                break;
            }
            case 9: {
                block.func_149676_a(1.0f - th, 0.0f, 1.0f - th, 1.0f, th, 1.0f);
                break;
            }
            case 10: {
                block.func_149676_a(0.0f, 1.0f - th, 0.0f, th, 1.0f, th);
                break;
            }
            case 11: {
                block.func_149676_a(0.0f, 1.0f - th, 1.0f - th, th, 1.0f, 1.0f);
                break;
            }
            case 12: {
                block.func_149676_a(1.0f - th, 1.0f - th, 0.0f, 1.0f, 1.0f, th);
                break;
            }
            case 13: {
                block.func_149676_a(1.0f - th, 1.0f - th, 1.0f - th, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 14: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, th, th);
                break;
            }
            case 15: {
                block.func_149676_a(0.0f, 0.0f, 1.0f - th, 1.0f, th, 1.0f);
                break;
            }
            case 16: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, th, th, 1.0f);
                break;
            }
            case 17: {
                block.func_149676_a(1.0f - th, 0.0f, 0.0f, 1.0f, th, 1.0f);
                break;
            }
            case 18: {
                block.func_149676_a(0.0f, 0.0f, 0.0f, th, 1.0f, th);
                break;
            }
            case 19: {
                block.func_149676_a(0.0f, 0.0f, 1.0f - th, th, 1.0f, 1.0f);
                break;
            }
            case 20: {
                block.func_149676_a(1.0f - th, 0.0f, 0.0f, 1.0f, 1.0f, th);
                break;
            }
            case 21: {
                block.func_149676_a(1.0f - th, 0.0f, 1.0f - th, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 22: {
                block.func_149676_a(0.0f, 1.0f - th, 0.0f, 1.0f, 1.0f, th);
                break;
            }
            case 23: {
                block.func_149676_a(0.0f, 1.0f - th, 1.0f - th, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 24: {
                block.func_149676_a(0.0f, 1.0f - th, 0.0f, th, 1.0f, 1.0f);
                break;
            }
            case 25: {
                block.func_149676_a(1.0f - th, 1.0f - th, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 26: {
                block.func_149676_a(0.5f - th, 0.0f, 0.5f - th, 0.5f + th, 1.0f, 0.5f + th);
                break;
            }
            case 27: {
                block.func_149676_a(0.5f - th, 0.5f - th, 0.0f, 0.5f + th, 0.5f + th, 1.0f);
                break;
            }
            case 28: {
                block.func_149676_a(0.0f, 0.5f - th, 0.5f - th, 1.0f, 0.5f + th, 0.5f + th);
            }
        }
    }

    @Override
    public int getSolidPartsMask() {
        return this.getCoverMask();
    }

    @Override
    public int getPartsMask() {
        return this.getCoverMask();
    }

    public void dropCover(int side, int cov) {
        ItemStack ist = CoverLib.convertCoverPlate(side, cov);
        if (ist != null) {
            CoreLib.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ist);
        }
    }

    public ItemStack getCover(int part, int side) {
        int i = this.getCover(part);
        if (i >= 0) {
            return CoverLib.convertCoverPlate(side, i);
        }
        ArrayList<ItemStack> ist = new ArrayList<ItemStack>();
        this.addHarvestContents(ist);
        return ist.size() >= 1 ? (ItemStack)ist.get(0) : null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, EntityPlayer player) {
        int i = this.getCover(target.subHit);
        return i > 0 ? CoverLib.convertCoverPlate(target.field_72310_e, i) : this.getBasePickStack();
    }

    protected ItemStack getBasePickStack() {
        return null;
    }

    public float getExplosionResistance(int part, int side, Entity exploder) {
        int i = this.getCover(part);
        if (i < 0) {
            return -1.0f;
        }
        ItemStack ist = CoverLib.getItemStack(i &= 0xFF);
        return Block.func_149634_a((Item)ist.func_77973_b()).func_149638_a(exploder);
    }
}

