/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.CoverLib;
import com.eloraam.redpower.core.IFrameSupport;
import com.eloraam.redpower.core.TileCoverable;
import com.eloraam.redpower.core.TileExtended;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileCovered
extends TileCoverable
implements IFrameSupport {
    public int CoverSides = 0;
    public short[] Covers = new short[29];

    public void replaceWithCovers() {
        GameProfile owner = this.Owner;
        CoverLib.replaceWithCovers(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.CoverSides, this.Covers);
        TileExtended te = CoreLib.getTileEntity((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, TileExtended.class);
        if (te != null) {
            te.Owner = owner;
        }
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public int getExtendedID() {
        return 0;
    }

    @Override
    public void onBlockNeighborChange(Block block) {
        if (this.CoverSides == 0) {
            this.deleteBlock();
        }
        this.func_70296_d();
    }

    public Block func_145838_q() {
        return CoverLib.blockCoverPlate;
    }

    @Override
    public boolean canAddCover(int side, int cover) {
        if ((this.CoverSides & 1 << side) > 0) {
            return false;
        }
        short[] test = Arrays.copyOf(this.Covers, 29);
        test[side] = (short)cover;
        return CoverLib.checkPlacement(this.CoverSides | 1 << side, test, 0, false);
    }

    @Override
    public boolean tryAddCover(int side, int cover) {
        if (!this.canAddCover(side, cover)) {
            return false;
        }
        this.CoverSides |= 1 << side;
        this.Covers[side] = (short)cover;
        this.updateBlockChange();
        return true;
    }

    @Override
    public int tryRemoveCover(int side) {
        if ((this.CoverSides & 1 << side) == 0) {
            return -1;
        }
        this.CoverSides &= ~(1 << side);
        short tr = this.Covers[side];
        this.Covers[side] = 0;
        this.updateBlockChange();
        return tr;
    }

    @Override
    public int getCover(int side) {
        return (this.CoverSides & 1 << side) == 0 ? -1 : this.Covers[side];
    }

    @Override
    public int getCoverMask() {
        return this.CoverSides;
    }

    @Override
    public boolean blockEmpty() {
        return this.CoverSides == 0;
    }

    @Override
    public void onFrameRefresh(IBlockAccess iba) {
    }

    @Override
    public void onFramePickup(IBlockAccess iba) {
    }

    @Override
    public void onFrameDrop() {
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        int mask = data.func_74762_e("cvm") & 0x1FFFFFFF;
        this.CoverSides |= mask;
        byte[] cov = data.func_74770_j("cvs");
        if (cov != null && mask > 0) {
            int sp = 0;
            for (int i = 0; i < 29; ++i) {
                if ((mask & 1 << i) == 0) continue;
                this.Covers[i] = (short)((cov[sp] & 0xFF) + ((cov[sp + 1] & 0xFF) << 8));
                sp += 2;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74768_a("cvm", this.CoverSides);
        byte[] cov = new byte[Integer.bitCount(this.CoverSides) * 2];
        int dp = 0;
        for (int i = 0; i < 29; ++i) {
            if ((this.CoverSides & 1 << i) == 0) continue;
            cov[dp] = (byte)(this.Covers[i] & 0xFF);
            cov[dp + 1] = (byte)(this.Covers[i] >> 8);
            dp += 2;
        }
        data.func_74773_a("cvs", cov);
    }

    @Override
    public void writeFramePacket(NBTTagCompound tag) {
        tag.func_74768_a("cvm", this.CoverSides);
        byte[] cov = new byte[Integer.bitCount(this.CoverSides) * 2];
        int dp = 0;
        for (int i = 0; i < 29; ++i) {
            if ((this.CoverSides & 1 << i) == 0) continue;
            cov[dp] = (byte)(this.Covers[i] & 0xFF);
            cov[dp + 1] = (byte)(this.Covers[i] >> 8);
            dp += 2;
        }
        tag.func_74773_a("cvs", cov);
    }

    @Override
    public void readFramePacket(NBTTagCompound tag) {
        int mask = tag.func_74762_e("cvm");
        this.CoverSides |= mask;
        byte[] cov = tag.func_74770_j("cvs");
        if (cov != null && mask > 0) {
            int sp = 0;
            for (int i = 0; i < 29; ++i) {
                if ((mask & 1 << i) == 0) continue;
                this.Covers[i] = (short)((cov[sp] & 0xFF) + ((cov[sp + 1] & 0xFF) << 8));
                sp += 2;
            }
        }
    }

    @Override
    protected void readFromPacket(NBTTagCompound data) {
        int mask;
        this.CoverSides = mask = data.func_74762_e("cvm") & 0x1FFFFFFF;
        byte[] cov = data.func_74770_j("cvs");
        if (cov != null && mask > 0) {
            int sp = 0;
            for (int i = 0; i < 29; ++i) {
                if ((mask & 1 << i) <= 0) continue;
                this.Covers[i] = (short)((cov[sp] & 0xFF) + ((cov[sp + 1] & 0xFF) << 8));
                sp += 2;
            }
        }
    }

    @Override
    protected void writeToPacket(NBTTagCompound data) {
        data.func_74768_a("cvm", this.CoverSides);
        byte[] cov = new byte[Integer.bitCount(this.CoverSides) * 2];
        int dp = 0;
        for (int i = 0; i < 29; ++i) {
            if ((this.CoverSides & 1 << i) <= 0) continue;
            cov[dp] = (byte)(this.Covers[i] & 0xFF);
            cov[dp + 1] = (byte)(this.Covers[i] >> 8);
            dp += 2;
        }
        data.func_74773_a("cvs", cov);
    }
}

