/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.RedPowerLib;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public abstract class TileExtended
extends TileEntity {
    protected long timeSched = -1L;
    public GameProfile Owner = CoreLib.REDPOWER_PROFILE;

    public void onBlockNeighborChange(Block block) {
    }

    public void onBlockPlaced(ItemStack ist, int side, EntityLivingBase ent) {
        this.updateBlock();
    }

    public void onBlockRemoval() {
    }

    public boolean isBlockStrongPoweringTo(int side) {
        return false;
    }

    public boolean isBlockWeakPoweringTo(int side) {
        return this.isBlockStrongPoweringTo(side);
    }

    public boolean onBlockActivated(EntityPlayer player) {
        return false;
    }

    public void onEntityCollidedWithBlock(Entity ent) {
    }

    public AxisAlignedBB getCollisionBoundingBox() {
        return null;
    }

    public void onTileTick() {
    }

    public int getExtendedID() {
        return 0;
    }

    public int getExtendedMetadata() {
        return 0;
    }

    public void setExtendedMetadata(int md) {
    }

    public void addHarvestContents(List<ItemStack> ist) {
        ist.add(new ItemStack(this.func_145838_q(), 1, this.getExtendedID()));
    }

    public void scheduleTick(int time) {
        long tn = this.field_145850_b.func_82737_E() + (long)time;
        if (this.timeSched <= 0L || this.timeSched >= tn) {
            this.timeSched = tn;
            this.updateBlock();
        }
    }

    public boolean isTickRunnable() {
        return this.timeSched >= 0L && this.timeSched <= this.field_145850_b.func_82737_E();
    }

    public boolean isTickScheduled() {
        return this.timeSched >= 0L;
    }

    public void updateBlockChange() {
        RedPowerLib.updateIndirectNeighbors(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.updateBlock();
    }

    public void updateBlock() {
        this.func_70296_d();
        this.markForUpdate();
    }

    public void markForUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void breakBlock() {
        this.breakBlock(true);
    }

    public void breakBlock(boolean shouldDrop) {
        if (shouldDrop) {
            ArrayList<ItemStack> il = new ArrayList<ItemStack>();
            this.addHarvestContents(il);
            for (ItemStack it : il) {
                CoreLib.dropItem(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, it);
            }
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.timeSched >= 0L) {
            long wtime = this.field_145850_b.func_82737_E();
            if (this.timeSched > wtime + 1200L) {
                this.timeSched = wtime + 1200L;
            } else if (this.timeSched <= wtime) {
                this.timeSched = -1L;
                this.onTileTick();
                this.func_70296_d();
            }
        }
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.timeSched = data.func_74763_f("sched");
        this.Owner = data.func_74764_b("Owner") ? NBTUtil.func_152459_a((NBTTagCompound)data.func_74775_l("Owner")) : CoreLib.REDPOWER_PROFILE;
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74772_a("sched", this.timeSched);
        NBTTagCompound owner = new NBTTagCompound();
        NBTUtil.func_152460_a((NBTTagCompound)owner, (GameProfile)this.Owner);
        data.func_74782_a("Owner", (NBTBase)owner);
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeToPacket(syncData);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e + 1.0));
    }

    public void onDataPacket(NetworkManager netManager, S35PacketUpdateTileEntity packet) {
        this.readFromPacket(packet.func_148857_g());
        this.updateBlock();
    }

    protected void writeToPacket(NBTTagCompound tag) {
    }

    protected void readFromPacket(NBTTagCompound tag) {
    }

    public double func_145833_n() {
        return 65535.0;
    }
}

