/*
 * Decompiled with CFR 0.152.
 */
package com.eloraam.redpower.core;

import com.eloraam.redpower.core.CoreLib;
import com.eloraam.redpower.core.TubeItem;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TubeBuffer {
    LinkedList<TubeItem> buffer = null;
    public boolean plugged = false;

    public boolean isEmpty() {
        return this.buffer == null || this.buffer.size() == 0;
    }

    public TubeItem getLast() {
        return this.buffer == null ? null : this.buffer.getLast();
    }

    public void add(TubeItem ti) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addFirst(ti);
    }

    public void addNew(ItemStack ist) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addFirst(new TubeItem(0, ist));
    }

    public void addNewColor(ItemStack ist, int col) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        TubeItem ti = new TubeItem(0, ist);
        ti.color = (byte)col;
        this.buffer.addFirst(ti);
    }

    public void addAll(Collection<ItemStack> col) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        for (ItemStack ist : col) {
            this.buffer.add(new TubeItem(0, ist));
        }
    }

    public void addBounce(TubeItem ti) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addLast(ti);
        this.plugged = true;
    }

    public void pop() {
        this.buffer.removeLast();
        if (this.buffer.size() == 0) {
            this.plugged = false;
        }
    }

    public int size() {
        return this.buffer == null ? 0 : this.buffer.size();
    }

    public void onRemove(TileEntity te) {
        if (this.buffer != null) {
            for (TubeItem ti : this.buffer) {
                if (ti == null || ti.item.field_77994_a <= 0) continue;
                CoreLib.dropItem(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, ti.item);
            }
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        byte var5;
        NBTTagList items = data.func_150295_c("Buffer", 10);
        if (items.func_74745_c() > 0) {
            this.buffer = new LinkedList();
            for (int b = 0; b < items.func_74745_c(); ++b) {
                NBTTagCompound item = items.func_150305_b(b);
                this.buffer.add(TubeItem.newFromNBT(item));
            }
        }
        this.plugged = (var5 = data.func_74771_c("Plug")) > 0;
    }

    public void writeToNBT(NBTTagCompound data) {
        NBTTagList items = new NBTTagList();
        if (this.buffer != null) {
            for (TubeItem ti : this.buffer) {
                NBTTagCompound item = new NBTTagCompound();
                ti.writeToNBT(item);
                items.func_74742_a((NBTBase)item);
            }
        }
        data.func_74782_a("Buffer", (NBTBase)items);
        data.func_74774_a("Plug", (byte)(this.plugged ? 1 : 0));
    }
}

